/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.XnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.List;

public class CnfTransformer
extends XnfTransformer {
    public CnfTransformer(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        super(managedScript, iUltimateServiceProvider);
    }

    @Override
    protected NnfTransformer.NnfTransformerHelper getNnfTransformerHelper(IUltimateServiceProvider iUltimateServiceProvider) {
        return new CnfTransformerHelper(iUltimateServiceProvider);
    }

    protected class CnfTransformerHelper
    extends XnfTransformer.XnfTransformerHelper {
        protected CnfTransformerHelper(IUltimateServiceProvider iUltimateServiceProvider) {
            super(iUltimateServiceProvider);
        }

        @Override
        public String innerConnectiveSymbol() {
            return "or";
        }

        @Override
        public String outerConnectiveSymbol() {
            return "and";
        }

        @Override
        public String innerJunctionName() {
            return "disjunction";
        }

        @Override
        public String outerJunctionName() {
            return "conjunction";
        }

        @Override
        public Term innerConnective(Script script, List<Term> list) {
            Term term = SmtUtils.or(CnfTransformer.this.mScript, list);
            return term;
        }

        @Override
        public Term outerConnective(Script script, List<Term> list) {
            Term term = SmtUtils.and(CnfTransformer.this.mScript, list);
            return term;
        }

        @Override
        public Term[] getOuterJuncts(Term term) {
            return SmtUtils.getConjuncts(term);
        }
    }
}

