/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.DeclarableFunctionSymbol;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.DeclarableSortSymbol;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class HistoryRecordingScript
extends WrapperScript {
    private final Deque<ISmtDeclarable> mHistory = new ArrayDeque<ISmtDeclarable>();
    private final Map<String, ISmtDeclarable> mSymbolTable = new Hashtable<String, ISmtDeclarable>();
    private int mCurrentStackLevel = 0;

    public HistoryRecordingScript(Script script) {
        super(script);
    }

    public void defineFun(String string, TermVariable[] termVariableArray, Sort sort, Term term) throws SMTLIBException {
        super.defineFun(string, termVariableArray, sort, term);
        this.insert(DeclarableFunctionSymbol.createFromScriptDefineFun(string, termVariableArray, sort, term));
    }

    public void resetAssertions() {
        super.resetAssertions();
        this.removeStackLevelsFromHistory(this.mCurrentStackLevel);
    }

    public void reset() {
        super.reset();
        this.mHistory.clear();
        this.mSymbolTable.clear();
    }

    public void defineSort(String string, Sort[] sortArray, Sort sort) {
        super.defineSort(string, sortArray, sort);
        this.insert(DeclarableSortSymbol.createFromScriptDefineSort(string, sortArray, sort));
    }

    public void declareFun(String string, Sort[] sortArray, Sort sort) {
        super.declareFun(string, sortArray, sort);
        this.insert(DeclarableFunctionSymbol.createFromScriptDeclareFun(string, sortArray, sort));
    }

    public void declareSort(String string, int n) {
        super.declareSort(string, n);
        this.insert(DeclarableSortSymbol.createFromScriptDeclareSort(string, n));
    }

    public void push(int n) {
        super.push(n);
        assert (n > 0);
        int n2 = 0;
        while (n2 < n) {
            this.mHistory.push(StackMarker.INSTANCE);
            ++n2;
        }
        this.mCurrentStackLevel += n;
    }

    public void pop(int n) {
        super.pop(n);
        this.removeStackLevelsFromHistory(n);
    }

    /*
     * Unable to fully structure code
     */
    private void removeStackLevelsFromHistory(int var1_1) {
        if (!HistoryRecordingScript.$assertionsDisabled && var1_1 <= 0) {
            throw new AssertionError();
        }
        var2_2 = this.mHistory.iterator();
        var3_3 = 0;
        var4_4 = 0;
        ** GOTO lbl19
        {
            block6: {
                var5_5 = var2_2.next();
                var2_2.remove();
                if (var5_5 != StackMarker.INSTANCE) break block6;
                ++var3_3;
                ** GOTO lbl18
            }
            var6_6 = this.mSymbolTable.remove(var5_5.getName());
            if (!HistoryRecordingScript.$assertionsDisabled && var6_6 == null) {
                throw new AssertionError();
            }
            do {
                if (var2_2.hasNext()) continue block0;
lbl18:
                // 2 sources

                ++var4_4;
lbl19:
                // 2 sources

            } while (var4_4 < var1_1);
        }
        if (!HistoryRecordingScript.$assertionsDisabled && var3_3 != var1_1) {
            throw new AssertionError();
        }
        this.mCurrentStackLevel -= var1_1;
        if (this.mCurrentStackLevel < 0) {
            this.mCurrentStackLevel = 0;
        }
    }

    private void insert(ISmtDeclarable iSmtDeclarable) {
        this.mHistory.push(iSmtDeclarable);
        ISmtDeclarable iSmtDeclarable2 = this.mSymbolTable.put(iSmtDeclarable.getName(), iSmtDeclarable);
        assert (iSmtDeclarable2 == null) : "overwriting already existing symbol in history: " + String.valueOf(iSmtDeclarable2);
    }

    public void transferHistoryFromRecord(Script script) {
        Iterator<ISmtDeclarable> iterator = this.mHistory.descendingIterator();
        while (iterator.hasNext()) {
            ISmtDeclarable iSmtDeclarable = iterator.next();
            if (iSmtDeclarable instanceof StackMarker) {
                script.push(1);
                continue;
            }
            iSmtDeclarable.defineOrDeclare(script);
        }
    }

    public static void transferHistoryFromRecord(Script script, Script script2) {
        HistoryRecordingScript historyRecordingScript = HistoryRecordingScript.extractHistoryRecordingScript(script);
        if (historyRecordingScript == null) {
            throw new ISmtDeclarable.IllegalSmtDeclarableUsageException("There is no " + String.valueOf(HistoryRecordingScript.class) + " script in " + String.valueOf(script));
        }
        historyRecordingScript.transferHistoryFromRecord(script2);
    }

    public static HistoryRecordingScript extractHistoryRecordingScript(Script script) {
        if (script instanceof HistoryRecordingScript) {
            return (HistoryRecordingScript)script;
        }
        if (script instanceof WrapperScript) {
            return (HistoryRecordingScript)((WrapperScript)script).findBacking(HistoryRecordingScript.class);
        }
        return null;
    }

    public Map<String, ISmtDeclarable> getSymbolTable() {
        return Collections.unmodifiableMap(this.mSymbolTable);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + String.valueOf(this.mHistory);
    }

    private static final class StackMarker
    implements ISmtDeclarable {
        private static final StackMarker INSTANCE = new StackMarker();

        private StackMarker() {
        }

        @Override
        public void defineOrDeclare(Script script) {
            throw new UnsupportedOperationException(this.getClass().getName() + " only marks stacks, it cannot be defined or declared");
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "StackMarker";
        }
    }
}

