/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaLet;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;

public class DiffWrapperScript
extends WrapperScript {
    private ScopedHashMap<Sort, String> mDiffFunctions;
    private ScopedHashSet<Doubleton<Term>> mDiffAxioms;
    private static final String DIFF_FUNCTION_PREFIX = "ULTIMATE@diff";

    public DiffWrapperScript(Script script) {
        super(script);
    }

    public void setLogic(String string) throws UnsupportedOperationException, SMTLIBException {
        this.setLogic(Logics.valueOf((String)string));
    }

    private void setupDiffFunction() {
        Theory theory = this.mScript.term("true", new Term[0]).getSort().getTheory();
        Sort[] sortArray = theory.createSortVariables(new String[]{"Index", "Elem"});
        Sort sort = theory.getSort("Array", sortArray);
        theory.declareInternalPolymorphicFunction("@diff", sortArray, new Sort[]{sort, sort}, sortArray[0], 0);
    }

    public void setLogic(Logics logics) throws UnsupportedOperationException, SMTLIBException {
        this.mScript.setLogic(logics);
        this.setupDiffFunction();
        this.mDiffFunctions = new ScopedHashMap();
        this.mDiffAxioms = new ScopedHashSet();
    }

    public void push(int n) throws SMTLIBException {
        this.mScript.push(n);
        int n2 = 0;
        while (n2 < n) {
            this.mDiffFunctions.beginScope();
            this.mDiffAxioms.beginScope();
            ++n2;
        }
    }

    public void pop(int n) throws SMTLIBException {
        this.mScript.pop(n);
        int n2 = 0;
        while (n2 < n) {
            this.mDiffFunctions.endScope();
            this.mDiffAxioms.endScope();
            ++n2;
        }
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        term = new FormulaUnLet().unlet(term);
        term = new DiffTransformer().transform(term);
        term = new FormulaLet().let(term);
        return this.mScript.assertTerm(term);
    }

    private String wrap(Sort sort) {
        String string;
        int n;
        int n2;
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(sort.getName());
        if (sort.getIndices() != null) {
            stringArray = sort.getIndices();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                stringBuilder.append('@').append(string);
                ++n;
            }
        }
        if (sort.getArguments() != null) {
            stringArray = sort.getArguments();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                stringBuilder.append('_').append(this.wrap((Sort)string));
                ++n;
            }
        }
        return stringBuilder.toString();
    }

    private final class DiffTransformer
    extends TermTransformer {
        private DiffTransformer() {
        }

        private String checkOrDeclare(Sort sort) {
            Object object = (String)DiffWrapperScript.this.mDiffFunctions.get((Object)sort);
            if (object == null) {
                Sort[] sortArray = sort.getArguments();
                Sort sort2 = sortArray[0];
                object = DiffWrapperScript.DIFF_FUNCTION_PREFIX + DiffWrapperScript.this.wrap(sortArray[0]) + DiffWrapperScript.this.wrap(sortArray[1]);
                DiffWrapperScript.this.declareFun((String)object, new Sort[]{sort, sort}, sort2);
                DiffWrapperScript.this.mDiffFunctions.put((Object)sort, object);
            }
            return object;
        }

        private void checkOrAddAxiom(Term term, Doubleton<Term> doubleton) {
            if (DiffWrapperScript.this.mDiffAxioms.add(doubleton)) {
                Term term2 = (Term)doubleton.getOneElement();
                Term term3 = (Term)doubleton.getOtherElement();
                Term term4 = DiffWrapperScript.this.term("select", new Term[]{term2, term});
                Term term5 = DiffWrapperScript.this.term("select", new Term[]{term3, term});
                Term term6 = DiffWrapperScript.this.term("=>", new Term[]{DiffWrapperScript.this.term("=", new Term[]{term4, term5}), DiffWrapperScript.this.term("=", new Term[]{term2, term3})});
                if (term6.getFreeVars().length > 0) {
                    term6 = DiffWrapperScript.this.quantifier(1, term6.getFreeVars(), term6, new Term[0][]);
                }
                DiffWrapperScript.this.mScript.assertTerm(term6);
            }
        }

        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            if (applicationTerm.getFunction().isIntern() && applicationTerm.getFunction().getName() == "@diff") {
                String string = this.checkOrDeclare(termArray[0].getSort().getRealSort());
                Term term = applicationTerm.getTheory().term(string, termArray);
                Doubleton doubleton = new Doubleton((Object)termArray[0], (Object)termArray[1]);
                this.checkOrAddAxiom(term, (Doubleton<Term>)doubleton);
                this.setResult(term);
            } else {
                super.convertApplicationTerm(applicationTerm, termArray);
            }
        }
    }
}

