/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class PatternOptionBuilder {
    public static final Class<String> STRING_VALUE = String.class;
    public static final Class<Object> OBJECT_VALUE = Object.class;
    public static final Class<Number> NUMBER_VALUE = Number.class;
    public static final Class<Date> DATE_VALUE = Date.class;
    public static final Class<?> CLASS_VALUE = Class.class;
    public static final Class<FileInputStream> EXISTING_FILE_VALUE = FileInputStream.class;
    public static final Class<File> FILE_VALUE = File.class;
    public static final Class<File[]> FILES_VALUE = File[].class;
    public static final Class<URL> URL_VALUE = URL.class;
    public static final Class<Boolean> BOOLEAN_VALUE = Boolean.class;
    public static final Class<?> INTEGER_VALUE = Integer.class;

    public static Object getValueClass(char c) {
        switch (c) {
            case '@': {
                return OBJECT_VALUE;
            }
            case ':': {
                return STRING_VALUE;
            }
            case '%': {
                return NUMBER_VALUE;
            }
            case '+': {
                return CLASS_VALUE;
            }
            case '#': {
                return DATE_VALUE;
            }
            case '<': {
                return EXISTING_FILE_VALUE;
            }
            case '>': {
                return FILE_VALUE;
            }
            case '*': {
                return FILES_VALUE;
            }
            case '/': {
                return URL_VALUE;
            }
        }
        return null;
    }

    public static boolean isValueCode(char c) {
        return c == '@' || c == ':' || c == '%' || c == '+' || c == '#' || c == '<' || c == '>' || c == '*' || c == '/' || c == '!';
    }

    public static Options parsePattern(String string) {
        int n = 32;
        boolean bl = false;
        Class clazz = null;
        Options options = new Options();
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.charAt(n2);
            if (!PatternOptionBuilder.isValueCode((char)n3)) {
                if (n != 32) {
                    Option option = Option.builder(String.valueOf((char)n)).hasArg(clazz != null).required(bl).type(clazz).build();
                    options.addOption(option);
                    bl = false;
                    clazz = null;
                    n = 32;
                }
                n = n3;
            } else if (n3 == 33) {
                bl = true;
            } else {
                clazz = (Class)PatternOptionBuilder.getValueClass((char)n3);
            }
            ++n2;
        }
        if (n != 32) {
            Option option = Option.builder(String.valueOf((char)n)).hasArg(clazz != null).required(bl).type(clazz).build();
            options.addOption(option);
        }
        return options;
    }
}

