/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST;

import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.UnaryOperatorAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.VariableExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;

public class UnaryExpressionAST
extends AtsASTNode {
    private static final long serialVersionUID = 1809386058471685881L;
    private UnaryOperatorAST moperator;

    public UnaryExpressionAST(ILocation iLocation) {
        super(iLocation);
        this.mReturnType = Integer.class;
        this.mExpectingType = this.mReturnType;
    }

    public UnaryExpressionAST(ILocation iLocation, VariableExpressionAST variableExpressionAST) {
        super(iLocation);
        this.mReturnType = Integer.class;
        this.mExpectingType = this.mReturnType;
        this.addOutgoingNode(variableExpressionAST);
    }

    public UnaryOperatorAST getOperator() {
        return this.moperator;
    }

    public void setOperator(UnaryOperatorAST unaryOperatorAST) {
        this.moperator = unaryOperatorAST;
    }

    public String toString() {
        return "UnaryExpression [" + this.operatorToString(this.moperator) + "]";
    }

    private String operatorToString(UnaryOperatorAST unaryOperatorAST) {
        switch (unaryOperatorAST) {
            case EXPR_PLUSPLUS: {
                return " expr++ ";
            }
            case EXPR_MINUSMINUS: {
                return " expr-- ";
            }
            case PLUSPLUS_EXPR: {
                return " ++expr ";
            }
            case MINUSMINUS_EXPR: {
                return " --expr ";
            }
        }
        return "";
    }

    public String getOperatorAsString() {
        return this.operatorToString(this.moperator);
    }

    @Override
    public String getAsString() {
        switch (this.moperator) {
            case EXPR_PLUSPLUS: {
                return ((AtsASTNode)((Object)this.mChildren.get(0))).getAsString() + "++";
            }
            case EXPR_MINUSMINUS: {
                return ((AtsASTNode)((Object)this.mChildren.get(0))).getAsString() + "--";
            }
            case PLUSPLUS_EXPR: {
                return "++" + ((AtsASTNode)((Object)this.mChildren.get(0))).getAsString();
            }
            case MINUSMINUS_EXPR: {
                return "--" + ((AtsASTNode)((Object)this.mChildren.get(0))).getAsString();
            }
        }
        return "";
    }
}

