/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Predicate;

public class CsvProviderPartition<T> {
    private Collection<ICsvProvider<T>> mCsvs;

    public CsvProviderPartition(Collection<ICsvProvider<T>> collection) {
        this.mCsvs = collection;
    }

    public CsvProviderPartition(ICsvProvider<T> iCsvProvider, String string) {
        this.mCsvs = this.groupByColumnKeyAndThreshold(iCsvProvider, string, null);
    }

    public CsvProviderPartition(ICsvProvider<T> iCsvProvider, String string, int[] nArray) {
        this.mCsvs = this.groupByColumnKeyAndThreshold(iCsvProvider, string, nArray);
    }

    public Iterable<ICsvProvider<T>> getCsvs() {
        return this.mCsvs;
    }

    public int size() {
        return this.mCsvs.size();
    }

    public ICsvProvider<T> toCsvProvider() {
        if (this.mCsvs.isEmpty()) {
            return new SimpleCsvProvider(Collections.emptyList());
        }
        SimpleCsvProvider<T> simpleCsvProvider = new SimpleCsvProvider<T>(this.mCsvs.iterator().next().getColumnTitles());
        for (ICsvProvider<T> iCsvProvider : this.mCsvs) {
            int n = iCsvProvider.getRowHeaders().size();
            int n2 = 0;
            while (n2 < n) {
                simpleCsvProvider.addRow(iCsvProvider.getRowHeaders().get(n2), iCsvProvider.getRow(n2));
                ++n2;
            }
        }
        return simpleCsvProvider;
    }

    public CsvProviderPartition<T> copy() {
        ArrayList<ICsvProvider<T>> arrayList = new ArrayList<ICsvProvider<T>>();
        for (ICsvProvider<T> iCsvProvider : this.mCsvs) {
            SimpleCsvProvider<T> simpleCsvProvider = new SimpleCsvProvider<T>(iCsvProvider.getColumnTitles());
            arrayList.add(simpleCsvProvider);
            int n = iCsvProvider.getRowHeaders().size();
            int n2 = 0;
            while (n2 < n) {
                simpleCsvProvider.addRow(new ArrayList<T>(iCsvProvider.getRow(n2)));
                ++n2;
            }
        }
        return new CsvProviderPartition<T>(arrayList);
    }

    public void transform(ICsvProviderTransformer<T> iCsvProviderTransformer) {
        ArrayList<ICsvProvider<T>> arrayList = new ArrayList<ICsvProvider<T>>(this.mCsvs.size());
        for (ICsvProvider<T> iCsvProvider : this.mCsvs) {
            arrayList.add(iCsvProviderTransformer.transform(iCsvProvider));
        }
        this.mCsvs = arrayList;
    }

    public void filterGroups(Predicate<ICsvProvider<T>> predicate) {
        ArrayList<ICsvProvider<T>> arrayList = new ArrayList<ICsvProvider<T>>(this.mCsvs.size());
        for (ICsvProvider<T> iCsvProvider : this.mCsvs) {
            if (!predicate.test(iCsvProvider)) continue;
            arrayList.add(iCsvProvider);
        }
        if (arrayList.size() < this.mCsvs.size()) {
            this.mCsvs = arrayList;
        }
    }

    private List<ICsvProvider<T>> groupByColumnKeyAndThreshold(ICsvProvider<T> iCsvProvider, String string, int[] nArray) {
        Collection<Object> collection;
        TreeMap treeMap;
        HashMap hashMap;
        int n = iCsvProvider.getColumnTitles().indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("The CSV key does not exist: " + string);
        }
        if (nArray == null) {
            hashMap = new HashMap();
            treeMap = null;
        } else {
            hashMap = null;
            treeMap = new TreeMap();
        }
        int n2 = iCsvProvider.getRowHeaders().size();
        int n3 = 0;
        while (n3 < n2) {
            Object object;
            SimpleCsvProvider<T> simpleCsvProvider;
            collection = iCsvProvider.getRow(n3);
            T t = collection.get(n);
            assert (nArray == null || t instanceof Integer);
            int n4 = this.getBin(t, nArray);
            ICsvProvider<T> iCsvProvider2 = simpleCsvProvider = nArray == null ? (SimpleCsvProvider<T>)hashMap.get(t) : (ICsvProvider)treeMap.get(n4);
            if (simpleCsvProvider == null) {
                simpleCsvProvider = new SimpleCsvProvider<T>(iCsvProvider.getColumnTitles());
                if (nArray == null) {
                    hashMap.put(t, simpleCsvProvider);
                    object = t.toString();
                } else {
                    treeMap.put(n4, simpleCsvProvider);
                    var14_15 = n4 == 0 ? "(-\\infty" : "[" + Integer.toString(nArray[n4 - 1]);
                    String string2 = n4 == nArray.length ? "\\infty)" : Integer.toString(nArray[n4]) + "]";
                    object = "$n \\in " + (String)((Object)var14_15) + "; " + string2 + "$";
                }
            } else {
                var14_15 = simpleCsvProvider.getRowHeaders();
                object = var14_15.isEmpty() ? t.toString() : (var14_15.get(0) == null ? t.toString() : var14_15.get(0));
            }
            simpleCsvProvider.addRow((String)object, new ArrayList<T>(collection));
            ++n3;
        }
        ArrayList<ICsvProvider<T>> arrayList = new ArrayList<ICsvProvider<T>>();
        collection = nArray == null ? hashMap.values() : treeMap.values();
        arrayList.addAll(collection);
        return arrayList;
    }

    private int getBin(T t, int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = Integer.parseInt(t.toString());
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n < nArray[n2]) {
                return n2;
            }
            ++n2;
        }
        return nArray.length;
    }

    public class AllEntriesNonNullFilter
    implements Predicate<ICsvProvider<T>> {
        @Override
        public boolean test(ICsvProvider<T> iCsvProvider) {
            int n = iCsvProvider.getRowHeaders().size();
            int n2 = 0;
            while (n2 < n) {
                List list = iCsvProvider.getRow(n2);
                for (Object t : list) {
                    if (t != null && !"null".equals(t.toString())) continue;
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

