/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class IteratorConcatenation<E>
implements Iterator<E> {
    private final List<Iterator<E>> mIterators;
    private int mCurrent;
    private E mNext;

    public IteratorConcatenation(List<Iterator<E>> list) {
        this.mIterators = list;
        this.mCurrent = 0;
        this.mNext = this.mIterators.isEmpty() ? null : this.getNext();
    }

    @SafeVarargs
    public IteratorConcatenation(Iterator<E> ... iteratorArray) {
        this(Arrays.asList(iteratorArray));
    }

    private E getNext() {
        Iterator<E> iterator = this.mIterators.get(this.mCurrent);
        while (!iterator.hasNext() && this.mCurrent + 1 < this.mIterators.size()) {
            ++this.mCurrent;
            iterator = this.mIterators.get(this.mCurrent);
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.mNext != null;
    }

    @Override
    public E next() {
        E e = this.mNext;
        this.mNext = this.getNext();
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("IteratorConcatenation is not modifiable");
    }
}

