/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;

public interface IOperation<LETTER, STATE, CRSF extends IStateFactory<STATE>> {
    default public String getOperationName() {
        return IOperation.computeOperationName(this.getClass());
    }

    default public String startMessage() {
        return "Started " + this.getOperationName() + ".";
    }

    default public String exitMessage() {
        return "Finished " + this.getOperationName() + ".";
    }

    public Object getResult();

    public boolean checkResult(CRSF var1) throws AutomataLibraryException;

    default public AutomataOperationStatistics getAutomataOperationStatistics() {
        return null;
    }

    public static <C extends IOperation<?, ?, ?>> String computeOperationName(Class<C> clazz) {
        String string = clazz.getSimpleName();
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }
}

