/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRTermTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonCalculator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Map;

public class FastUPRTermChecker {
    private final ManagedScript mManagedScript;
    private final OctagonCalculator mCalc;
    private Map<IProgramVar, TermVariable> mInVars;
    private Map<IProgramVar, TermVariable> mOutVars;
    private OctConjunction mConjunc;
    private final Script mScript;
    private final FastUPRTermTransformer mTermTransformer;

    public FastUPRTermChecker(FastUPRUtils fastUPRUtils, ManagedScript managedScript, OctagonCalculator octagonCalculator, FastUPRFormulaBuilder fastUPRFormulaBuilder, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mCalc = octagonCalculator;
        this.mManagedScript = managedScript;
        this.mScript = this.mManagedScript.getScript();
        this.mTermTransformer = new FastUPRTermTransformer(this.mScript);
    }

    public void setConjunction(OctConjunction octConjunction) {
        this.mConjunc = octConjunction;
    }

    public void setConjunction(OctConjunction octConjunction, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        this.mConjunc = octConjunction;
        this.mInVars = map;
        this.mOutVars = map2;
    }

    public void setInVars(Map<IProgramVar, TermVariable> map) {
        this.mInVars = map;
    }

    public void setOutVars(Map<IProgramVar, TermVariable> map) {
        this.mOutVars = map;
    }

    public int checkConsistency(int n, int n2) {
        int n3 = 0;
        while (n3 <= 2) {
            if (!this.checkSequentialized(n + n3 * n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private boolean checkSequentialized(int n) {
        Script script = this.mManagedScript.getScript();
        OctConjunction octConjunction = this.mCalc.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, n);
        return this.checkTerm(octConjunction.toTerm(script));
    }

    public boolean checkQuantifiedTerm(Term term) {
        Term term2 = this.mTermTransformer.transformToInt(term);
        Script.LBool lBool = SmtUtils.checkSatTerm((Script)this.mScript, (Term)term2);
        return lBool != Script.LBool.UNSAT;
    }

    public boolean checkTerm(Term term) {
        Term term2 = this.mTermTransformer.transformToInt(term);
        Script.LBool lBool = SmtUtils.checkSatTerm((Script)this.mScript, (Term)term2);
        return lBool.equals((Object)Script.LBool.SAT);
    }
}

