/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.IteratedSymbolicMemory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Loop;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoopAcceleratorLite {
    private final List<TermVariable> mPathCounter;
    private final Map<TermVariable, TermVariable> mNewPathCounter = new HashMap<TermVariable, TermVariable>();
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final IIcfgSymbolTable mOldSymbolTable;

    public LoopAcceleratorLite(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, IIcfgSymbolTable iIcfgSymbolTable) {
        this.mPathCounter = new ArrayList<TermVariable>();
        this.mScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mOldSymbolTable = iIcfgSymbolTable;
    }

    public UnmodifiableTransFormula summarizeLoop(Loop loop) {
        Object object;
        this.mPathCounter.clear();
        this.mNewPathCounter.clear();
        if (SmtUtils.isTrueLiteral((Term)loop.getFormula().getFormula()) || SmtUtils.isFalseLiteral((Term)loop.getFormula().getFormula())) {
            return null;
        }
        for (Backbone object32 : loop.getBackbones()) {
            this.calculateSymbolicMemory(object32, loop);
            if (object32.getCondition() != null) continue;
            return null;
        }
        for (TermVariable termVariable : this.mPathCounter) {
            object = this.mScript.constructFreshTermVariable("tau", this.mScript.getScript().sort("Int", new Sort[0]));
            this.mNewPathCounter.put(termVariable, (TermVariable)object);
        }
        loop.addVar(this.mPathCounter);
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>(this.mNewPathCounter.values());
        loop.addVar(arrayList);
        ArrayList<TermVariable> arrayList2 = new ArrayList<TermVariable>(this.mPathCounter);
        object = new IteratedSymbolicMemory(this.mScript, this.mServices, this.mLogger, loop, (List<TermVariable>)arrayList2, this.mNewPathCounter);
        ((IteratedSymbolicMemory)object).updateMemory();
        ((IteratedSymbolicMemory)object).updateCondition();
        Term term = ((IteratedSymbolicMemory)object).getAbstractCondition();
        if (!loop.getNestedLoops().isEmpty()) {
            for (Loop loop2 : loop.getNestedLoops()) {
                UnmodifiableTransFormula unmodifiableTransFormula2;
                for (UnmodifiableTransFormula unmodifiableTransFormula2 : loop2.getExitConditions()) {
                    term = SmtUtils.or((Script)this.mScript.getScript(), Arrays.asList(term, unmodifiableTransFormula2.getFormula()));
                    ArrayList arrayList3 = new ArrayList(unmodifiableTransFormula2.getAuxVars());
                    loop.addVar(arrayList3);
                    term = loop.updateVars(term, unmodifiableTransFormula2.getInVars(), unmodifiableTransFormula2.getOutVars());
                }
                unmodifiableTransFormula2 = loop.getOutVars();
                for (Map.Entry<IProgramVar, TermVariable> entry : loop2.getOutVars().entrySet()) {
                    if (unmodifiableTransFormula2.containsKey(entry.getKey())) continue;
                    unmodifiableTransFormula2.put((IProgramVar)entry.getKey(), (TermVariable)entry.getValue());
                }
            }
        }
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(loop.getVars());
        UnmodifiableTransFormula unmodifiableTransFormula = LoopAcceleratorLite.buildFormula(this.mScript, term, loop.getInVars(), loop.getOutVars(), hashSet);
        return unmodifiableTransFormula;
    }

    private void calculateSymbolicMemory(Backbone backbone, Loop loop) {
        SimultaneousUpdate simultaneousUpdate;
        try {
            simultaneousUpdate = SimultaneousUpdate.fromTransFormula((IUltimateServiceProvider)this.mServices, (TransFormula)backbone.getFormula(), (ManagedScript)this.mScript);
        }
        catch (SimultaneousUpdate.SimultaneousUpdateException simultaneousUpdateException) {
            throw new IllegalArgumentException(simultaneousUpdateException.getMessage());
        }
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(loop.getVars());
        UnmodifiableTransFormula unmodifiableTransFormula = LoopAcceleratorLite.buildFormula(this.mScript, loop.updateVars(backbone.getFormula().getFormula(), backbone.getFormula().getInVars(), backbone.getFormula().getOutVars()), loop.getInVars(), loop.getOutVars(), hashSet);
        backbone.setFormula((TransFormula)unmodifiableTransFormula);
        SymbolicMemory symbolicMemory = new SymbolicMemory(this.mScript, this.mServices, (TransFormula)unmodifiableTransFormula, this.mOldSymbolTable);
        symbolicMemory.updateVars(simultaneousUpdate.getDeterministicAssignment());
        UnmodifiableTransFormula unmodifiableTransFormula2 = symbolicMemory.updateCondition(TransFormulaUtils.computeGuard((UnmodifiableTransFormula)unmodifiableTransFormula, (ManagedScript)this.mScript, (IUltimateServiceProvider)this.mServices));
        TermVariable termVariable = this.mScript.constructFreshTermVariable("kappa", this.mScript.getScript().sort("Int", new Sort[0]));
        this.mPathCounter.add(termVariable);
        backbone.setPathCounter(termVariable);
        backbone.setCondition(unmodifiableTransFormula2);
        backbone.setSymbolicMemory(symbolicMemory);
    }

    public static UnmodifiableTransFormula buildFormula(ManagedScript managedScript, Term term, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, Set<TermVariable> set) {
        Boolean bl = set.isEmpty();
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(map, map2, true, null, true, null, bl.booleanValue());
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(set, managedScript);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return transFormulaBuilder.finishConstruction(managedScript);
    }
}

