/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IcfgDuplicator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.BlockEncoder;

public class BlockEncodingObserver
implements IUnmanagedObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final BlockEncodingBacktranslator mBacktranslator;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private IIcfg<?> mResult;

    public BlockEncodingObserver(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mBacktranslator = blockEncodingBacktranslator;
        this.mSimplificationTechnique = simplificationTechnique;
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public void finish() throws Throwable {
    }

    public boolean performedChanges() {
        return false;
    }

    public IElement getModel() {
        return this.mResult;
    }

    public boolean process(IElement iElement) throws Exception {
        if (iElement instanceof IIcfg) {
            IIcfg iIcfg = (IIcfg)iElement;
            CfgSmtToolkit cfgSmtToolkit = iIcfg.getCfgSmtToolkit();
            IcfgEdgeBuilder icfgEdgeBuilder = new IcfgEdgeBuilder(cfgSmtToolkit, this.mServices, this.mSimplificationTechnique);
            BasicIcfg basicIcfg = new IcfgDuplicator(this.mLogger, this.mServices, cfgSmtToolkit.getManagedScript(), this.mBacktranslator).copy(iIcfg, "_BEv2", true);
            this.mResult = new BlockEncoder(this.mLogger, this.mServices, this.mBacktranslator, icfgEdgeBuilder, (BasicIcfg<IcfgLocation>)basicIcfg).getResult();
            assert (IcfgUtils.checkMatchingEntryExitNodes(this.mResult)) : "Entry nodes and exit nodes do not match";
            return false;
        }
        return true;
    }
}

