/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.test_generator;

import de.uni_freiburg.informatik.ultimate.smtinterpol.DefaultLogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.test_generator.TBenchmark;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class Main {
    private Main() {
    }

    private static void usage() {
        System.err.println("USAGE smtinterpol [-q] [-v] [-t <num>] [-l <num>] [-r <num>] [file.smt2]");
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        PrintWriter printWriter;
        DefaultLogger defaultLogger = new DefaultLogger();
        int n = 0;
        if (n < stringArray.length) {
            String cfr_ignored_0 = stringArray[n++];
            printWriter = new PrintWriter(stringArray[n++] + "-check.smt2");
        } else {
            printWriter = new PrintWriter(System.out);
        }
        TBenchmark tBenchmark = new TBenchmark((LogProxy)defaultLogger, printWriter);
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            int n2;
            if (stringArray[n].equals("--")) {
                ++n;
                break;
            }
            if (stringArray[n].equals("-v")) {
                tBenchmark.setOption(":verbosity", BigInteger.valueOf(5L));
                ++n;
                continue;
            }
            if (stringArray[n].equals("-q")) {
                tBenchmark.setOption(":verbosity", BigInteger.valueOf(3L));
                ++n;
                continue;
            }
            if (stringArray[n].equals("-t") && ++n < stringArray.length) {
                try {
                    n2 = Integer.parseInt(stringArray[n]);
                    if (n2 < 0) {
                        defaultLogger.error("Cannot parse timeout argument: Negative number");
                    } else {
                        tBenchmark.setOption(":timeout", BigInteger.valueOf(n2));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    defaultLogger.error("Cannot parse timeout argument: Not a number");
                }
                ++n;
                continue;
            }
            if (stringArray[n].equals("-l") && ++n < stringArray.length) {
                try {
                    n2 = Integer.parseInt(stringArray[n]);
                    if (n2 < 0) {
                        defaultLogger.error("Cannot parse reproducible resource limit argument: Negative number");
                    } else {
                        tBenchmark.setOption(":reproducible-resource-limit", BigInteger.valueOf(n2));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    defaultLogger.error("Cannot parse reproducible resource limit argument: Not a number");
                }
                ++n;
                continue;
            }
            if (stringArray[n].equals("-r") && ++n < stringArray.length) {
                try {
                    n2 = Integer.parseInt(stringArray[n]);
                    if (n2 < 0) {
                        defaultLogger.error("Cannot parse random seed argument: Negative number");
                    } else {
                        tBenchmark.setOption(":random-seed", BigInteger.valueOf(n2));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    defaultLogger.error("Cannot parse random seed argument: Not a number");
                }
                ++n;
                continue;
            }
            Main.usage();
            return;
        }
        if (n != stringArray.length) {
            Main.usage();
            return;
        }
    }

    public static List<String> getFiles(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file.isFile()) {
            arrayList.add(file.toString());
            return arrayList;
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile()) {
                arrayList.add(fileArray[n].toString());
            } else if (!fileArray[n].toString().endsWith(".svn")) {
                File file2 = new File(fileArray[n].toString());
                arrayList.addAll(Main.getFiles(file2));
            }
            ++n;
        }
        return arrayList;
    }
}

