/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.translation;

import de.uni_freiburg.informatik.ultimate.core.model.models.ProcedureContract;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import java.util.List;

public class TranslatorConcatenation<STE, ITE, TTE, SE, IE, TE, SVL, IVL, TVL, LOC>
implements ITranslator<STE, TTE, SE, TE, SVL, TVL, LOC> {
    private final ITranslator<STE, ITE, SE, IE, SVL, IVL, LOC> mSource2IntermediateTranslator;
    private final ITranslator<ITE, TTE, IE, TE, IVL, TVL, LOC> mIntermediate2TargetTranslator;

    public TranslatorConcatenation(ITranslator<STE, ITE, SE, IE, SVL, IVL, LOC> iTranslator, ITranslator<ITE, TTE, IE, TE, IVL, TVL, LOC> iTranslator2) {
        this.mSource2IntermediateTranslator = iTranslator;
        this.mIntermediate2TargetTranslator = iTranslator2;
    }

    public Class<? extends STE> getSourceTraceElementClass() {
        return this.mSource2IntermediateTranslator.getSourceTraceElementClass();
    }

    public Class<? extends TTE> getTargetTraceElementClass() {
        return this.mIntermediate2TargetTranslator.getTargetTraceElementClass();
    }

    public Class<SE> getSourceExpressionClass() {
        return this.mSource2IntermediateTranslator.getSourceExpressionClass();
    }

    public Class<TE> getTargetExpressionClass() {
        return this.mIntermediate2TargetTranslator.getTargetExpressionClass();
    }

    public List<TTE> translateTrace(List<STE> list) {
        return this.mIntermediate2TargetTranslator.translateTrace(this.mSource2IntermediateTranslator.translateTrace(list));
    }

    public List<String> targetTraceToString(List<TTE> list) {
        return this.mIntermediate2TargetTranslator.targetTraceToString(list);
    }

    public TE translateExpression(SE SE) {
        return (TE)this.mIntermediate2TargetTranslator.translateExpression(this.mSource2IntermediateTranslator.translateExpression(SE));
    }

    public TE translateExpressionWithContext(SE SE, LOC LOC) {
        return (TE)this.mIntermediate2TargetTranslator.translateExpressionWithContext(this.mSource2IntermediateTranslator.translateExpressionWithContext(SE, LOC), LOC);
    }

    public String targetExpressionToString(TE TE) {
        return this.mIntermediate2TargetTranslator.targetExpressionToString(TE);
    }

    public IProgramExecution<TTE, TE> translateProgramExecution(IProgramExecution<STE, SE> iProgramExecution) {
        return this.mIntermediate2TargetTranslator.translateProgramExecution(this.mSource2IntermediateTranslator.translateProgramExecution(iProgramExecution));
    }

    public IBacktranslatedCFG<TVL, TTE> translateCFG(IBacktranslatedCFG<SVL, STE> iBacktranslatedCFG) {
        return this.mIntermediate2TargetTranslator.translateCFG(this.mSource2IntermediateTranslator.translateCFG(iBacktranslatedCFG));
    }

    public ProcedureContract<TE, ? extends TE> translateProcedureContract(ProcedureContract<SE, ? extends SE> procedureContract, LOC LOC) {
        return this.mIntermediate2TargetTranslator.translateProcedureContract(this.mSource2IntermediateTranslator.translateProcedureContract(procedureContract, LOC), LOC);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" SE=");
        stringBuilder.append(this.getSourceExpressionClass().getName());
        stringBuilder.append(" TE=");
        stringBuilder.append(this.getTargetExpressionClass().getName());
        stringBuilder.append(" STE=");
        stringBuilder.append(this.getSourceTraceElementClass().getName());
        stringBuilder.append(" TTE=");
        stringBuilder.append(this.getTargetTraceElementClass().getName());
        return stringBuilder.toString();
    }

    public IProgramExecution.ProgramState<TE> translateProgramState(IProgramExecution.ProgramState<SE> programState) {
        return this.mIntermediate2TargetTranslator.translateProgramState(this.mSource2IntermediateTranslator.translateProgramState(programState));
    }
}

