/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.internal.core.scannerconfig2;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgScannerConfigUtil;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;

public class CfgScannerConfigInfoFactory2 {
    private static final QualifiedName CONTAINER_INFO_PROPERTY = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "ScannerConfigBuilderInfo2Container");

    public static ICfgScannerConfigBuilderInfo2Set create(IConfiguration cfg) {
        Configuration c = (Configuration)cfg;
        ICfgScannerConfigBuilderInfo2Set container = c.getCfgScannerConfigInfo();
        if (container == null) {
            container = new CfgInfo(c);
            c.setCfgScannerConfigInfo(container);
        }
        return container;
    }

    public static void save(BuildConfigurationData data, ICProjectDescription des, ICProjectDescription baseDescription, boolean force) throws CoreException {
        ContainerInfo info = (ContainerInfo)des.getSessionProperty(CONTAINER_INFO_PROPERTY);
        if (info != null) {
            if (info.matches(baseDescription)) {
                IScannerConfigBuilderInfo2Set baseContainer = info.fContainer;
                baseContainer.save();
            }
            des.setSessionProperty(CONTAINER_INFO_PROPERTY, null);
        } else if (force) {
            Configuration cfg = (Configuration)data.getConfiguration();
            CfgInfo cfgInfo = new CfgInfo(cfg);
            cfg.setCfgScannerConfigInfo(cfgInfo);
            cfgInfo.getInfoMap();
            cfgInfo.getContainer().save();
            des.setSessionProperty(CONTAINER_INFO_PROPERTY, null);
        }
    }

    public static void savePreference(IConfiguration cfg) throws CoreException {
        IScannerConfigBuilderInfo2Set baseContainer;
        ICfgScannerConfigBuilderInfo2Set container = ((Configuration)cfg).getCfgScannerConfigInfo();
        if (container != null && (baseContainer = ((CfgInfo)container).getContainer()) != null) {
            baseContainer.save();
        }
    }

    private static boolean match(ITool t1, ITool t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        if (t1.getId().equals(t2.getId())) {
            return true;
        }
        return CfgScannerConfigInfoFactory2.match(t1.getSuperClass(), t2.getSuperClass());
    }

    private static boolean match(IInputType i1, IInputType i2) {
        if (i1 == null || i2 == null) {
            return false;
        }
        if (i1.getId().equals(i2.getId())) {
            return true;
        }
        return CfgScannerConfigInfoFactory2.match(i1.getSuperClass(), i2.getSuperClass());
    }

    private static class CfgInfo
    implements ICfgScannerConfigBuilderInfo2Set {
        private Configuration cfg;
        private SoftReference<IScannerConfigBuilderInfo2Set> fContainer;

        CfgInfo(Configuration cfg) {
            this.cfg = cfg;
        }

        @Override
        public CfgInfoContext[] getContexts() {
            Map<CfgInfoContext, IScannerConfigBuilderInfo2> map = this.createMap();
            return map.keySet().toArray(new CfgInfoContext[map.size()]);
        }

        @Override
        public IScannerConfigBuilderInfo2 getInfo(CfgInfoContext context) {
            return this.createMap().get(context);
        }

        @Override
        public boolean isPerRcTypeDiscovery() {
            return this.cfg.isPerRcTypeDiscovery();
        }

        private IScannerConfigBuilderInfo2Set getContainer() throws CoreException {
            IScannerConfigBuilderInfo2Set container;
            IScannerConfigBuilderInfo2Set iScannerConfigBuilderInfo2Set = container = this.fContainer != null ? this.fContainer.get() : null;
            if (container == null) {
                if (!this.cfg.isPreference()) {
                    ICProjectDescription projDes;
                    ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(this.cfg);
                    if (cfgDes != null && (projDes = cfgDes.getProjectDescription()) != null) {
                        ContainerInfo cInfo = (ContainerInfo)projDes.getSessionProperty(CONTAINER_INFO_PROPERTY);
                        if (cInfo != null && cInfo.matches(projDes)) {
                            container = cInfo.fContainer;
                        } else {
                            container = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set((IProject)this.cfg.getOwner().getProject());
                            cInfo = new ContainerInfo(projDes, container);
                            projDes.setSessionProperty(CONTAINER_INFO_PROPERTY, (Object)cInfo);
                        }
                    }
                    if (container == null) {
                        container = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set((IProject)this.cfg.getOwner().getProject());
                    }
                } else {
                    Preferences prefs = MakeCorePlugin.getDefault().getPluginPreferences();
                    container = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set((Preferences)prefs, (boolean)false);
                }
            }
            if (this.fContainer == null) {
                this.fContainer = new SoftReference<IScannerConfigBuilderInfo2Set>(container);
            }
            return container;
        }

        private Map<CfgInfoContext, IScannerConfigBuilderInfo2> createMap() {
            HashMap<CfgInfoContext, IScannerConfigBuilderInfo2> map = new HashMap<CfgInfoContext, IScannerConfigBuilderInfo2>();
            try {
                IScannerConfigBuilderInfo2Set container = this.getContainer();
                boolean isPerRcType = this.cfg.isPerRcTypeDiscovery();
                Map baseMap = container.getInfoMap();
                if (!isPerRcType) {
                    CfgInfoContext c = new CfgInfoContext(this.cfg);
                    InfoContext baseContext = c.toInfoContext();
                    IScannerConfigBuilderInfo2 info = container.getInfo(baseContext);
                    if (info == null) {
                        String id = this.cfg.getDiscoveryProfileId();
                        if (id == null) {
                            id = CfgScannerConfigUtil.getFirstProfileId(this.cfg.getFilteredTools());
                        }
                        IScannerConfigBuilderInfo2 prefInfo = null;
                        if (!this.cfg.isPreference()) {
                            IConfiguration prefCfg = ManagedBuildManager.getPreferenceConfiguration(false);
                            ICfgScannerConfigBuilderInfo2Set prefContainer = CfgScannerConfigInfoFactory2.create(prefCfg);
                            prefInfo = prefContainer.getInfo(new CfgInfoContext(prefCfg));
                        }
                        info = prefInfo == null ? (id != null ? container.createInfo(baseContext, id) : container.createInfo(baseContext)) : (id != null ? container.createInfo(baseContext, prefInfo, id) : container.createInfo(baseContext, prefInfo, prefInfo.getSelectedProfileId()));
                    }
                    map.put(new CfgInfoContext(this.cfg), info);
                } else {
                    IResourceInfo[] rcInfos;
                    Map<CfgInfoContext, IScannerConfigBuilderInfo2> configMap = this.getConfigInfoMap(baseMap);
                    IResourceInfo[] prefCfg = rcInfos = this.cfg.getResourceInfos();
                    int prefInfo = rcInfos.length;
                    int n = 0;
                    while (n < prefInfo) {
                        IResourceInfo rcInfo = prefCfg[n];
                        ITool[] tools = rcInfo instanceof IFolderInfo ? ((IFolderInfo)rcInfo).getFilteredTools() : ((IFileInfo)rcInfo).getToolsToInvoke();
                        ITool[] iToolArray = tools;
                        int n2 = tools.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            ITool tool = iToolArray[n3];
                            IInputType[] types = tool.getInputTypes();
                            if (types.length != 0) {
                                IInputType[] iInputTypeArray = types;
                                int n4 = types.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    IInputType inputType = iInputTypeArray[n5];
                                    CfgInfoContext context = new CfgInfoContext(rcInfo, tool, inputType);
                                    if ((context = CfgScannerConfigUtil.adjustPerRcTypeContext(context)) != null && context.getResourceInfo() != null) {
                                        IScannerConfigBuilderInfo2 info = configMap.get(context);
                                        if (info == null && !inputType.isExtensionElement() && inputType.getSuperClass() != null) {
                                            ICConfigurationDescription cfgDescription;
                                            CfgInfoContext superContext = new CfgInfoContext(rcInfo, tool, inputType.getSuperClass());
                                            if ((superContext = CfgScannerConfigUtil.adjustPerRcTypeContext(superContext)) != null && superContext.getResourceInfo() != null) {
                                                info = configMap.get(superContext);
                                            }
                                            String id = null;
                                            for (Map.Entry<CfgInfoContext, IScannerConfigBuilderInfo2> entry : configMap.entrySet()) {
                                                CfgInfoContext cfgInfoCxt = entry.getKey();
                                                if (!CfgScannerConfigInfoFactory2.match(cfgInfoCxt.getInputType(), context.getInputType()) || !CfgScannerConfigInfoFactory2.match(cfgInfoCxt.getTool(), context.getTool().getSuperClass()) || !cfgInfoCxt.getConfiguration().equals(context.getConfiguration())) continue;
                                                id = entry.getValue().getSelectedProfileId();
                                            }
                                            if (id == null && ScannerDiscoveryLegacySupport.isLegacyScannerDiscoveryOn((ICConfigurationDescription)(cfgDescription = ManagedBuildManager.getDescriptionForConfiguration(this.cfg)))) {
                                                id = CfgScannerConfigUtil.getDefaultProfileId(context, true);
                                            }
                                            InfoContext baseContext = context.toInfoContext();
                                            info = info == null ? (id != null ? container.createInfo(baseContext, id) : container.createInfo(baseContext)) : (id != null ? container.createInfo(baseContext, info, id) : container.createInfo(baseContext, info));
                                            if (!(rcInfo instanceof IFolderInfo) || !rcInfo.getPath().isEmpty()) {
                                                container.removeInfo(context.toInfoContext());
                                            }
                                        }
                                        if (info != null) {
                                            map.put(context, info);
                                        }
                                    }
                                    ++n5;
                                }
                            } else if (!this.cfg.isPreference()) {
                                CfgInfoContext context = new CfgInfoContext(rcInfo, tool, null);
                                if ((context = CfgScannerConfigUtil.adjustPerRcTypeContext(context)) != null && context.getResourceInfo() != null) {
                                    IScannerConfigBuilderInfo2 info = configMap.get(context);
                                    if (info == null) {
                                        String id = CfgScannerConfigUtil.getDefaultProfileId(context, true);
                                        InfoContext baseContext = context.toInfoContext();
                                        info = id != null ? container.createInfo(baseContext, id) : container.createInfo(baseContext);
                                    }
                                    if (info != null) {
                                        map.put(context, info);
                                    }
                                }
                            }
                            ++n3;
                        }
                        ++n;
                    }
                    if (!configMap.isEmpty()) {
                        for (Map.Entry<CfgInfoContext, IScannerConfigBuilderInfo2> entry : configMap.entrySet()) {
                            InfoContext baseC;
                            CfgInfoContext c;
                            if (map.containsKey(entry.getKey()) || (c = entry.getKey()).getResourceInfo() == null && c.getTool() == null && c.getInputType() == null || (baseC = c.toInfoContext()).isDefaultContext()) continue;
                            container.removeInfo(baseC);
                        }
                    }
                }
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
            return map;
        }

        private Map<CfgInfoContext, IScannerConfigBuilderInfo2> getConfigInfoMap(Map<InfoContext, IScannerConfigBuilderInfo2> baseMap) {
            HashMap<CfgInfoContext, IScannerConfigBuilderInfo2> map = new HashMap<CfgInfoContext, IScannerConfigBuilderInfo2>();
            for (Map.Entry<InfoContext, IScannerConfigBuilderInfo2> entry : baseMap.entrySet()) {
                InfoContext baseContext = entry.getKey();
                CfgInfoContext c = CfgInfoContext.fromInfoContext(this.cfg, baseContext);
                if (c == null) continue;
                IScannerConfigBuilderInfo2 info = entry.getValue();
                map.put(c, info);
            }
            return map;
        }

        @Override
        public Map<CfgInfoContext, IScannerConfigBuilderInfo2> getInfoMap() {
            return this.createMap();
        }

        @Override
        public void setPerRcTypeDiscovery(boolean on) {
            this.cfg.setPerRcTypeDiscovery(on);
        }

        @Override
        public IScannerConfigBuilderInfo2 applyInfo(CfgInfoContext context, IScannerConfigBuilderInfo2 base) {
            try {
                IScannerConfigBuilderInfo2 newInfo;
                IScannerConfigBuilderInfo2Set container = this.getContainer();
                InfoContext baseContext = context.toInfoContext();
                if (base != null) {
                    newInfo = container.createInfo(baseContext, base);
                } else {
                    if (!baseContext.isDefaultContext()) {
                        container.removeInfo(baseContext);
                    }
                    newInfo = this.getInfo(context);
                }
                return newInfo;
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
                return null;
            }
        }

        @Override
        public IConfiguration getConfiguration() {
            return this.cfg;
        }

        @Override
        public boolean isProfileSupported(CfgInfoContext context, String profileId) {
            if (!this.isPerRcTypeDiscovery()) {
                return true;
            }
            return CfgScannerConfigProfileManager.isPerFileProfile(profileId);
        }
    }

    private static class ContainerInfo {
        int fCode;
        IScannerConfigBuilderInfo2Set fContainer;

        ContainerInfo(ICProjectDescription des, IScannerConfigBuilderInfo2Set container) {
            this.fCode = des.hashCode();
            this.fContainer = container;
        }

        public boolean matches(ICProjectDescription des) {
            return des.hashCode() == this.fCode;
        }
    }
}

