/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwaDd;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaMaxSat2;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSatDirect;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSatDirectBi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateBisimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateXsimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.QuotientNwaConstructor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.FullMultipebbleGameAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.FullMultipebbleGameState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.FullMultipebbleStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.InitialPartitionProcessor;
import de.uni_freiburg.informatik.ultimate.automata.util.HashRelationBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.NestedMapBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionAndMapBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.UnionFindBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Iterator;
import java.util.function.BiPredicate;

public abstract class ReduceNwaFullMultipebbleSimulation<LETTER, STATE, GS extends FullMultipebbleGameState<STATE>>
extends AbstractMinimizeNwaDd<LETTER, STATE> {
    private static final boolean OMIT_MAX_SAT_FOR_FINITE_AUTOMATA = true;
    private static final boolean USE_FULL_PREPROCESSING = false;
    private final IDoubleDeckerAutomaton<LETTER, STATE> mOperand;
    private final AutomataOperationStatistics mStatistics;
    private final Metrie mMetriePreprocessing = Metrie.ASYM;
    private final Metrie mMetriePostprocessing = Metrie.ASYM;

    public ReduceNwaFullMultipebbleSimulation(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, boolean bl) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iDoubleDeckerAutomaton;
        this.printStartMessage();
        long l = System.currentTimeMillis();
        PartitionAndMapBackedSetOfPairs partitionAndMapBackedSetOfPairs = switch (this.mMetriePreprocessing) {
            case Metrie.SYM -> {
                PartitionAndMapBackedSetOfPairs var8_6 = new PartitionAndMapBackedSetOfPairs(((PartitionBackedSetOfPairs)new NwaApproximateBisimulation<LETTER, STATE>(automataLibraryServices, iDoubleDeckerAutomaton, bl ? NwaApproximateXsimulation.SimulationType.ORDINARY : NwaApproximateXsimulation.SimulationType.DIRECT, false).getResult()).getRelation());
                this.mLogger.info((Object)("Initial partition has " + var8_6.getOrConstructPartitionSizeInformation().toString()));
                yield var8_6;
            }
            case Metrie.ASYM -> new NwaApproximateSimulation<LETTER, STATE>(automataLibraryServices, iDoubleDeckerAutomaton, bl ? NwaApproximateXsimulation.SimulationType.ORDINARY : NwaApproximateXsimulation.SimulationType.DIRECT, false).getResult();
            default -> throw new AssertionError((Object)("illegal value " + String.valueOf((Object)this.mMetriePreprocessing)));
        };
        long l2 = System.currentTimeMillis() - l;
        l = System.currentTimeMillis();
        FullMultipebbleStateFactory<STATE, GS> fullMultipebbleStateFactory = this.constructGameFactory(partitionAndMapBackedSetOfPairs);
        try {
            INestedWordAutomaton iNestedWordAutomaton;
            MinimizeNwaMaxSat2 minimizeNwaMaxSat2;
            FullMultipebbleGameAutomaton<LETTER, STATE, GS> fullMultipebbleGameAutomaton = new FullMultipebbleGameAutomaton<LETTER, STATE, GS>(this.mServices, fullMultipebbleStateFactory, partitionAndMapBackedSetOfPairs, iDoubleDeckerAutomaton);
            Pair<IDoubleDeckerAutomaton<LETTER, GS>, Integer> pair = this.computeSimulation(fullMultipebbleGameAutomaton);
            long l3 = System.currentTimeMillis() - l;
            int n = (Integer)pair.getSecond();
            NestedMap2<STATE, STATE, GS> nestedMap2 = fullMultipebbleGameAutomaton.getGameStateMapping();
            if (NestedWordAutomataUtils.isFiniteAutomaton(iDoubleDeckerAutomaton)) {
                minimizeNwaMaxSat2 = null;
                QuotientNwaConstructor<LETTER, STATE> quotientNwaConstructor = new QuotientNwaConstructor<LETTER, STATE>(this.mServices, iMinimizationStateFactory, this.mOperand, this.readoutSymmetricCoreOfSimulationRelation(partitionAndMapBackedSetOfPairs, nestedMap2, (IDoubleDeckerAutomaton)pair.getFirst(), fullMultipebbleStateFactory).getUnionFind(), false);
                iNestedWordAutomaton = quotientNwaConstructor.getResult();
            } else {
                BiPredicate biPredicate = bl ? new MinimizeNwaMaxSat2.RelationBackedBiPredicate(new HashRelationBackedSetOfPairs()) : new MinimizeNwaMaxSat2.TrueBiPredicate();
                MinimizeNwaMaxSat2.Settings settings = new MinimizeNwaMaxSat2.Settings().setFinalNonfinalConstraintPredicate(biPredicate).setAddMapOldState2NewState(false);
                switch (this.mMetriePostprocessing) {
                    case ASYM: {
                        minimizeNwaMaxSat2 = new MinimizeNwaPmaxSatDirect<LETTER, STATE>(this.mServices, iMinimizationStateFactory, this.mOperand, this.readoutExactSimulationRelation(partitionAndMapBackedSetOfPairs, nestedMap2, (IDoubleDeckerAutomaton)pair.getFirst(), fullMultipebbleStateFactory).getRelation(), settings);
                        break;
                    }
                    case SYM: {
                        minimizeNwaMaxSat2 = new MinimizeNwaPmaxSatDirectBi<LETTER, STATE>(this.mServices, iMinimizationStateFactory, this.mOperand, this.readoutSymmetricCoreOfSimulationRelation(partitionAndMapBackedSetOfPairs, nestedMap2, (IDoubleDeckerAutomaton)pair.getFirst(), fullMultipebbleStateFactory), settings);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("illegal value " + String.valueOf((Object)this.mMetriePostprocessing)));
                    }
                }
                iNestedWordAutomaton = minimizeNwaMaxSat2.getResult();
            }
            super.directResultConstruction(iNestedWordAutomaton);
            this.mStatistics = this.collectStatistics(partitionAndMapBackedSetOfPairs, fullMultipebbleStateFactory, n, l2, l3, minimizeNwaMaxSat2);
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            if (partitionAndMapBackedSetOfPairs instanceof PartitionBackedSetOfPairs) {
                PartitionBackedSetOfPairs partitionBackedSetOfPairs = partitionAndMapBackedSetOfPairs;
                RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), NestedWordAutomataUtils.generateGenericMinimizationRunningTaskDescription(this.getOperationName(), this.mOperand, partitionBackedSetOfPairs.getOrConstructPartitionSizeInformation()));
                automataOperationCanceledException.addRunningTaskInfo(runningTaskInfo);
            } else {
                this.addGenericRunningTaskInfo(automataOperationCanceledException);
            }
            throw automataOperationCanceledException;
        }
        this.printExitMessage();
    }

    private AutomataOperationStatistics collectStatistics(ISetOfPairs<STATE, ?> iSetOfPairs, FullMultipebbleStateFactory<STATE, GS> fullMultipebbleStateFactory, int n, long l, long l2, MinimizeNwaMaxSat2<LETTER, STATE, ?> minimizeNwaMaxSat2) {
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        automataOperationStatistics.addKeyValuePair(StatisticsType.MAX_NUMBER_OF_DOUBLEDECKER_PEBBLES, fullMultipebbleStateFactory.getMaxNumberOfDoubleDeckerPebbles());
        automataOperationStatistics.addKeyValuePair(StatisticsType.TIME_PREPROCESSING, l);
        automataOperationStatistics.addKeyValuePair(StatisticsType.TIME_SIMULATION, l2);
        if (iSetOfPairs instanceof PartitionBackedSetOfPairs) {
            PartitionBackedSetOfPairs partitionBackedSetOfPairs = (PartitionBackedSetOfPairs)iSetOfPairs;
            automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_INITIAL_PAIRS, partitionBackedSetOfPairs.getOrConstructPartitionSizeInformation().getNumberOfPairs());
            automataOperationStatistics.addKeyValuePair(StatisticsType.SIZE_INITIAL_PARTITION, partitionBackedSetOfPairs.getOrConstructPartitionSizeInformation().getNumberOfBlocks());
            automataOperationStatistics.addKeyValuePair(StatisticsType.SIZE_MAXIMAL_INITIAL_BLOCK, partitionBackedSetOfPairs.getOrConstructPartitionSizeInformation().getSizeOfLargestBlock());
        } else {
            long l3 = 0L;
            Iterator iterator = iSetOfPairs.iterator();
            while (iterator.hasNext()) {
                ++l3;
                iterator.next();
            }
            automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_INITIAL_PAIRS, l3);
        }
        automataOperationStatistics.addKeyValuePair(StatisticsType.SIZE_GAME_AUTOMATON, n);
        if (minimizeNwaMaxSat2 != null) {
            minimizeNwaMaxSat2.addStatistics(automataOperationStatistics);
        }
        return automataOperationStatistics;
    }

    protected abstract Pair<IDoubleDeckerAutomaton<LETTER, GS>, Integer> computeSimulation(FullMultipebbleGameAutomaton<LETTER, STATE, GS> var1) throws AutomataOperationCanceledException;

    protected abstract FullMultipebbleStateFactory<STATE, GS> constructGameFactory(ISetOfPairs<STATE, ?> var1);

    private boolean isInSimulationRelation(STATE STATE, STATE STATE2, FullMultipebbleStateFactory<STATE, ?> fullMultipebbleStateFactory, NestedMap2<STATE, STATE, GS> nestedMap2, IDoubleDeckerAutomaton<LETTER, GS> iDoubleDeckerAutomaton) {
        if (fullMultipebbleStateFactory.isImmediatelyWinningForSpoiler(STATE, STATE2, this.mOperand)) {
            return false;
        }
        FullMultipebbleGameState fullMultipebbleGameState = (FullMultipebbleGameState)nestedMap2.get(STATE, STATE2);
        return !iDoubleDeckerAutomaton.isInitial(fullMultipebbleGameState);
    }

    private UnionFindBackedSetOfPairs<STATE> readoutSymmetricCoreOfSimulationRelation(ISetOfPairs<STATE, ?> iSetOfPairs, NestedMap2<STATE, STATE, GS> nestedMap2, IDoubleDeckerAutomaton<LETTER, GS> iDoubleDeckerAutomaton, FullMultipebbleStateFactory<STATE, ?> fullMultipebbleStateFactory) {
        UnionFindBackedSetOfPairs<Object> unionFindBackedSetOfPairs = new UnionFindBackedSetOfPairs<Object>();
        for (Pair pair : iSetOfPairs) {
            Object object = pair.getFirst();
            Object object2 = pair.getSecond();
            if (!iSetOfPairs.containsPair(object2, object) || !this.isInSimulationRelation(object, object2, fullMultipebbleStateFactory, nestedMap2, iDoubleDeckerAutomaton) || !this.isInSimulationRelation(object2, object, fullMultipebbleStateFactory, nestedMap2, iDoubleDeckerAutomaton)) continue;
            unionFindBackedSetOfPairs.addPair(object, object2);
        }
        return unionFindBackedSetOfPairs;
    }

    private NestedMapBackedSetOfPairs<STATE> readoutExactSimulationRelation(ISetOfPairs<STATE, ?> iSetOfPairs, NestedMap2<STATE, STATE, GS> nestedMap2, IDoubleDeckerAutomaton<LETTER, GS> iDoubleDeckerAutomaton, FullMultipebbleStateFactory<STATE, ?> fullMultipebbleStateFactory) {
        NestedMapBackedSetOfPairs<Object> nestedMapBackedSetOfPairs = new NestedMapBackedSetOfPairs<Object>();
        for (Pair pair : iSetOfPairs) {
            Object object;
            Object object2 = pair.getFirst();
            if (!this.isInSimulationRelation(object2, object = pair.getSecond(), fullMultipebbleStateFactory, nestedMap2, iDoubleDeckerAutomaton)) continue;
            nestedMapBackedSetOfPairs.addPair(object2, object);
        }
        return nestedMapBackedSetOfPairs;
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = super.getAutomataOperationStatistics();
        automataOperationStatistics.addAllStatistics(this.mStatistics);
        return automataOperationStatistics;
    }

    private static enum Metrie {
        SYM,
        ASYM;

    }

    private class ReadoutSimulation
    extends InitialPartitionProcessor<STATE> {
        private final NestedMap2<STATE, STATE, GS> mGameStateMapping;
        private final IDoubleDeckerAutomaton<LETTER, GS> mRemoved;
        private final UnionFind<STATE> mMutuallySimulating;
        private final FullMultipebbleStateFactory<STATE, ?> mGameFactory;

        public ReadoutSimulation(NestedMap2<STATE, STATE, GS> nestedMap2, IDoubleDeckerAutomaton<LETTER, GS> iDoubleDeckerAutomaton, FullMultipebbleStateFactory<STATE, ?> fullMultipebbleStateFactory) {
            super(ReduceNwaFullMultipebbleSimulation.this.mServices);
            this.mGameStateMapping = nestedMap2;
            this.mRemoved = iDoubleDeckerAutomaton;
            this.mGameFactory = fullMultipebbleStateFactory;
            this.mMutuallySimulating = new UnionFind();
        }

        @Override
        public boolean shouldBeProcessed(STATE STATE, STATE STATE2) {
            return ReduceNwaFullMultipebbleSimulation.this.isInSimulationRelation(STATE, STATE2, this.mGameFactory, this.mGameStateMapping, this.mRemoved) && ReduceNwaFullMultipebbleSimulation.this.isInSimulationRelation(STATE2, STATE, this.mGameFactory, this.mGameStateMapping, this.mRemoved);
        }

        @Override
        public void doProcess(STATE STATE, STATE STATE2) {
            Object object = this.mMutuallySimulating.findAndConstructEquivalenceClassIfNeeded(STATE);
            Object object2 = this.mMutuallySimulating.findAndConstructEquivalenceClassIfNeeded(STATE2);
            this.mMutuallySimulating.union(object, object2);
        }

        public UnionFind<STATE> getMutuallySimulating() {
            return this.mMutuallySimulating;
        }
    }
}

