/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class ArrayGroup {
    private final Set<IProgramVarOrConst> mArraysInThisGroup;
    private final int mDimensionality;

    public ArrayGroup(Set<IProgramVarOrConst> set) {
        this.mArraysInThisGroup = Collections.unmodifiableSet(set);
        MultiDimensionalSort multiDimensionalSort = new MultiDimensionalSort(set.iterator().next().getSort());
        this.mDimensionality = multiDimensionalSort.getDimension();
    }

    public Set<IProgramVarOrConst> getArrays() {
        return this.mArraysInThisGroup;
    }

    public String toString() {
        return this.mArraysInThisGroup.toString();
    }

    public int getDimensionality() {
        return this.mDimensionality;
    }

    public int hashCode() {
        return Objects.hash(this.mArraysInThisGroup);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ArrayGroup arrayGroup = (ArrayGroup)object;
        return !(this.mArraysInThisGroup == null ? arrayGroup.mArraysInThisGroup != null : !this.mArraysInThisGroup.equals(arrayGroup.mArraysInThisGroup));
    }

    public static ArrayGroup getNoArrayGroup() {
        return new NoArrayGroup();
    }

    private static class NoArrayGroup
    extends ArrayGroup {
        public NoArrayGroup() {
            super(Collections.emptySet());
        }

        @Override
        public Set<IProgramVarOrConst> getArrays() {
            return Collections.emptySet();
        }

        @Override
        public String toString() {
            return "NoArrayGroup";
        }

        @Override
        public int getDimensionality() {
            return -1;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass();
        }
    }
}

