/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc;

import de.uni_freiburg.informatik.ultimate.lib.chc.ChcAsserter;
import de.uni_freiburg.informatik.ultimate.lib.chc.Derivation;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.chc.IChcScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SmtChcScript
implements IChcScript,
AutoCloseable {
    private static final boolean ADD_COMMENTS = false;
    private static final boolean DECLARE_FUNCTIONS = false;
    private final ManagedScript mMgdScript;
    private boolean mProduceUnsatCores;
    private boolean mIsPushed;
    private Map<String, HornClause> mName2Clause;

    public SmtChcScript(ManagedScript managedScript) {
        this.mMgdScript = managedScript;
        this.mMgdScript.lock((Object)this);
    }

    @Override
    public Script getScript() {
        return this.mMgdScript.getScript();
    }

    @Override
    public Script.LBool solve(HcSymbolTable hcSymbolTable, List<HornClause> list) {
        this.reset();
        this.mMgdScript.push((Object)this, 1);
        this.mIsPushed = true;
        this.mMgdScript.unlock((Object)this);
        ChcAsserter chcAsserter = new ChcAsserter(this.mMgdScript, this.getScript(), this.mProduceUnsatCores, false, false);
        chcAsserter.assertClauses(hcSymbolTable, list);
        this.mMgdScript.lock((Object)this);
        this.mName2Clause = chcAsserter.getName2Clause();
        return this.mMgdScript.checkSat((Object)this);
    }

    @Override
    public Script.LBool solve(HcSymbolTable hcSymbolTable, List<HornClause> list, long l) {
        this.mMgdScript.getScript().setOption(":timeout", (Object)l);
        try {
            Script.LBool lBool = this.solve(hcSymbolTable, list);
            return lBool;
        }
        finally {
            try {
                this.mMgdScript.getScript().setOption(":timeout", (Object)0L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public boolean supportsModelProduction() {
        return true;
    }

    @Override
    public void produceModels(boolean bl) {
        this.getScript().setOption(":produce-models", (Object)bl);
    }

    @Override
    public Optional<Model> getModel() {
        return Optional.ofNullable(this.getScript().getModel());
    }

    @Override
    public boolean supportsDerivationProduction() {
        return false;
    }

    @Override
    public void produceDerivations(boolean bl) {
        throw new UnsupportedOperationException("Derivations are not supported");
    }

    @Override
    public Optional<Derivation> getDerivation() {
        throw new UnsupportedOperationException("Derivations are not supported");
    }

    @Override
    public boolean supportsUnsatCores() {
        return true;
    }

    @Override
    public void produceUnsatCores(boolean bl) {
        this.getScript().setOption(":produce-unsat-cores", (Object)bl);
        this.mProduceUnsatCores = bl;
    }

    @Override
    public Optional<Set<HornClause>> getUnsatCore() {
        Term[] termArray = this.mMgdScript.getUnsatCore((Object)this);
        HashSet<HornClause> hashSet = new HashSet<HornClause>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            assert (term instanceof ApplicationTerm) : "Expected only term names in UNSAT core, but got " + String.valueOf(term);
            String string = ((ApplicationTerm)term).getFunction().getName();
            hashSet.add(this.mName2Clause.get(string));
            ++n2;
        }
        return Optional.of(hashSet);
    }

    private void reset() {
        this.mName2Clause = null;
        if (this.mIsPushed) {
            this.mMgdScript.pop((Object)this, 1);
        }
    }

    @Override
    public void close() throws Exception {
        this.reset();
        this.mMgdScript.unlock((Object)this);
    }
}

