/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryNumericRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.IBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.ExplicitLhsPolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class DualJunctionTir
extends DualJunctionQuantifierElimination {
    private static final boolean DEBUG_ERROR_ON_LARGE_OUTPUT = false;
    private static final boolean HANDLE_DER_OPERATOR = false;
    private static final boolean COMPARE_TO_OLD_RESULT = false;
    private static final boolean ERROR_FOR_OMEGA_TEST_APPLICABILITY = false;
    private static final boolean SIMPLIFYDDA_AFTER_DIV_INTRODUCTION = true;
    private final boolean mSupportAntiDerTerms;

    public DualJunctionTir(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, boolean bl) {
        super(managedScript, iUltimateServiceProvider);
        this.mSupportAntiDerTerms = bl;
    }

    @Override
    public String getName() {
        return "transitive inequality resolution";
    }

    @Override
    public String getAcronym() {
        return "TIR";
    }

    @Override
    public DualJunctionQuantifierElimination.EliminationResult tryToEliminate(EliminationTask eliminationTask) {
        DualJunctionQuantifierElimination.EliminationResult eliminationResult = this.tryToEliminateOne(eliminationTask);
        return eliminationResult;
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne(EliminationTask eliminationTask) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(eliminationTask.getEliminatees());
        hashSet.addAll(eliminationTask.getContext().getBoundByAncestors());
        TreeMap<TirPossibility.CostEstimation, List> treeMap = new TreeMap<TirPossibility.CostEstimation, List>();
        for (TermVariable object : eliminationTask.getEliminatees()) {
            TirPossibility tirPossibility = DualJunctionTir.tryToEliminateConjuncts(this.mServices, this.mScript, eliminationTask.getQuantifier(), eliminationTask.getTerm(), object, hashSet, this.mSupportAntiDerTerms);
            if (tirPossibility == null) continue;
            List list = treeMap.computeIfAbsent(tirPossibility.getCostEstimation(), costEstimation -> new ArrayList());
            list.add(tirPossibility);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            for (TirPossibility tirPossibility : (List)entry.getValue()) {
                Term term;
                Term term2 = tirPossibility.getElprs().buildBoundConstraint(this.mServices, this.mScript, eliminationTask.getQuantifier(), hashSet);
                if (term2 == null) continue;
                ArrayList<Term> arrayList = new ArrayList<Term>(tirPossibility.getWithoutEliminatee());
                arrayList.add(term2);
                Term term3 = QuantifierUtils.applyDualFiniteConnective(this.mScript, eliminationTask.getQuantifier(), arrayList);
                if (tirPossibility.getCostEstimation().getDifficulty() == TirPossibility.Difficulty.NO_SIDE_ONE) {
                    Term term4 = SmtUtils.simplify(this.mMgdScript, term3, eliminationTask.getContext().getCriticalConstraint(), this.mServices, SmtUtils.SimplificationTechnique.POLY_PAC);
                    SmtUtils.ExtendedSimplificationResult extendedSimplificationResult = SmtUtils.simplifyWithStatistics(this.mMgdScript, term4, eliminationTask.getContext().getCriticalConstraint(), this.mServices, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
                    term = extendedSimplificationResult.getSimplifiedTerm();
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug((Object)String.format("TIR eliminated %s via div, SimplifyDDA %s", tirPossibility.getEliminatee(), extendedSimplificationResult.buildSizeReductionMessage()));
                    }
                } else {
                    term = term3;
                }
                return new DualJunctionQuantifierElimination.EliminationResult(eliminationTask.update(term), Collections.emptySet());
            }
        }
        return null;
    }

    public static TirPossibility tryToEliminateConjuncts(IUltimateServiceProvider iUltimateServiceProvider, Script script, int n, Term term2, TermVariable termVariable, Set<TermVariable> set, boolean bl) {
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(n, term2);
        List<Term> list = Arrays.stream(termArray).filter(term -> Arrays.asList(term.getFreeVars()).contains(termVariable)).collect(Collectors.toList());
        List<Term> list2 = Arrays.stream(termArray).filter(term -> !Arrays.asList(term.getFreeVars()).contains(termVariable)).collect(Collectors.toList());
        ExplicitLhsPolynomialRelations explicitLhsPolynomialRelations = DualJunctionTir.convert(list, script, termVariable, n);
        if (explicitLhsPolynomialRelations == null) {
            return null;
        }
        if (!bl && !explicitLhsPolynomialRelations.getAntiDerRelations().isEmpty()) {
            return null;
        }
        ExplicitLhsPolynomialRelations explicitLhsPolynomialRelations2 = DualJunctionTir.makeTight(explicitLhsPolynomialRelations);
        return new TirPossibility(termVariable, explicitLhsPolynomialRelations2, list2);
    }

    private static ExplicitLhsPolynomialRelations makeTight(ExplicitLhsPolynomialRelations explicitLhsPolynomialRelations) {
        ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation;
        ExplicitLhsPolynomialRelations explicitLhsPolynomialRelations2 = new ExplicitLhsPolynomialRelations(explicitLhsPolynomialRelations.getSort());
        for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation2 : explicitLhsPolynomialRelations.getLowerBounds()) {
            explicitLhsPolynomialRelation = explicitLhsPolynomialRelation2.makeTight();
            explicitLhsPolynomialRelations2.addSimpleRelation(explicitLhsPolynomialRelation);
        }
        for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation2 : explicitLhsPolynomialRelations.getUpperBounds()) {
            explicitLhsPolynomialRelation = explicitLhsPolynomialRelation2.makeTight();
            explicitLhsPolynomialRelations2.addSimpleRelation(explicitLhsPolynomialRelation);
        }
        for (Pair pair : explicitLhsPolynomialRelations.getAntiDerRelations()) {
            explicitLhsPolynomialRelation = ((ExplicitLhsPolynomialRelation)pair.getFirst()).makeTight();
            ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation3 = ((ExplicitLhsPolynomialRelation)pair.getSecond()).makeTight();
            Sort sort = ((ExplicitLhsPolynomialRelation)pair.getFirst()).getLhsMonomial().getSort();
            if (ExplicitLhsPolynomialRelation.swapOfRelationSymbolRequired(((ExplicitLhsPolynomialRelation)pair.getFirst()).getLhsCoefficient(), sort)) {
                assert (ExplicitLhsPolynomialRelation.swapOfRelationSymbolRequired(((ExplicitLhsPolynomialRelation)pair.getSecond()).getLhsCoefficient(), sort));
                explicitLhsPolynomialRelations2.addAntiDerRelation(explicitLhsPolynomialRelation3, explicitLhsPolynomialRelation);
                continue;
            }
            explicitLhsPolynomialRelations2.addAntiDerRelation(explicitLhsPolynomialRelation, explicitLhsPolynomialRelation3);
        }
        return explicitLhsPolynomialRelations2;
    }

    private static ExplicitLhsPolynomialRelations convert(List<Term> list, Script script, TermVariable termVariable, int n) {
        Object object;
        Object object2;
        IBinaryRelation iBinaryRelation;
        Object object32;
        PolynomialRelation.TransformInequality transformInequality;
        ExplicitLhsPolynomialRelations explicitLhsPolynomialRelations = new ExplicitLhsPolynomialRelations(termVariable.getSort());
        ArrayList<ExplicitLhsPolynomialRelation> arrayList = new ArrayList<ExplicitLhsPolynomialRelation>();
        if (!SmtSortUtils.isIntSort(termVariable.getSort())) {
            transformInequality = PolynomialRelation.TransformInequality.NO_TRANFORMATION;
        } else if (n == 0) {
            transformInequality = PolynomialRelation.TransformInequality.STRICT2NONSTRICT;
        } else if (n == 1) {
            transformInequality = PolynomialRelation.TransformInequality.NONSTRICT2STRICT;
        } else {
            throw new AssertionError((Object)"Unknown quantifier");
        }
        for (Object object32 : list) {
            ExplicitLhsPolynomialRelation bl;
            PolynomialRelation polynomialRelation = PolynomialRelation.of(script, object32, transformInequality);
            if (polynomialRelation == null) {
                iBinaryRelation = BinaryNumericRelation.convert(object32);
                if (iBinaryRelation == null) {
                    return null;
                }
                object2 = iBinaryRelation.solveForSubject(script, (Term)termVariable);
                if (object2 == null) {
                    return null;
                }
                object = PolynomialTermTransformer.convert(script, ((SolvedBinaryRelation)object2).getRightHandSide());
                bl = new ExplicitLhsPolynomialRelation(((SolvedBinaryRelation)object2).getRelationSymbol(), Rational.ONE, new Monomial(((SolvedBinaryRelation)object2).getLeftHandSide(), Rational.ONE), (IPolynomialTerm)object);
            } else {
                bl = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, (Term)termVariable, polynomialRelation);
                if (bl == null) {
                    return null;
                }
                if (!bl.getLhsMonomial().isLinear()) {
                    return null;
                }
                if (SmtSortUtils.isBitvecSort(bl.getLhsMonomial().getSort()) && bl.getLhsCoefficient() != Rational.ONE && !SmtUtils.isBvMinusOneButNotOne(bl.getLhsCoefficient(), bl.getLhsMonomial().getSort())) {
                    return null;
                }
            }
            switch (bl.getRelationSymbol()) {
                case LEQ: 
                case GEQ: 
                case LESS: 
                case GREATER: 
                case BVULE: 
                case BVULT: 
                case BVUGE: 
                case BVUGT: 
                case BVSLE: 
                case BVSLT: 
                case BVSGE: 
                case BVSGT: {
                    explicitLhsPolynomialRelations.addSimpleRelation(bl);
                    break;
                }
                case EQ: 
                case DISTINCT: {
                    arrayList.add(bl);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown relation " + String.valueOf((Object)bl.getRelationSymbol())));
                }
            }
        }
        if (SmtSortUtils.isBitvecSort(termVariable.getSort())) {
            object32 = DualJunctionTir.determineBvSignedness(explicitLhsPolynomialRelations.getLowerBounds(), explicitLhsPolynomialRelations.getUpperBounds());
            if (object32 == null) {
                return null;
            }
        } else {
            object32 = null;
        }
        for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation : arrayList) {
            boolean bl;
            switch (explicitLhsPolynomialRelation.getRelationSymbol()) {
                case LEQ: 
                case GEQ: 
                case LESS: 
                case GREATER: 
                case BVULE: 
                case BVULT: 
                case BVUGE: 
                case BVUGT: 
                case BVSLE: 
                case BVSLT: 
                case BVSGE: 
                case BVSGT: {
                    throw new AssertionError((Object)"Should have been handled above.");
                }
                case EQ: {
                    if (n == 0) {
                        return null;
                    }
                    if (n == 1) {
                        bl = false;
                        break;
                    }
                    throw new AssertionError((Object)"unknown quantifier");
                }
                case DISTINCT: {
                    if (n == 0) {
                        bl = true;
                        break;
                    }
                    if (n == 1) {
                        return null;
                    }
                    throw new AssertionError((Object)"unknown quantifier");
                }
                default: {
                    throw new AssertionError((Object)("unknown relation " + String.valueOf((Object)explicitLhsPolynomialRelation.getRelationSymbol())));
                }
            }
            object2 = RelationSymbol.getGreaterRelationSymbol(bl, termVariable.getSort(), (RelationSymbol.BvSignedness)((Object)object32));
            iBinaryRelation = SmtSortUtils.isIntSort(explicitLhsPolynomialRelation.getRhs().getSort()) ? explicitLhsPolynomialRelation.changeRelationSymbol((RelationSymbol)((Object)object2)).changeStrictness(transformInequality) : explicitLhsPolynomialRelation.changeRelationSymbol((RelationSymbol)((Object)object2));
            object = RelationSymbol.getLessRelationSymbol(bl, termVariable.getSort(), (RelationSymbol.BvSignedness)((Object)object32));
            object2 = SmtSortUtils.isIntSort(explicitLhsPolynomialRelation.getRhs().getSort()) ? explicitLhsPolynomialRelation.changeRelationSymbol((RelationSymbol)((Object)object)).changeStrictness(transformInequality) : explicitLhsPolynomialRelation.changeRelationSymbol((RelationSymbol)((Object)object));
            explicitLhsPolynomialRelations.addAntiDerRelation((ExplicitLhsPolynomialRelation)iBinaryRelation, (ExplicitLhsPolynomialRelation)object2);
        }
        return explicitLhsPolynomialRelations;
    }

    private static RelationSymbol.BvSignedness determineBvSignedness(List<ExplicitLhsPolynomialRelation> list, List<ExplicitLhsPolynomialRelation> list2) {
        RelationSymbol.BvSignedness bvSignedness;
        EnumSet<RelationSymbol.BvSignedness> enumSet = DualJunctionTir.collectBvSignednesses(list, list2);
        if (enumSet.equals(EnumSet.allOf(RelationSymbol.BvSignedness.class))) {
            bvSignedness = null;
        } else if (enumSet.equals(EnumSet.of(RelationSymbol.BvSignedness.UNSIGNED))) {
            bvSignedness = RelationSymbol.BvSignedness.UNSIGNED;
        } else if (enumSet.equals(EnumSet.of(RelationSymbol.BvSignedness.SIGNED))) {
            bvSignedness = RelationSymbol.BvSignedness.SIGNED;
        } else {
            assert (enumSet.equals(EnumSet.noneOf(RelationSymbol.BvSignedness.class)));
            assert (list.isEmpty() && list2.isEmpty());
            bvSignedness = RelationSymbol.BvSignedness.UNSIGNED;
        }
        return bvSignedness;
    }

    private static EnumSet<RelationSymbol.BvSignedness> collectBvSignednesses(List<ExplicitLhsPolynomialRelation> list, List<ExplicitLhsPolynomialRelation> list2) {
        EnumSet<RelationSymbol.BvSignedness> enumSet = EnumSet.noneOf(RelationSymbol.BvSignedness.class);
        enumSet.addAll(DualJunctionTir.collectBvSignednesses(list));
        enumSet.addAll(DualJunctionTir.collectBvSignednesses(list2));
        return enumSet;
    }

    private static EnumSet<RelationSymbol.BvSignedness> collectBvSignednesses(List<ExplicitLhsPolynomialRelation> list) {
        EnumSet<RelationSymbol.BvSignedness> enumSet = EnumSet.noneOf(RelationSymbol.BvSignedness.class);
        for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation : list) {
            if (explicitLhsPolynomialRelation.getRelationSymbol().isUnSignedBvRelation()) {
                enumSet.add(RelationSymbol.BvSignedness.UNSIGNED);
                continue;
            }
            if (!explicitLhsPolynomialRelation.getRelationSymbol().isSignedBvRelation()) continue;
            enumSet.add(RelationSymbol.BvSignedness.SIGNED);
        }
        return enumSet;
    }

    private static Pair<RelationSymbol, Rational> computeRelationSymbolAndOffset(int n, RelationSymbol relationSymbol, RelationSymbol relationSymbol2, Sort sort) {
        Rational rational;
        RelationSymbol relationSymbol3;
        RelationSymbol.BvSignedness bvSignedness;
        if (SmtSortUtils.isBitvecSort(sort)) {
            bvSignedness = relationSymbol.getSignedness();
            if (bvSignedness != relationSymbol2.getSignedness()) {
                throw new AssertionError((Object)"Cannot combined signed and unsigned relations.");
            }
        } else {
            bvSignedness = null;
        }
        if (relationSymbol.isRelationSymbolGE() && relationSymbol2.isRelationSymbolLE()) {
            relationSymbol3 = RelationSymbol.getLessRelationSymbol(relationSymbol2.isStrictRelation(), sort, bvSignedness);
            rational = n == 1 && (SmtSortUtils.isIntSort(sort) || SmtSortUtils.isBitvecSort(sort)) ? Rational.MONE : Rational.ZERO;
        } else if (relationSymbol.isRelationSymbolGE() && relationSymbol2.isRelationSymbolLT() || relationSymbol.isRelationSymbolGT() && relationSymbol2.isRelationSymbolLE()) {
            if (n == 0) {
                relationSymbol3 = RelationSymbol.getLessRelationSymbol(true, sort, bvSignedness);
            } else if (n == 1) {
                relationSymbol3 = RelationSymbol.getLessRelationSymbol(false, sort, bvSignedness);
            } else {
                throw new AssertionError((Object)"unknown quantifier");
            }
            rational = Rational.ZERO;
        } else if (relationSymbol.isRelationSymbolGT() && relationSymbol2.isRelationSymbolLT()) {
            relationSymbol3 = RelationSymbol.getLessRelationSymbol(relationSymbol2.isStrictRelation(), sort, bvSignedness);
            rational = n == 0 && (SmtSortUtils.isIntSort(sort) || SmtSortUtils.isBitvecSort(sort)) ? Rational.ONE : Rational.ZERO;
        } else {
            throw new AssertionError((Object)String.format("Unsupported relation symbols: Lower %s, Upper %s", new Object[]{relationSymbol, relationSymbol2}));
        }
        return new Pair((Object)relationSymbol3, (Object)rational);
    }

    private static class ExplicitLhsPolynomialRelations {
        private final Sort mSort;
        private final List<ExplicitLhsPolynomialRelation> mLowerBounds = new ArrayList<ExplicitLhsPolynomialRelation>();
        private final List<ExplicitLhsPolynomialRelation> mUpperBounds = new ArrayList<ExplicitLhsPolynomialRelation>();
        private final List<Pair<ExplicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation>> mAntiDerBounds = new ArrayList<Pair<ExplicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation>>();

        public ExplicitLhsPolynomialRelations(Sort sort) {
            this.mSort = sort;
        }

        void addSimpleRelation(ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation) {
            switch (explicitLhsPolynomialRelation.getRelationSymbol()) {
                case EQ: 
                case DISTINCT: {
                    throw new AssertionError((Object)"should have been split before");
                }
                case GEQ: 
                case GREATER: 
                case BVUGE: 
                case BVUGT: 
                case BVSGE: 
                case BVSGT: {
                    this.mLowerBounds.add(explicitLhsPolynomialRelation);
                    break;
                }
                case LEQ: 
                case LESS: 
                case BVULE: 
                case BVULT: 
                case BVSLE: 
                case BVSLT: {
                    this.mUpperBounds.add(explicitLhsPolynomialRelation);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown relation symbol " + String.valueOf((Object)explicitLhsPolynomialRelation.getRelationSymbol())));
                }
            }
        }

        void addAntiDerRelation(ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation2) {
            this.mAntiDerBounds.add((Pair<ExplicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation>)new Pair((Object)explicitLhsPolynomialRelation, (Object)explicitLhsPolynomialRelation2));
        }

        public Sort getSort() {
            return this.mSort;
        }

        public List<ExplicitLhsPolynomialRelation> getLowerBounds() {
            return this.mLowerBounds;
        }

        public List<ExplicitLhsPolynomialRelation> getUpperBounds() {
            return this.mUpperBounds;
        }

        public List<Pair<ExplicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation>> getAntiDerRelations() {
            return this.mAntiDerBounds;
        }

        private Term buildBoundConstraint(IUltimateServiceProvider iUltimateServiceProvider, Script script, int n, Set<TermVariable> set) {
            boolean bl;
            List<ExplicitLhsPolynomialRelation> list = this.mLowerBounds;
            List<ExplicitLhsPolynomialRelation> list2 = this.mUpperBounds;
            boolean bl2 = bl = SmtSortUtils.isBitvecSort(this.mSort) && this.mAntiDerBounds.isEmpty() && list.isEmpty() != list2.isEmpty();
            if (bl) {
                return this.checkforSingleDirectionBounds(script, list, list2, n);
            }
            return this.buildCorrespondingFiniteJunctionForAntiDer(iUltimateServiceProvider, n, script, set);
        }

        private static Term constructConstraintForSingleDirectionBounds(Term term, Script script, Sort sort, RelationSymbol.BvSignedness bvSignedness, Direction direction, int n) {
            BigInteger bigInteger = ExplicitLhsPolynomialRelations.getMaximalBound(sort, bvSignedness, direction);
            Term term2 = SmtUtils.constructIntegerValue(script, sort, bigInteger);
            return QuantifierUtils.applyAntiDerOperator(script, n, term2, term);
        }

        private static BigInteger getMaximalBound(Sort sort, RelationSymbol.BvSignedness bvSignedness, Direction direction) {
            int n = SmtSortUtils.getBitvectorLength(sort);
            BigInteger bigInteger = BigInteger.TWO.pow(n);
            return switch (bvSignedness) {
                case RelationSymbol.BvSignedness.SIGNED -> {
                    switch (direction) {
                        case LOWER: {
                            yield bigInteger.divide(BigInteger.TWO).multiply(BigInteger.ONE).negate();
                        }
                        case UPPER: {
                            yield bigInteger.divide(BigInteger.TWO).subtract(BigInteger.ONE);
                        }
                    }
                    throw new AssertionError((Object)("unknown value " + String.valueOf((Object)direction)));
                }
                case RelationSymbol.BvSignedness.UNSIGNED -> {
                    switch (direction) {
                        case LOWER: {
                            yield BigInteger.ZERO;
                        }
                        case UPPER: {
                            yield bigInteger.subtract(BigInteger.ONE);
                        }
                    }
                    throw new AssertionError((Object)("unknown value " + String.valueOf((Object)direction)));
                }
                default -> throw new AssertionError((Object)("unknown value " + String.valueOf((Object)bvSignedness)));
            };
        }

        private Term checkforSingleDirectionBounds(Script script, List<ExplicitLhsPolynomialRelation> list, List<ExplicitLhsPolynomialRelation> list2, int n) {
            List<ExplicitLhsPolynomialRelation> list3;
            Direction direction;
            if (list2.isEmpty()) {
                if (n == 0) {
                    direction = Direction.UPPER;
                } else if (n == 1) {
                    direction = Direction.LOWER;
                } else {
                    throw new AssertionError((Object)("Unknown quantifier " + n));
                }
                list3 = list;
            } else if (list.isEmpty()) {
                if (n == 0) {
                    direction = Direction.LOWER;
                } else if (n == 1) {
                    direction = Direction.UPPER;
                } else {
                    throw new AssertionError((Object)("Unknown quantifier " + n));
                }
                list3 = list2;
            } else {
                return null;
            }
            return this.constructConstraintForSingleDirectionBounds(script, n, direction, list3);
        }

        private Term constructConstraintForSingleDirectionBounds(Script script, int n, Direction direction, List<ExplicitLhsPolynomialRelation> list) {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation : list) {
                if (n == 0 && explicitLhsPolynomialRelation.getRelationSymbol().isStrictRelation()) {
                    arrayList.add(ExplicitLhsPolynomialRelations.constructConstraintForSingleDirectionBounds(explicitLhsPolynomialRelation.getRhs().toTerm(script), script, explicitLhsPolynomialRelation.getRhs().getSort(), explicitLhsPolynomialRelation.getRelationSymbol().getSignedness(), direction, n));
                    continue;
                }
                if (n != 1 || explicitLhsPolynomialRelation.getRelationSymbol().isStrictRelation()) continue;
                arrayList.add(ExplicitLhsPolynomialRelations.constructConstraintForSingleDirectionBounds(explicitLhsPolynomialRelation.getRhs().toTerm(script), script, explicitLhsPolynomialRelation.getRhs().getSort(), explicitLhsPolynomialRelation.getRelationSymbol().getSignedness(), direction, n));
            }
            return QuantifierUtils.applyDualFiniteConnective(script, n, arrayList);
        }

        private Term buildCorrespondingFiniteJunctionForAntiDer(IUltimateServiceProvider iUltimateServiceProvider, int n, Script script, Set<TermVariable> set) {
            ILogger iLogger;
            int n2 = (int)Math.pow(2.0, this.mAntiDerBounds.size());
            if (this.mAntiDerBounds.size() > 5) {
                iLogger = iUltimateServiceProvider.getLoggingService().getLogger(this.getClass());
                iLogger.warn((Object)("Constructing " + n2 + "(two to the power of " + this.mAntiDerBounds.size() + " dual juncts."));
            }
            iLogger = new Term[n2];
            int n3 = 0;
            while (n3 < n2) {
                if (!iUltimateServiceProvider.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), "build " + n3 + " of " + n2 + " xjuncts");
                }
                ArrayList<ExplicitLhsPolynomialRelation> arrayList = new ArrayList<ExplicitLhsPolynomialRelation>(this.mLowerBounds);
                ArrayList<ExplicitLhsPolynomialRelation> arrayList2 = new ArrayList<ExplicitLhsPolynomialRelation>(this.mUpperBounds);
                int n4 = 0;
                while (n4 < this.mAntiDerBounds.size()) {
                    if (BigInteger.valueOf(n3).testBit(n4)) {
                        arrayList2.add((ExplicitLhsPolynomialRelation)this.mAntiDerBounds.get(n4).getSecond());
                    } else {
                        arrayList.add((ExplicitLhsPolynomialRelation)this.mAntiDerBounds.get(n4).getFirst());
                    }
                    ++n4;
                }
                iLogger[n3] = this.buildDualFiniteJunction(script, n, set, arrayList, arrayList2);
                if (iLogger[n3] == null) {
                    return null;
                }
                ++n3;
            }
            return QuantifierUtils.applyCorrespondingFiniteConnective(script, n, (Term[])iLogger);
        }

        private Term buildDualFiniteJunction(Script script, int n, Set<TermVariable> set, List<ExplicitLhsPolynomialRelation> list, List<ExplicitLhsPolynomialRelation> list2) {
            if (list.isEmpty() || list2.isEmpty()) {
                boolean bl;
                boolean bl2 = bl = SmtSortUtils.isBitvecSort(this.mSort) && list.isEmpty() != list2.isEmpty();
                if (bl) {
                    return this.checkforSingleDirectionBounds(script, list, list2, n);
                }
                return QuantifierUtils.applyDualFiniteConnective(script, n, new Term[0]);
            }
            Pair<List<ExplicitLhsPolynomialRelation>, List<ExplicitLhsPolynomialRelation>> pair = this.preprocessBounds(script, set, list, list2);
            if (pair == null) {
                return null;
            }
            List list3 = (List)pair.getFirst();
            List list4 = (List)pair.getSecond();
            long l = (long)list3.size() * (long)list4.size();
            if (l >= Integer.MAX_VALUE) {
                throw new UnsupportedOperationException(String.format("Size of result too large: %s xjuncts", l));
            }
            Term[] termArray = new Term[Math.toIntExact(l)];
            int n2 = 0;
            for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation : list3) {
                for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation2 : list4) {
                    termArray[n2] = this.combine(script, n, explicitLhsPolynomialRelation, explicitLhsPolynomialRelation2);
                    if (termArray[n2] == null) {
                        return null;
                    }
                    ++n2;
                }
            }
            return QuantifierUtils.applyDualFiniteConnective(script, n, termArray);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Pair<List<ExplicitLhsPolynomialRelation>, List<ExplicitLhsPolynomialRelation>> preprocessBounds(Script script, Set<TermVariable> set, List<ExplicitLhsPolynomialRelation> list, List<ExplicitLhsPolynomialRelation> list2) {
            List<ExplicitLhsPolynomialRelation> list3;
            List<ExplicitLhsPolynomialRelation> list4;
            boolean bl;
            int n = ExplicitLhsPolynomialRelations.countNonOneCoefficients(list);
            int n2 = ExplicitLhsPolynomialRelations.countNonOneCoefficients(list2);
            if (n == 0 || n2 == 0) {
                return new Pair(list, list2);
            }
            boolean bl2 = bl = n < n2 || n == n2 && list.size() >= list2.size();
            if (bl) {
                List<ExplicitLhsPolynomialRelation> list5 = this.solve(script, set, list);
                if (list5 != null) {
                    list4 = list5;
                    list3 = list2;
                    return new Pair(list4, list3);
                } else {
                    List<ExplicitLhsPolynomialRelation> list6 = this.solve(script, set, list2);
                    if (list6 == null) return null;
                    list4 = list;
                    list3 = list6;
                }
                return new Pair(list4, list3);
            } else {
                List<ExplicitLhsPolynomialRelation> list7 = this.solve(script, set, list2);
                if (list7 != null) {
                    list4 = list;
                    list3 = list7;
                    return new Pair(list4, list3);
                } else {
                    List<ExplicitLhsPolynomialRelation> list8 = this.solve(script, set, list);
                    if (list8 == null) return null;
                    list4 = list8;
                    list3 = list2;
                }
            }
            return new Pair(list4, list3);
        }

        private List<ExplicitLhsPolynomialRelation> solve(Script script, Set<TermVariable> set, List<ExplicitLhsPolynomialRelation> list) {
            ArrayList<ExplicitLhsPolynomialRelation> arrayList = new ArrayList<ExplicitLhsPolynomialRelation>(list.size());
            for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation : list) {
                if (explicitLhsPolynomialRelation.getLhsCoefficient().equals((Object)Rational.ONE)) {
                    arrayList.add(explicitLhsPolynomialRelation);
                    continue;
                }
                Pair<ExplicitLhsPolynomialRelation, Term> pair = explicitLhsPolynomialRelation.divideByIntegerCoefficient(script, set);
                if (pair == null) {
                    return null;
                }
                if (pair.getSecond() != null) {
                    throw new AssertionError();
                }
                arrayList.add((ExplicitLhsPolynomialRelation)pair.getFirst());
            }
            return arrayList;
        }

        private static int countNonOneCoefficients(List<ExplicitLhsPolynomialRelation> list) {
            int n = 0;
            for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation : list) {
                if (!explicitLhsPolynomialRelation.getLhsMonomial().isLinear()) {
                    throw new AssertionError((Object)"cannot handle proper monomial");
                }
                if (explicitLhsPolynomialRelation.getLhsCoefficient().isNegative()) {
                    throw new AssertionError((Object)"cannot handle negative coefficients");
                }
                if (explicitLhsPolynomialRelation.getLhsCoefficient().equals((Object)Rational.ONE)) continue;
                ++n;
            }
            return n;
        }

        private static int countNonOneCoefficientsInAntiDerRelations(List<Pair<ExplicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation>> list) {
            int n = 0;
            for (Pair<ExplicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation> pair : list) {
                if (!((ExplicitLhsPolynomialRelation)pair.getFirst()).getLhsMonomial().isLinear()) {
                    throw new AssertionError((Object)"cannot handle proper monomial");
                }
                if (!((ExplicitLhsPolynomialRelation)pair.getSecond()).getLhsMonomial().isLinear()) {
                    throw new AssertionError((Object)"cannot handle proper monomial");
                }
                if (((ExplicitLhsPolynomialRelation)pair.getFirst()).getLhsCoefficient().isNegative()) {
                    throw new AssertionError((Object)"cannot handle negative coefficients");
                }
                if (((ExplicitLhsPolynomialRelation)pair.getSecond()).getLhsCoefficient().isNegative()) {
                    throw new AssertionError((Object)"cannot handle negative coefficients");
                }
                if (!((ExplicitLhsPolynomialRelation)pair.getFirst()).getLhsCoefficient().equals((Object)Rational.ONE)) {
                    assert (!((ExplicitLhsPolynomialRelation)pair.getSecond()).getLhsCoefficient().equals((Object)Rational.ONE));
                    ++n;
                    continue;
                }
                assert (((ExplicitLhsPolynomialRelation)pair.getSecond()).getLhsCoefficient().equals((Object)Rational.ONE));
            }
            return n;
        }

        private Term combine(Script script, int n, ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation2) {
            Term term;
            Pair<RelationSymbol, Rational> pair = DualJunctionTir.computeRelationSymbolAndOffset(n, explicitLhsPolynomialRelation.getRelationSymbol(), explicitLhsPolynomialRelation2.getRelationSymbol(), explicitLhsPolynomialRelation.getRhs().getSort());
            assert (((Rational)pair.getSecond()).equals((Object)Rational.ZERO) || ((Rational)pair.getSecond()).equals((Object)Rational.ONE) || ((Rational)pair.getSecond()).equals((Object)Rational.MONE));
            IPolynomialTerm iPolynomialTerm = explicitLhsPolynomialRelation.getRhs();
            IPolynomialTerm iPolynomialTerm2 = explicitLhsPolynomialRelation2.getRhs();
            if (SmtSortUtils.isBitvecSort(explicitLhsPolynomialRelation.getRhs().getSort())) {
                assert (explicitLhsPolynomialRelation.getLhsCoefficient().equals((Object)Rational.ONE) && explicitLhsPolynomialRelation2.getLhsCoefficient().equals((Object)Rational.ONE)) : "Both coefficients must be one";
                term = !((Rational)pair.getSecond()).equals((Object)Rational.ZERO) ? null : ((RelationSymbol)((Object)pair.getFirst())).constructTerm(script, iPolynomialTerm.toTerm(script), iPolynomialTerm2.toTerm(script));
            } else {
                assert (explicitLhsPolynomialRelation.getLhsCoefficient().equals((Object)Rational.ONE) || explicitLhsPolynomialRelation2.getLhsCoefficient().equals((Object)Rational.ONE)) : "At least one coefficient must be one";
                if (!((Rational)pair.getSecond()).equals((Object)Rational.ZERO)) {
                    throw new AssertionError((Object)"Offset must be zero for non-bitvectors");
                }
                IPolynomialTerm iPolynomialTerm3 = !explicitLhsPolynomialRelation2.getLhsCoefficient().equals((Object)Rational.ONE) ? iPolynomialTerm.mul(explicitLhsPolynomialRelation2.getLhsCoefficient()) : iPolynomialTerm;
                IPolynomialTerm iPolynomialTerm4 = !explicitLhsPolynomialRelation.getLhsCoefficient().equals((Object)Rational.ONE) ? iPolynomialTerm2.mul(explicitLhsPolynomialRelation.getLhsCoefficient()) : iPolynomialTerm2;
                term = PolynomialRelation.of(PolynomialRelation.TransformInequality.NO_TRANFORMATION, (RelationSymbol)((Object)pair.getFirst()), (AbstractGeneralizedAffineTerm)iPolynomialTerm3, (AbstractGeneralizedAffineTerm)iPolynomialTerm4).toTerm(script);
            }
            return term;
        }

        private static enum Direction {
            UPPER,
            LOWER;

        }
    }

    public static class TirPossibility {
        private final TermVariable mEliminatee;
        private final ExplicitLhsPolynomialRelations mElprs;
        private final List<Term> mWithoutEliminatee;
        private final CostEstimation mCostEstimation;

        public TirPossibility(TermVariable termVariable, ExplicitLhsPolynomialRelations explicitLhsPolynomialRelations, List<Term> list) {
            this.mEliminatee = termVariable;
            this.mElprs = explicitLhsPolynomialRelations;
            this.mWithoutEliminatee = list;
            this.mCostEstimation = new CostEstimation(this.determineDifficulty(explicitLhsPolynomialRelations), this.approximateResultSize(explicitLhsPolynomialRelations));
        }

        private long approximateResultSize(ExplicitLhsPolynomialRelations explicitLhsPolynomialRelations) {
            long l = (long)Math.pow(2.0, explicitLhsPolynomialRelations.getAntiDerRelations().size());
            long l2 = explicitLhsPolynomialRelations.getLowerBounds().size() + explicitLhsPolynomialRelations.getAntiDerRelations().size() / 2;
            long l3 = explicitLhsPolynomialRelations.getUpperBounds().size() + explicitLhsPolynomialRelations.getAntiDerRelations().size() / 2;
            long l4 = l2 * l3;
            return l4 * l;
        }

        private Difficulty determineDifficulty(ExplicitLhsPolynomialRelations explicitLhsPolynomialRelations) {
            if (explicitLhsPolynomialRelations.getLowerBounds().isEmpty() && explicitLhsPolynomialRelations.getAntiDerRelations().isEmpty()) {
                return Difficulty.SINGLE_DIRECTION;
            }
            if (explicitLhsPolynomialRelations.getUpperBounds().isEmpty() && explicitLhsPolynomialRelations.getAntiDerRelations().isEmpty()) {
                return Difficulty.SINGLE_DIRECTION;
            }
            if (explicitLhsPolynomialRelations.getLowerBounds().isEmpty() && explicitLhsPolynomialRelations.getUpperBounds().isEmpty() && explicitLhsPolynomialRelations.getAntiDerRelations().size() == 1) {
                return Difficulty.SINGLE_DIRECTION;
            }
            int n = ExplicitLhsPolynomialRelations.countNonOneCoefficients(explicitLhsPolynomialRelations.getLowerBounds());
            int n2 = ExplicitLhsPolynomialRelations.countNonOneCoefficients(explicitLhsPolynomialRelations.getUpperBounds());
            int n3 = ExplicitLhsPolynomialRelations.countNonOneCoefficientsInAntiDerRelations(explicitLhsPolynomialRelations.getAntiDerRelations());
            if (n == 0 && n2 == 0 && n3 == 0) {
                return Difficulty.BOTH_SIDES_ONE;
            }
            if ((n == 0 || n2 == 0) && n3 == 0) {
                return Difficulty.ONE_SIDE_ONE;
            }
            return Difficulty.NO_SIDE_ONE;
        }

        public TermVariable getEliminatee() {
            return this.mEliminatee;
        }

        public ExplicitLhsPolynomialRelations getElprs() {
            return this.mElprs;
        }

        public List<Term> getWithoutEliminatee() {
            return this.mWithoutEliminatee;
        }

        public CostEstimation getCostEstimation() {
            return this.mCostEstimation;
        }

        public static class CostEstimation
        implements Comparable<CostEstimation> {
            private final Difficulty mDifficulty;
            private final long mResultSizeApproximation;

            public CostEstimation(Difficulty difficulty, long l) {
                this.mDifficulty = difficulty;
                this.mResultSizeApproximation = l;
            }

            @Override
            public int compareTo(CostEstimation costEstimation) {
                int n = this.mDifficulty.compareTo(costEstimation.getDifficulty());
                if (n != 0) {
                    return n;
                }
                return Long.compare(this.mResultSizeApproximation, costEstimation.getResultSizeApproximation());
            }

            public Difficulty getDifficulty() {
                return this.mDifficulty;
            }

            public long getResultSizeApproximation() {
                return this.mResultSizeApproximation;
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.mDifficulty, this.mResultSizeApproximation});
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                CostEstimation costEstimation = (CostEstimation)object;
                if (this.mDifficulty != costEstimation.mDifficulty) {
                    return false;
                }
                return this.mResultSizeApproximation == costEstimation.mResultSizeApproximation;
            }

            public String toString() {
                return String.format("(%s,%s)", new Object[]{this.mDifficulty, this.mResultSizeApproximation});
            }
        }

        public static enum Difficulty {
            SINGLE_DIRECTION,
            BOTH_SIDES_ONE,
            ONE_SIDE_ONE,
            NO_SIDE_ONE;

        }
    }
}

