/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.RelevantVariables;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class IcfgProgramExecutionBuilder<L extends IAction> {
    private final ModifiableGlobalsTable mModifiableGlobalVariableManager;
    private final NestedWord<L> mTrace;
    private final Map<IProgramVar, Map<Integer, Term>> mVar2Pos2Value;
    private final RelevantVariables<L> mRelevantVariables;
    private IcfgProgramExecution<L> mIcfgProgramExecution;
    private final Map<TermVariable, Boolean>[] mBranchEncoders;

    public IcfgProgramExecutionBuilder(ModifiableGlobalsTable modifiableGlobalsTable, NestedWord<L> nestedWord, RelevantVariables<L> relevantVariables) {
        this.mModifiableGlobalVariableManager = modifiableGlobalsTable;
        this.mTrace = nestedWord;
        this.mVar2Pos2Value = new HashMap<IProgramVar, Map<Integer, Term>>();
        this.mRelevantVariables = relevantVariables;
        this.mBranchEncoders = new Map[this.mTrace.length()];
        this.mIcfgProgramExecution = null;
    }

    public IcfgProgramExecution<L> getIcfgProgramExecution() {
        if (this.mIcfgProgramExecution == null) {
            this.mIcfgProgramExecution = this.computeIcfgProgramExecution();
        }
        return this.mIcfgProgramExecution;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isReAssigned(IProgramVar iProgramVar, int n) {
        if (this.mTrace.isInternalPosition(n) || this.mTrace.isReturnPosition(n)) {
            UnmodifiableTransFormula unmodifiableTransFormula = ((IAction)this.mTrace.getSymbol(n)).getTransformula();
            return unmodifiableTransFormula.getAssignedVars().contains(iProgramVar);
        }
        if (!this.mTrace.isCallPosition(n)) throw new AssertionError();
        IIcfgCallTransition iIcfgCallTransition = (IIcfgCallTransition)this.mTrace.getSymbol(n);
        String string = iIcfgCallTransition.getSucceedingProcedure();
        if (iProgramVar.isGlobal()) {
            Set set = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string);
            if (iProgramVar instanceof IProgramNonOldVar) {
                return set.contains(iProgramVar);
            }
            if (!(iProgramVar instanceof IProgramOldVar)) throw new AssertionError((Object)"unknown var");
            return set.contains(((IProgramOldVar)iProgramVar).getNonOldVar());
        }
        String string2 = iIcfgCallTransition.getPrecedingProcedure();
        if (string.equals(iProgramVar.getProcedure())) return true;
        if (string2.equals(iProgramVar.getProcedure())) return true;
        return false;
    }

    void addValueAtVarAssignmentPosition(IProgramVar iProgramVar2, int n, Term term) {
        assert (n >= -1);
        assert (n == -1 || this.isReAssigned(iProgramVar2, n)) : "oldVar in procedure where it is not modified?";
        Map map = this.mVar2Pos2Value.computeIfAbsent(iProgramVar2, iProgramVar -> new HashMap());
        assert (!map.containsKey(n));
        map.put(n, term);
    }

    public void setBranchEncoders(int n, Map<TermVariable, Boolean> map) {
        this.mBranchEncoders[n] = map;
    }

    private int indexWhereVarWasAssignedTheLastTime(IProgramVar iProgramVar, int n) {
        assert (n >= -1);
        if (n == -1) {
            return -1;
        }
        if (this.isReAssigned(iProgramVar, n)) {
            return n;
        }
        if (this.mTrace.isInternalPosition(n) || this.mTrace.isCallPosition(n)) {
            return this.indexWhereVarWasAssignedTheLastTime(iProgramVar, n - 1);
        }
        if (this.mTrace.isReturnPosition(n)) {
            if (iProgramVar.isGlobal() && !iProgramVar.isOldvar()) {
                return this.indexWhereVarWasAssignedTheLastTime(iProgramVar, n - 1);
            }
            int n2 = this.mTrace.getCallPosition(n);
            return this.indexWhereVarWasAssignedTheLastTime(iProgramVar, n2 - 1);
        }
        throw new AssertionError();
    }

    public Map<IProgramVar, Term> varValAtPos(int n) {
        HashMap<IProgramVar, Term> hashMap = new HashMap<IProgramVar, Term>();
        Set<IProgramVar> set = this.mRelevantVariables.getForwardRelevantVariables()[n + 1];
        for (IProgramVar iProgramVar : set) {
            Term term;
            if (!SmtUtils.isSortForWhichWeCanGetValues((Sort)iProgramVar.getTermVariable().getSort())) continue;
            int n2 = this.indexWhereVarWasAssignedTheLastTime(iProgramVar, n);
            if (this.mVar2Pos2Value == null || !this.mVar2Pos2Value.containsKey(iProgramVar) || (term = this.mVar2Pos2Value.get(iProgramVar).get(n2)) == null) continue;
            hashMap.put(iProgramVar, term);
        }
        return hashMap;
    }

    private IcfgProgramExecution<L> computeIcfgProgramExecution() {
        HashMap<Integer, IProgramExecution.ProgramState> hashMap = new HashMap<Integer, IProgramExecution.ProgramState>();
        int n = 0;
        while (n < this.mTrace.length()) {
            Map<IProgramVar, Term> map = this.varValAtPos(n);
            HashMap<TermVariable, Set<Term>> hashMap2 = new HashMap<TermVariable, Set<Term>>();
            for (Map.Entry<IProgramVar, Term> entry : map.entrySet()) {
                IProgramVar iProgramVar = entry.getKey();
                hashMap2.put(iProgramVar.getTermVariable(), Collections.singleton(entry.getValue()));
            }
            IProgramExecution.ProgramState programState2 = new IProgramExecution.ProgramState(hashMap2, Term.class);
            hashMap.put(n, programState2);
            ++n;
        }
        return IcfgProgramExecution.create(this.mTrace.asList().stream().collect(Collectors.toList()), hashMap, (Map[])this.mBranchEncoders);
    }
}

