/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.chcprinter;

import de.uni_freiburg.informatik.ultimate.chcprinter.Activator;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.ChcAsserter;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornAnnot;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClauseAST;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ChcSmtPrinterObserver
extends BaseObserver {
    private static final boolean PRODUCE_UNSAT_CORES = false;
    private static final boolean ADD_COMMENTS = false;
    private static final boolean USE_CSE = true;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;

    public ChcSmtPrinterObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public boolean process(IElement iElement) throws IOException {
        if (!(iElement instanceof HornClauseAST)) {
            return true;
        }
        HornAnnot hornAnnot = HornAnnot.getAnnotation((IElement)iElement);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Printing the following HornClause set:");
            this.mLogger.debug((Object)hornAnnot);
        }
        List list = hornAnnot.getHornClauses();
        HcSymbolTable hcSymbolTable = hornAnnot.getSymbolTable();
        ManagedScript managedScript = hornAnnot.getScript();
        File file = this.openTempFile(iElement);
        LoggingScript loggingScript = new LoggingScript((Script)new NoopScript(), file.getAbsolutePath(), true, true);
        loggingScript.setLogic(Logics.HORN);
        loggingScript.setInfo(":source", (Object)new QuotedObject("CHC Constraint Logic: " + String.valueOf(hornAnnot.getChcCategoryInfo().getConstraintLogic()) + "\n                   Contains non-linear Horn clauses: " + hornAnnot.getChcCategoryInfo().containsNonLinearHornClauses()));
        new ChcAsserter(managedScript, (Script)loggingScript, false, false, true).assertClauses(hcSymbolTable, list);
        loggingScript.checkSat();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File openTempFile(IElement iElement) {
        String string;
        if (this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Save file in source directory")) {
            ILocation iLocation = ILocation.getAnnotation((IElement)iElement);
            File file = new File(iLocation.getFileName());
            string = file.isDirectory() ? file.getPath() : file.getParent();
            if (string == null) {
                this.mLogger.warn((Object)"Model does not provide a valid source location, falling back to default dump path...");
                string = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Dump path");
            }
        } else {
            string = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Dump path");
        }
        try {
            File file;
            if (this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Use automatic naming")) {
                file = File.createTempFile("ChcSmtPrinter_" + new File(ILocation.getAnnotation((IElement)iElement).getFileName()).getName() + "_UID", ".smt2", new File(string));
            } else {
                String string2 = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("File name");
                file = new File(string + File.separatorChar + string2);
                if (!(file.isFile() && file.canWrite() || !file.exists())) {
                    this.mLogger.warn((Object)("Cannot write to: " + file.getAbsolutePath()));
                    return null;
                }
                if (file.exists()) {
                    this.mLogger.info((Object)("File already exists and will be overwritten: " + file.getAbsolutePath()));
                }
                file.createNewFile();
            }
            this.mLogger.info((Object)("Writing to file " + file.getAbsolutePath()));
            return file;
        }
        catch (IOException iOException) {
            this.mLogger.fatal((Object)"Cannot open file", (Throwable)iOException);
            return null;
        }
    }
}

