/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class Project
extends BoogieASTNode {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(Project.class);
    ILocation loc;
    Unit[] units;

    public Project(ILocation iLocation, Unit[] unitArray) {
        super(iLocation);
        this.loc = iLocation;
        this.units = unitArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Project: " + String.valueOf((Object)this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Project").append('[');
        stringBuffer.append(this.loc);
        stringBuffer.append(',');
        if (this.units == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.units.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.units[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public ILocation getLoc() {
        return this.loc;
    }

    public void setLoc(ILocation iLocation) {
        if (this.loc != null && iLocation != this.loc) {
            throw new AssertionError((Object)"Value is only writeable once");
        }
        this.loc = iLocation;
    }

    public Unit[] getUnits() {
        return this.units;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.units != null) {
            list.addAll(Arrays.asList(this.units));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (generatedBoogieAstVisitor.visit(this) && this.units != null) {
            Unit[] unitArray = this.units;
            int n = this.units.length;
            int n2 = 0;
            while (n2 < n) {
                Unit unit = unitArray[n2];
                unit.accept(generatedBoogieAstVisitor);
                ++n2;
            }
        }
    }

    public Project accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Project project = generatedBoogieAstTransformer.transform(this);
        if (project != this) {
            return project;
        }
        boolean bl = false;
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        if (this.units != null) {
            Unit[] unitArray = this.units;
            int n = this.units.length;
            int n2 = 0;
            while (n2 < n) {
                Unit unit = unitArray[n2];
                Unit unit2 = unit.accept(generatedBoogieAstTransformer);
                bl = bl || unit2 != unit;
                arrayList.add(unit2);
                ++n2;
            }
        }
        if (bl) {
            return new Project(this.loc, arrayList.toArray(new Unit[0]));
        }
        return this;
    }
}

