/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class LocalTransformer
implements ITransformulaTransformer {
    private final List<TransitionPreprocessor> mTransitionPreprocessors;
    private final ManagedScript mManagedScript;
    private final ReplacementVarFactory mReplacementVarFactory;

    public LocalTransformer(TransitionPreprocessor transitionPreprocessor, ManagedScript managedScript, ReplacementVarFactory replacementVarFactory) {
        this(Collections.singletonList(transitionPreprocessor), managedScript, replacementVarFactory);
    }

    public LocalTransformer(List<TransitionPreprocessor> list, ManagedScript managedScript, ReplacementVarFactory replacementVarFactory) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.mTransitionPreprocessors = Collections.unmodifiableList(list);
        this.mManagedScript = Objects.requireNonNull(managedScript);
        this.mReplacementVarFactory = Objects.requireNonNull(replacementVarFactory);
    }

    @Override
    public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> iIcfgTransition, UnmodifiableTransFormula unmodifiableTransFormula) {
        if (!(iIcfgTransition instanceof IIcfgInternalTransition)) {
            throw new UnsupportedOperationException("LocalTransformer does not support call/return");
        }
        ModifiableTransFormula modifiableTransFormula = ModifiableTransFormulaUtils.buildTransFormula((TransFormula)unmodifiableTransFormula, (ManagedScript)this.mManagedScript);
        try {
            ModifiableTransFormula modifiableTransFormula2 = modifiableTransFormula;
            for (TransitionPreprocessor transitionPreprocessor : this.mTransitionPreprocessors) {
                ModifiableTransFormula modifiableTransFormula3 = modifiableTransFormula2;
                modifiableTransFormula2 = transitionPreprocessor.process(this.mManagedScript, modifiableTransFormula3);
                assert (transitionPreprocessor.checkSoundness(this.mManagedScript.getScript(), modifiableTransFormula3, modifiableTransFormula2)) : "Transformation unsound for " + transitionPreprocessor.getDescription();
            }
            return new ITransformulaTransformer.TransformulaTransformationResult(TransFormulaBuilder.constructCopy((ManagedScript)this.mManagedScript, (TransFormula)modifiableTransFormula2, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap()));
        }
        catch (TermException termException) {
            throw new AssertionError((Object)termException);
        }
    }

    @Override
    public String getName() {
        if (this.mTransitionPreprocessors.size() == 1) {
            return this.mTransitionPreprocessors.iterator().next().getDescription();
        }
        return this.mTransitionPreprocessors.stream().map(TransitionPreprocessor::getDescription).collect(Collectors.joining(","));
    }

    @Override
    public IIcfgSymbolTable getNewIcfgSymbolTable() {
        return this.mReplacementVarFactory.constructIIcfgSymbolTable();
    }

    @Override
    public void preprocessIcfg(IIcfg<?> iIcfg) {
    }

    @Override
    public HashRelation<String, IProgramNonOldVar> getNewModifiedGlobals() {
        return this.mReplacementVarFactory.constructModifiableGlobalsTable().getProcToGlobals();
    }
}

