/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class ExtendedConcurrencyInformation<LOC extends IcfgLocation> {
    private final IIcfg<LOC> mIcfg;
    private final HashRelation<IIcfgForkTransitionThreadCurrent<LOC>, IIcfgForkTransitionThreadOther<LOC>> mForks = new HashRelation();
    private final HashRelation<IIcfgJoinTransitionThreadCurrent<LOC>, IIcfgJoinTransitionThreadOther<LOC>> mJoins = new HashRelation();

    public ExtendedConcurrencyInformation(IIcfg<LOC> iIcfg) {
        this.mIcfg = iIcfg;
        for (String string : IcfgUtils.getAllThreadInstances(iIcfg)) {
            for (IIcfgForkTransitionThreadOther<LOC> iIcfgForkTransitionThreadOther : this.getForksOf(string)) {
                this.mForks.addPair((Object)iIcfgForkTransitionThreadOther.getCorrespondingIIcfgForkTransitionCurrentThread(), iIcfgForkTransitionThreadOther);
            }
            for (IIcfgJoinTransitionThreadOther iIcfgJoinTransitionThreadOther : this.getJoinsOf(string)) {
                this.mJoins.addPair((Object)iIcfgJoinTransitionThreadOther.getCorrespondingIIcfgJoinTransitionCurrentThread(), (Object)iIcfgJoinTransitionThreadOther);
            }
        }
    }

    public static boolean isThreadLocal(IcfgEdge icfgEdge) {
        return !(icfgEdge instanceof IIcfgForkTransitionThreadOther) && !(icfgEdge instanceof IIcfgJoinTransitionThreadOther);
    }

    public Set<IIcfgForkTransitionThreadOther<LOC>> getForksOf(String string) {
        return ((IcfgLocation)this.mIcfg.getProcedureEntryNodes().get(string)).getIncomingEdges().stream().filter(IIcfgForkTransitionThreadOther.class::isInstance).map(IIcfgForkTransitionThreadOther.class::cast).collect(Collectors.toSet());
    }

    public Set<IIcfgJoinTransitionThreadOther<LOC>> getJoinsOf(String string) {
        return ((IcfgLocation)this.mIcfg.getProcedureExitNodes().get(string)).getOutgoingEdges().stream().map(IIcfgJoinTransitionThreadOther.class::cast).collect(Collectors.toSet());
    }

    public boolean mayBeForkOf(String string, IcfgEdge icfgEdge) {
        if (icfgEdge instanceof IIcfgForkTransitionThreadCurrent) {
            return this.mForks.getImage((Object)((IIcfgForkTransitionThreadCurrent)icfgEdge)).stream().anyMatch(iIcfgForkTransitionThreadOther -> Objects.equals(iIcfgForkTransitionThreadOther.getSucceedingProcedure(), string));
        }
        return false;
    }

    public boolean mayBeJoinOf(String string, IcfgEdge icfgEdge) {
        if (icfgEdge instanceof IIcfgJoinTransitionThreadCurrent) {
            return this.mJoins.getImage((Object)((IIcfgJoinTransitionThreadCurrent)icfgEdge)).stream().anyMatch(iIcfgJoinTransitionThreadOther -> Objects.equals(iIcfgJoinTransitionThreadOther.getPrecedingProcedure(), string));
        }
        return false;
    }

    public boolean mustBeJoinOf(String string, IcfgEdge icfgEdge) {
        if (icfgEdge instanceof IIcfgJoinTransitionThreadCurrent) {
            return this.mJoins.getImage((Object)((IIcfgJoinTransitionThreadCurrent)icfgEdge)).stream().allMatch(iIcfgJoinTransitionThreadOther -> Objects.equals(iIcfgJoinTransitionThreadOther.getPrecedingProcedure(), string));
        }
        return false;
    }
}

