/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Candidate;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ConfigurationOrder;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ICoRelation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.IPossibleExtensions;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;

public class PossibleExtensions<LETTER, PLACE>
implements IPossibleExtensions<LETTER, PLACE> {
    private static final boolean USE_FORWARD_CHECKING = false;
    private static final boolean USE_PQ = true;
    private static final boolean LAZY_SUCCESSOR_COMPUTATION = true;
    private final Queue<Event<LETTER, PLACE>> mPe;
    private final Map<Marking<PLACE>, Event<LETTER, PLACE>> mMarkingEventMap = new HashMap<Marking<PLACE>, Event<LETTER, PLACE>>();
    private int mMaximalSize;
    private final boolean mUseFirstbornCutoffCheck;
    private final boolean mUseB32Optimization;
    private int mNumberOfGeneratedExtensions = 0;
    private final Comparator<Event<LETTER, PLACE>> mOrder;
    private final ArrayDeque<Event<LETTER, PLACE>> mFastpathCutoffEventList;
    private final BranchingProcess<LETTER, PLACE> mBranchingProcess;
    private int mUsefulExtensionCandidates;
    private int mUselessExtensionCandidates;

    public PossibleExtensions(BranchingProcess<LETTER, PLACE> branchingProcess, ConfigurationOrder<LETTER, PLACE> configurationOrder, boolean bl, boolean bl2) {
        this.mUseFirstbornCutoffCheck = bl;
        this.mBranchingProcess = branchingProcess;
        this.mPe = new PriorityQueue<Event<LETTER, PLACE>>(configurationOrder);
        this.mFastpathCutoffEventList = new ArrayDeque();
        this.mOrder = configurationOrder;
        this.mMarkingEventMap.put(this.mBranchingProcess.getDummyRoot().getMark(), this.mBranchingProcess.getDummyRoot());
        this.mUseB32Optimization = bl2;
    }

    @Override
    public Event<LETTER, PLACE> remove() {
        if (this.mFastpathCutoffEventList.isEmpty()) {
            return this.mPe.remove();
        }
        return this.mFastpathCutoffEventList.removeFirst();
    }

    @Override
    public void update(Event<LETTER, PLACE> event) throws PetriNetNot1SafeException {
        Collection<Candidate<LETTER, PLACE>> collection = this.computeCandidates(event);
        for (Candidate<LETTER, PLACE> candidate : collection) {
            if (candidate.getInstantiated().isEmpty()) {
                throw new AssertionError((Object)"at least one place has to be instantiated");
            }
            int n = this.size();
            this.evolveCandidate(candidate);
            if (this.size() > n) {
                ++this.mUsefulExtensionCandidates;
                continue;
            }
            ++this.mUselessExtensionCandidates;
        }
    }

    private boolean firstbornCutoffCheck(Event<LETTER, PLACE> event) {
        Event<LETTER, PLACE> event2 = this.mMarkingEventMap.get(event.getMark());
        if (event2 == null) {
            return false;
        }
        if (this.mOrder.compare(event, event2) > 0) {
            event.setCompanion(event2);
            return true;
        }
        boolean bl = this.mPe.remove(event2);
        assert (bl);
        this.mFastpathCutoffEventList.add(event2);
        event2.setCompanion(event);
        return false;
    }

    private void addFullyInstantiatedCandidate(Candidate<LETTER, PLACE> candidate) throws PetriNetNot1SafeException {
        for (Transition<LETTER, PLACE> transition : candidate.getTransition().getTransitions()) {
            boolean bl;
            ++this.mNumberOfGeneratedExtensions;
            Event<LETTER, PLACE> event = new Event<LETTER, PLACE>(candidate.getInstantiated(), transition, this.mBranchingProcess, this.mNumberOfGeneratedExtensions);
            if (this.mUseFirstbornCutoffCheck) {
                if (this.firstbornCutoffCheck(event)) {
                    this.mFastpathCutoffEventList.add(event);
                    continue;
                }
                this.mMarkingEventMap.put(event.getMark(), event);
                bl = this.mPe.add(event);
                this.mMaximalSize = Integer.max(this.mMaximalSize, this.mPe.size());
                if (!bl) {
                    throw new AssertionError((Object)"Event was already in queue.");
                }
                continue;
            }
            bl = this.mPe.add(event);
            this.mMaximalSize = Integer.max(this.mMaximalSize, this.mPe.size());
            if (!bl) {
                throw new AssertionError((Object)"Event was already in queue.");
            }
        }
    }

    private void evolveCandidate(Candidate<LETTER, PLACE> candidate) throws PetriNetNot1SafeException {
        if (candidate.isFullyInstantiated()) {
            this.addFullyInstantiatedCandidate(candidate);
            return;
        }
        PLACE PLACE = candidate.getNextUninstantiatedPlace();
        ICoRelation iCoRelation = this.mBranchingProcess.getCoRelation();
        List list = candidate.getInstantiatedButNotInitially();
        Set set = candidate.getPossibleInstantiations(PLACE).stream().filter(condition -> iCoRelation.isCoset(list, (Condition)condition)).collect(Collectors.toSet());
        for (Condition condition2 : set) {
            assert (candidate.getTransition().getPredecessorPlaces().contains(condition2.getPlace()));
            assert (condition2.getPlace().equals(PLACE));
            assert (!candidate.getInstantiated().contains(condition2));
            candidate.instantiateNext(condition2);
            this.evolveCandidate(candidate);
            candidate.undoOneInstantiation();
        }
    }

    private void evolveCandidateWithForwardChecking(Candidate<LETTER, PLACE> candidate) throws PetriNetNot1SafeException {
        if (candidate.isFullyInstantiated()) {
            this.addFullyInstantiatedCandidate(candidate);
            return;
        }
        PLACE PLACE = candidate.getNextUninstantiatedPlace();
        ICoRelation iCoRelation = this.mBranchingProcess.getCoRelation();
        Map<PLACE, Set<Condition<LETTER, PLACE>>> map = candidate.getPossibleInstantiationsMap();
        Set<Condition<LETTER, PLACE>> set = candidate.getPossibleInstantiations(PLACE);
        map.remove(PLACE);
        for (Condition condition : set) {
            Object object2;
            HashMap hashMap = new HashMap();
            boolean bl = false;
            for (Object object2 : map.keySet()) {
                Set set2 = map.get(object2).stream().filter(condition2 -> iCoRelation.isInCoRelation(condition, (Condition)condition2)).collect(Collectors.toSet());
                if (set2.isEmpty()) {
                    bl = true;
                    break;
                }
                hashMap.put(object2, set2);
            }
            if (bl) continue;
            object2 = new LinkedList<Condition<LETTER, PLACE>>(candidate.getInstantiated());
            ((LinkedList)object2).add(condition);
            LinkedList<PLACE> linkedList = new LinkedList<PLACE>(candidate.getNotInstantiated());
            linkedList.removeLast();
            this.evolveCandidateWithForwardChecking(new Candidate<LETTER, PLACE>(candidate.getTransition(), linkedList, object2, hashMap));
        }
    }

    private Collection<Candidate<LETTER, PLACE>> computeCandidates(Event<LETTER, PLACE> event) {
        Condition<LETTER, PLACE> condition22;
        if (event.getSuccessorConditions().isEmpty()) {
            return Collections.emptySet();
        }
        Set<Condition<LETTER, PLACE>> set = event.getSuccessorConditions();
        ICoRelation<LETTER, PLACE> iCoRelation = this.mBranchingProcess.getCoRelation();
        HashRelation hashRelation = new HashRelation();
        if (this.mUseB32Optimization) {
            var4_5 = iCoRelation.computeNonCutoffCoRelatatedConditions(set.iterator().next());
            for (Condition<LETTER, PLACE> condition22 : var4_5) {
                hashRelation.addPair(condition22.getPlace(), condition22);
            }
        } else {
            var4_5 = iCoRelation.computeCoRelatatedConditions(set.iterator().next());
            for (Condition<LETTER, PLACE> condition22 : var4_5) {
                if (condition22.getPredecessorEvent().isCutoffEvent()) continue;
                hashRelation.addPair(condition22.getPlace(), condition22);
            }
        }
        HashSet hashSet = new HashSet();
        for (Condition<LETTER, PLACE> object2 : set) {
            hashSet.add(object2.getPlace());
        }
        condition22 = this.mBranchingProcess.getNet().getSuccessorTransitionProviders(hashSet, hashRelation.getDomain());
        List<Candidate<LETTER, PLACE>> list = condition22.stream().map(iSuccessorTransitionProvider -> new Candidate(iSuccessorTransitionProvider, set, hashRelation)).collect(Collectors.toList());
        return list;
    }

    @Override
    public boolean isEmpy() {
        return this.mPe.isEmpty() && this.mFastpathCutoffEventList.isEmpty();
    }

    @Override
    public int size() {
        return this.mPe.size() + this.mFastpathCutoffEventList.size();
    }

    @Override
    public int getUsefulExtensionCandidates() {
        return this.mUsefulExtensionCandidates;
    }

    @Override
    public int getUselessExtensionCandidates() {
        return this.mUselessExtensionCandidates;
    }

    @Override
    public int getMaximalSize() {
        return this.mMaximalSize;
    }
}

