/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.ltl2aut;

import com.github.jhoenicke.javacup.runtime.Scanner;
import de.uni_freiburg.informatik.ultimate.core.lib.util.MonitoredProcess;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.ltl2aut.Activator;
import de.uni_freiburg.informatik.ultimate.ltl2aut.Lexer;
import de.uni_freiburg.informatik.ultimate.ltl2aut.Parser;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.AstNode;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;

public class LTLXBAExecutor {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;

    public LTLXBAExecutor(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public AstNode ltl2Ast(String string) throws Exception {
        String string2 = this.execLTLXBA(string.trim());
        this.mLogger.debug((Object)String.format("LTLXBA said: %s", string2));
        InputStreamReader inputStreamReader = new InputStreamReader(IOUtils.toInputStream((String)string2));
        try {
            return (AstNode)((Object)new Parser((Scanner)new Lexer((Reader)inputStreamReader)).parse().value);
        }
        catch (Exception exception) {
            this.mLogger.fatal((Object)("Exception during parsing of LTLXBA output for formula " + string), (Throwable)exception);
            this.mLogger.fatal((Object)"Parser input was:");
            this.mLogger.fatal((Object)string2);
            throw exception;
        }
    }

    private String execLTLXBA(String string) throws IOException, InterruptedException {
        Object[] objectArray = this.getCommand(string);
        MonitoredProcess monitoredProcess = MonitoredProcess.exec((String[])objectArray, null, null, (IUltimateServiceProvider)this.mServices);
        MonitoredProcess.MonitoredProcessState monitoredProcessState = monitoredProcess.waitfor();
        String string2 = LTLXBAExecutor.convertStreamToString(monitoredProcess.getInputStream());
        String string3 = LTLXBAExecutor.convertStreamToString(monitoredProcess.getErrorStream());
        if (string2 == null || string2.isEmpty()) {
            String string4 = CoreUtil.join((Object[])objectArray, (String)" ");
            this.mLogger.fatal((Object)(string4 + " did not produce any output on stdout"));
            this.mLogger.fatal((Object)"stderr output:");
            this.mLogger.fatal((Object)string3);
            this.mLogger.fatal((Object)("Returncode: " + monitoredProcessState.getReturnCode()));
            throw new IllegalArgumentException(string4 + " did not produce any output on stdout");
        }
        return string2;
    }

    private static String convertStreamToString(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append(CoreUtil.getPlatformLineSeparator());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return stringBuilder.toString();
    }

    private String[] getCommand(String string) {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        string = iPreferenceProvider.getString("Command line string ($1 will be replaced with the property)").replace("$1", string);
        string = string.replace("(", " ( ");
        string = string.replace(")", " ) ");
        string = string.replaceAll("\\s+", " ");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(iPreferenceProvider.getString("Path to LTL*BA executable (LTL2BA, LTL3BA)"));
        arrayList.add("-f");
        arrayList.add(string);
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

