/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public abstract class SdHoareTripleCheckHelper<L extends IAction> {
    private static final String ERROR_UNCHECKED = "unchecked predicate";
    private static final String ERROR_FILTERED_CASE = "this case should have been filtered out before";
    protected final IPredicateCoverageChecker mCoverage;
    protected final IPredicate mFalsePredicate;
    protected final IPredicate mTruePredicate;
    protected final HoareTripleCheckerStatisticsGenerator mStatistics;
    protected final ModifiableGlobalsTable mModifiableGlobals;

    SdHoareTripleCheckHelper(IPredicateCoverageChecker iPredicateCoverageChecker, IPredicate iPredicate, IPredicate iPredicate2, HoareTripleCheckerStatisticsGenerator hoareTripleCheckerStatisticsGenerator, ModifiableGlobalsTable modifiableGlobalsTable) {
        this.mCoverage = Objects.requireNonNull(iPredicateCoverageChecker);
        this.mFalsePredicate = iPredicate;
        this.mTruePredicate = iPredicate2;
        this.mStatistics = hoareTripleCheckerStatisticsGenerator;
        this.mModifiableGlobals = modifiableGlobalsTable;
    }

    public IncrementalPlicationChecker.Validity check(IPredicate iPredicate, IPredicate iPredicate2, L l, IPredicate iPredicate3) {
        IncrementalPlicationChecker.Validity validity;
        Boolean bl;
        if (l.getTransformula().isInfeasible() == UnmodifiableTransFormula.Infeasibility.INFEASIBLE) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        boolean bl2 = false;
        Boolean bl3 = this.isCovered(iPredicate, this.mFalsePredicate);
        if (bl3 == null) {
            bl2 = true;
        } else if (bl3.booleanValue()) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        if (iPredicate2 != null) {
            bl = this.isCovered(iPredicate2, this.mFalsePredicate);
            if (bl == null) {
                bl2 = true;
            } else if (bl.booleanValue()) {
                return IncrementalPlicationChecker.Validity.VALID;
            }
        }
        if ((bl = this.isCovered(this.mTruePredicate, iPredicate3)) == null) {
            bl2 = true;
        } else if (bl.booleanValue()) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        if (bl2) {
            return IncrementalPlicationChecker.Validity.UNKNOWN;
        }
        boolean bl4 = this.isInductiveSelfloop(iPredicate, iPredicate2, l, iPredicate3);
        if (bl4) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        if (SmtUtils.isFalseLiteral((Term)iPredicate3.getFormula())) {
            IncrementalPlicationChecker.Validity validity2;
            IncrementalPlicationChecker.Validity validity3 = validity2 = this.sdecToFalse(iPredicate, iPredicate2, l);
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"INVALID", "NOT_CHECKED", "UNKNOWN", "VALID"}, (IncrementalPlicationChecker.Validity)validity3, 0)) {
                case -1 -> {
                    if (!$assertionsDisabled && this.sdec(iPredicate, iPredicate2, l, iPredicate3) != null) {
                        throw new AssertionError((Object)"inconsistent check results");
                    }
                    yield IncrementalPlicationChecker.Validity.UNKNOWN;
                }
                case 0 -> IncrementalPlicationChecker.Validity.INVALID;
                case 1 -> throw new AssertionError((Object)ERROR_UNCHECKED);
                case 2, 3 -> throw new AssertionError((Object)ERROR_FILTERED_CASE);
                default -> throw new MatchException(null, null);
            };
        }
        IncrementalPlicationChecker.Validity validity4 = validity = this.sdec(iPredicate, iPredicate2, l, iPredicate3);
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"INVALID", "NOT_CHECKED", "UNKNOWN", "VALID"}, (IncrementalPlicationChecker.Validity)validity4, 0)) {
            case -1 -> IncrementalPlicationChecker.Validity.UNKNOWN;
            case 0 -> IncrementalPlicationChecker.Validity.INVALID;
            case 1 -> throw new AssertionError((Object)ERROR_UNCHECKED);
            case 2 -> throw new AssertionError((Object)ERROR_FILTERED_CASE);
            case 3 -> IncrementalPlicationChecker.Validity.VALID;
            default -> throw new MatchException(null, null);
        };
    }

    private Boolean isCovered(IPredicate iPredicate, IPredicate iPredicate2) {
        return switch (this.mCoverage.isCovered(iPredicate, iPredicate2)) {
            case IncrementalPlicationChecker.Validity.INVALID -> false;
            case IncrementalPlicationChecker.Validity.NOT_CHECKED -> throw new AssertionError((Object)ERROR_UNCHECKED);
            case IncrementalPlicationChecker.Validity.UNKNOWN -> null;
            case IncrementalPlicationChecker.Validity.VALID -> true;
            default -> throw new MatchException(null, null);
        };
    }

    public abstract IncrementalPlicationChecker.Validity sdecToFalse(IPredicate var1, IPredicate var2, L var3);

    public abstract boolean isInductiveSelfloop(IPredicate var1, IPredicate var2, L var3, IPredicate var4);

    public abstract IncrementalPlicationChecker.Validity sdec(IPredicate var1, IPredicate var2, L var3, IPredicate var4);

    public abstract IncrementalPlicationChecker.Validity sdLazyEc(IPredicate var1, IPredicate var2, L var3, IPredicate var4);

    protected static boolean varsDisjointFromInVars(IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula) {
        return DataStructureUtils.haveEmptyIntersection(iPredicate.getVars(), unmodifiableTransFormula.getInVars().keySet());
    }

    protected static boolean varsDisjointFromOutVars(IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula) {
        return DataStructureUtils.haveEmptyIntersection(iPredicate.getVars(), unmodifiableTransFormula.getOutVars().keySet());
    }

    protected static boolean varsDisjointFromAssignedVars(IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula) {
        return DataStructureUtils.haveEmptyIntersection(iPredicate.getVars(), unmodifiableTransFormula.getAssignedVars());
    }

    protected static boolean disjointFunctions(IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula) {
        return DataStructureUtils.haveEmptyIntersection(iPredicate.getFuns(), unmodifiableTransFormula.getNonTheoryConsts());
    }

    protected static boolean disjointFunctions(IPredicate iPredicate, IPredicate iPredicate2) {
        return DataStructureUtils.haveEmptyIntersection(iPredicate.getFuns(), iPredicate2.getFuns());
    }

    protected boolean containsConflictingNonModifiableOldVars(String string, IPredicate iPredicate) {
        for (IProgramVar iProgramVar : iPredicate.getVars()) {
            IProgramNonOldVar iProgramNonOldVar;
            if (!iProgramVar.isOldvar() || this.mModifiableGlobals.isModifiable(iProgramNonOldVar = ((IProgramOldVar)iProgramVar).getNonOldVar(), string) || !iPredicate.getVars().contains(iProgramNonOldVar)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isOrIteFormula(IPredicate iPredicate) {
        Term term = iPredicate.getFormula();
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            return "or".equals(functionSymbol.getName()) || "ite".equals(functionSymbol.getName());
        }
        return false;
    }
}

