/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.ITermEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class VariableTermEvaluator<VALUE extends INonrelationalValue<VALUE>, STATE extends NonrelationalState<STATE, VALUE>>
implements ITermEvaluator<VALUE, STATE> {
    private final String mVariable;
    private final Set<String> mVariableNames;
    private final Sort mSort;
    private final INonrelationalValueFactory<VALUE> mNonrelationalValueFactory;
    private IProgramVarOrConst mVar;
    private boolean mContainsBoolean = false;

    protected VariableTermEvaluator(String string, Sort sort, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory) {
        this.mVariable = string;
        this.mVariableNames = Collections.singleton(string);
        this.mSort = sort;
        this.mNonrelationalValueFactory = iNonrelationalValueFactory;
    }

    @Override
    public List<IEvaluationResult<VALUE>> evaluate(STATE STATE) {
        Object object2;
        assert (STATE != null);
        ArrayList<IEvaluationResult<VALUE>> arrayList = new ArrayList<IEvaluationResult<VALUE>>();
        BooleanValue booleanValue = BooleanValue.TOP;
        for (Object object2 : ((NonrelationalState)STATE).getVariables()) {
            if (!object2.getGloballyUniqueId().equals(this.mVariable)) continue;
            this.mVar = object2;
            break;
        }
        if (this.mVar == null) {
            throw new UnsupportedOperationException("Variable " + this.mVariable + " was not found in current state.");
        }
        object2 = iProgramVarOrConst -> new Triple(STATE.getValue((IProgramVarOrConst)iProgramVarOrConst), (Object)BooleanValue.TOP, (Object)false);
        Function<IProgramVarOrConst, Triple> function = iProgramVarOrConst -> new Triple(this.mNonrelationalValueFactory.createTopValue(), (Object)STATE.getBooleanValue((IProgramVarOrConst)iProgramVarOrConst), (Object)true);
        Triple triple = (Triple)TypeUtils.applyVariableFunction(object2, function, null, this.mVar);
        INonrelationalValue iNonrelationalValue = (INonrelationalValue)triple.getFirst();
        if (((Boolean)triple.getThird()).booleanValue()) {
            booleanValue = (BooleanValue)triple.getSecond();
            this.mContainsBoolean = true;
        }
        if (iNonrelationalValue.isBottom() || booleanValue.isBottom()) {
            arrayList.add(new NonrelationalEvaluationResult<VALUE>(this.mNonrelationalValueFactory.createBottomValue(), BooleanValue.BOTTOM));
        } else {
            arrayList.add(new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue, booleanValue));
        }
        return arrayList;
    }

    @Override
    public List<STATE> inverseEvaluate(IEvaluationResult<VALUE> iEvaluationResult, STATE STATE) {
        assert (iEvaluationResult != null);
        assert (STATE != null);
        ArrayList arrayList = new ArrayList();
        if (this.mContainsBoolean) {
            arrayList.add(((NonrelationalState)STATE).setBooleanValue(this.mVar, iEvaluationResult.getBooleanValue()));
        } else {
            arrayList.add(((NonrelationalState)STATE).setValue(this.mVar, (INonrelationalValue)((INonrelationalValue)iEvaluationResult.getValue())));
        }
        return arrayList;
    }

    @Override
    public void addSubEvaluator(ITermEvaluator<VALUE, STATE> iTermEvaluator) {
        throw new UnsupportedOperationException("Cannot add sub evaluator to variable term evaluators.");
    }

    @Override
    public boolean hasFreeOperands() {
        return false;
    }

    @Override
    public boolean containsBool() {
        return this.mContainsBoolean;
    }

    @Override
    public Set<String> getVarIdentifiers() {
        return this.mVariableNames;
    }

    public String toString() {
        return this.mVariable;
    }
}

