/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.astbuilder;

import de.uni_freiburg.informatik.ultimate.astbuilder.ACSLEmit;
import de.uni_freiburg.informatik.ultimate.astbuilder.CrocottaEmit;
import de.uni_freiburg.informatik.ultimate.astbuilder.Emit;
import de.uni_freiburg.informatik.ultimate.astbuilder.Grammar;
import de.uni_freiburg.informatik.ultimate.astbuilder.Lexer;
import de.uni_freiburg.informatik.ultimate.astbuilder.NewUltimateEmit;
import de.uni_freiburg.informatik.ultimate.astbuilder.parser;
import java.io.FileReader;

public final class Main {
    private static final String PARSE_ERROR_IN_FILE = "Parse Error in file: ";

    private Main() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Main.usage();
            System.exit(1);
            return;
        }
        Emit emit = null;
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if ("-debug".equals(stringArray[n])) {
                ++n;
                bl = true;
                continue;
            }
            if ("-crocotta".equals(stringArray[n])) {
                ++n;
                emit = new CrocottaEmit();
                continue;
            }
            if ("-ultimatenew".equals(stringArray[n])) {
                ++n;
                emit = new NewUltimateEmit();
                continue;
            }
            if (!"-acsl".equals(stringArray[n])) break;
            ++n;
            emit = new ACSLEmit();
        }
        if (emit == null) {
            emit = new Emit();
        }
        while (n < stringArray.length) {
            try {
                Grammar grammar = Main.parseParam(stringArray[n], bl);
                if (grammar == null) {
                    System.err.println(PARSE_ERROR_IN_FILE + stringArray[n]);
                    System.exit(1);
                }
                emit.setGrammar(grammar);
                emit.emitClasses();
            }
            catch (Exception exception) {
                System.err.println(PARSE_ERROR_IN_FILE + stringArray[n] + ": " + exception.getMessage());
                if (bl) {
                    System.err.println(exception);
                }
                System.exit(1);
                return;
            }
            ++n;
        }
    }

    private static Grammar parseParam(String string, boolean bl) throws Exception {
        Lexer lexer = new Lexer(new FileReader(string));
        parser parser2 = new parser(lexer);
        parser2.setFileName(string);
        if (bl) {
            return (Grammar)parser2.debug_parse().value;
        }
        return (Grammar)parser2.parse().value;
    }

    private static void usage() {
        System.err.println("java TreeBuilder.Main <options> <filename>");
        System.err.println("<options>:  -debug");
        System.err.println("            -ultimate");
        System.err.println("            -acsl");
    }
}

