/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.alternating;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.alternating.BooleanExpression;
import de.uni_freiburg.informatik.ultimate.automata.alternating.visualization.AAToUltimateModel;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AlternatingAutomaton<LETTER, STATE>
implements IAutomaton<LETTER, STATE> {
    private final Set<LETTER> mAlphabet;
    private final ArrayList<STATE> mStates = new ArrayList();
    private final HashMap<STATE, Integer> mStatesIndices = new HashMap();
    private final HashMap<LETTER, BooleanExpression[]> mTransitionFunction = new HashMap();
    private BooleanExpression mAcceptingFunction;
    private final BitSet mFinalStatesBitVector = new BitSet();
    private boolean mIsReversed;

    public AlternatingAutomaton(Set<LETTER> set) {
        this.mAlphabet = set;
    }

    public void addState(STATE STATE) {
        if (!this.mStates.contains(STATE)) {
            int n = this.mStates.size();
            this.mStates.add(STATE);
            this.mStatesIndices.put(STATE, n);
        }
    }

    public void addTransition(LETTER LETTER, STATE STATE, BooleanExpression booleanExpression) {
        int n;
        BooleanExpression[] booleanExpressionArray = this.mTransitionFunction.get(LETTER);
        if (booleanExpressionArray == null) {
            booleanExpressionArray = new BooleanExpression[64];
            this.mTransitionFunction.put(LETTER, booleanExpressionArray);
        }
        if (booleanExpressionArray[n = this.getStateIndex(STATE)] == null) {
            booleanExpressionArray[n] = booleanExpression;
        } else {
            booleanExpressionArray[n].addConjunction(booleanExpression);
        }
    }

    public void addAcceptingConjunction(BooleanExpression booleanExpression) {
        if (this.mAcceptingFunction == null) {
            this.mAcceptingFunction = booleanExpression;
        } else {
            this.mAcceptingFunction.addConjunction(booleanExpression);
        }
    }

    public BooleanExpression generateCube(STATE[] STATEArray, STATE[] STATEArray2) {
        int n;
        STATE STATE;
        BitSet bitSet = new BitSet(this.mStates.size());
        BitSet bitSet2 = new BitSet(this.mStates.size());
        STATE[] STATEArray3 = STATEArray;
        int n2 = STATEArray.length;
        int n3 = 0;
        while (n3 < n2) {
            STATE = STATEArray3[n3];
            n = this.getStateIndex(STATE);
            bitSet.set(n);
            bitSet2.set(n);
            ++n3;
        }
        STATEArray3 = STATEArray2;
        n2 = STATEArray2.length;
        n3 = 0;
        while (n3 < n2) {
            STATE = STATEArray3[n3];
            n = this.getStateIndex(STATE);
            bitSet.set(n);
            ++n3;
        }
        return new BooleanExpression(bitSet, bitSet2);
    }

    public void setStateFinal(STATE STATE) {
        int n = this.getStateIndex(STATE);
        this.mFinalStatesBitVector.set(n);
    }

    public boolean isStateFinal(STATE STATE) {
        int n = this.getStateIndex(STATE);
        return this.mFinalStatesBitVector.get(n);
    }

    public boolean accepts(Word<LETTER> word) {
        BitSet bitSet = (BitSet)this.mFinalStatesBitVector.clone();
        if (this.mIsReversed) {
            int n = 0;
            while (n < word.length()) {
                this.resolveLetter(word.getSymbol(n), bitSet);
                ++n;
            }
        } else {
            int n = word.length() - 1;
            while (n >= 0) {
                this.resolveLetter(word.getSymbol(n), bitSet);
                --n;
            }
        }
        return this.mAcceptingFunction.getResult(bitSet);
    }

    public void resolveLetter(LETTER LETTER, BitSet bitSet) {
        BooleanExpression[] booleanExpressionArray = this.mTransitionFunction.get(LETTER);
        if (booleanExpressionArray != null) {
            BitSet bitSet2 = (BitSet)bitSet.clone();
            int n = 0;
            while (n < this.mStates.size()) {
                boolean bl = booleanExpressionArray[n] != null ? booleanExpressionArray[n].getResult(bitSet2) : false;
                bitSet.set(n, bl);
                ++n;
            }
        } else {
            bitSet.clear();
        }
    }

    public ArrayList<STATE> getStates() {
        return this.mStates;
    }

    public int getStateIndex(STATE STATE) {
        return this.mStatesIndices.get(STATE);
    }

    public HashMap<LETTER, BooleanExpression[]> getTransitionFunction() {
        return this.mTransitionFunction;
    }

    public BooleanExpression getAcceptingFunction() {
        return this.mAcceptingFunction;
    }

    public BitSet getFinalStatesBitVector() {
        return this.mFinalStatesBitVector;
    }

    public void setReversed(boolean bl) {
        this.mIsReversed = bl;
    }

    public boolean isReversed() {
        return this.mIsReversed;
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mAlphabet;
    }

    @Override
    public int size() {
        return this.mStates.size();
    }

    @Override
    public String sizeInformation() {
        return "Number of states";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[AlternatingAutomaton\n\tAlphabet = {");
        Iterator<LETTER> iterator = this.mAlphabet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (n != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(iterator.next());
            ++n;
        }
        stringBuilder.append("}\n\tStates = {");
        int n2 = 0;
        while (n2 < this.mStates.size()) {
            if (n2 != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.mStates.get(n2));
            ++n2;
        }
        stringBuilder.append("}\n\tFinalStates = {");
        n = 0;
        n2 = 0;
        while (n2 < this.mStates.size()) {
            if (this.mFinalStatesBitVector.get(n2)) {
                if (n != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.mStates.get(n2));
                ++n;
            }
            ++n2;
        }
        stringBuilder.append("}\n\tAcceptingFunction = ").append(this.mAcceptingFunction.toString(this.mStates)).append("\n\tTransistions = {\n");
        n = 0;
        for (Map.Entry<LETTER, BooleanExpression[]> entry : this.mTransitionFunction.entrySet()) {
            stringBuilder.append("\t\t").append(entry.getKey()).append(" => {\n");
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.mStates.size()) {
                if (entry.getValue()[n4] != null) {
                    if (n3 != 0) {
                        stringBuilder.append(",\n");
                    }
                    stringBuilder.append("\t\t\t").append(this.mStates.get(n4)).append(" => ").append(entry.getValue()[n4].toString(this.mStates));
                    ++n3;
                }
                ++n4;
            }
            stringBuilder.append("\n\t\t}");
            if (n != this.mTransitionFunction.size() - 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\n");
            ++n;
        }
        stringBuilder.append("\t}\n]");
        return stringBuilder.toString();
    }

    @Override
    public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        return new AAToUltimateModel().transformToUltimateModel(this);
    }
}

