/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class CsvProviderColumnFilter<T>
implements ICsvProviderTransformer<T> {
    private final Predicate<String> mPredicate;

    public CsvProviderColumnFilter(Predicate<String> predicate) {
        this.mPredicate = predicate;
    }

    @Override
    public ICsvProvider<T> transform(ICsvProvider<T> iCsvProvider) {
        List<String> list = iCsvProvider.getColumnTitles();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        boolean[] blArray = new boolean[list.size()];
        Iterator<String> iterator = list.iterator();
        int n = 0;
        while (n < blArray.length) {
            String string = iterator.next();
            if (this.mPredicate.test(string)) {
                arrayList.add(string);
                blArray[n] = true;
            }
            ++n;
        }
        arrayList.trimToSize();
        if (arrayList.size() == list.size()) {
            return iCsvProvider;
        }
        SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(arrayList);
        int n2 = 0;
        while (n2 < iCsvProvider.getRowHeaders().size()) {
            ArrayList<T> arrayList2 = new ArrayList<T>();
            List<T> list2 = iCsvProvider.getRow(n2);
            Iterator<T> iterator2 = list2.iterator();
            int n3 = 0;
            while (n3 < list2.size()) {
                T t = iterator2.next();
                if (blArray[n3]) {
                    arrayList2.add(t);
                }
                ++n3;
            }
            simpleCsvProvider.addRow(arrayList2);
            ++n2;
        }
        return simpleCsvProvider;
    }

    public static class NameFilter
    implements Predicate<String> {
        private final Collection<String> mFilterNames;

        public NameFilter(Collection<String> collection) {
            this.mFilterNames = collection;
        }

        @Override
        public boolean test(String string) {
            return this.mFilterNames.contains(string);
        }
    }
}

