/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;

public class LimitsLibraryModel
implements ILibraryModel {
    private final TypeSizes mTypeSizes;
    private final FunctionModelHelper mHelper;

    public LimitsLibraryModel(TypeSizes typeSizes, FunctionModelHelper functionModelHelper) {
        this.mTypeSizes = typeSizes;
        this.mHelper = functionModelHelper;
    }

    private ExpressionResult getMinValue(ILocation iLocation, CPrimitive.CPrimitives cPrimitives) {
        CPrimitive cPrimitive = new CPrimitive(cPrimitives);
        BigInteger bigInteger = this.mTypeSizes.getMinValueOfPrimitiveType(cPrimitive);
        return this.mHelper.constructIntegerLiteral(iLocation, bigInteger, cPrimitive);
    }

    private ExpressionResult getMaxValue(ILocation iLocation, CPrimitive.CPrimitives cPrimitives) {
        CPrimitive cPrimitive = new CPrimitive(cPrimitives);
        BigInteger bigInteger = this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive);
        return this.mHelper.constructIntegerLiteral(iLocation, bigInteger, cPrimitive);
    }

    @Override
    public Collection<ILibraryModel.ConstantModel> getConstantModels() {
        return List.of(new ILibraryModel.ConstantModel("CHAR_MIN", iLocation -> this.getMinValue(iLocation, CPrimitive.CPrimitives.CHAR)), new ILibraryModel.ConstantModel("CHAR_MAX", iLocation -> this.getMaxValue(iLocation, CPrimitive.CPrimitives.CHAR)), new ILibraryModel.ConstantModel("SCHAR_MIN", iLocation -> this.getMinValue(iLocation, CPrimitive.CPrimitives.SCHAR)), new ILibraryModel.ConstantModel("SCHAR_MAX", iLocation -> this.getMaxValue(iLocation, CPrimitive.CPrimitives.SCHAR)), new ILibraryModel.ConstantModel("SHRT_MIN", iLocation -> this.getMinValue(iLocation, CPrimitive.CPrimitives.SHORT)), new ILibraryModel.ConstantModel("SHRT_MAX", iLocation -> this.getMaxValue(iLocation, CPrimitive.CPrimitives.SHORT)), new ILibraryModel.ConstantModel("INT_MIN", iLocation -> this.getMinValue(iLocation, CPrimitive.CPrimitives.INT)), new ILibraryModel.ConstantModel("INT_MAX", iLocation -> this.getMaxValue(iLocation, CPrimitive.CPrimitives.INT)), new ILibraryModel.ConstantModel("LONG_MIN", iLocation -> this.getMinValue(iLocation, CPrimitive.CPrimitives.LONG)), new ILibraryModel.ConstantModel("LONG_MAX", iLocation -> this.getMaxValue(iLocation, CPrimitive.CPrimitives.LONG)), new ILibraryModel.ConstantModel("LLONG_MIN", iLocation -> this.getMinValue(iLocation, CPrimitive.CPrimitives.LONGLONG)), new ILibraryModel.ConstantModel("LLONG_MAX", iLocation -> this.getMaxValue(iLocation, CPrimitive.CPrimitives.LONGLONG)), new ILibraryModel.ConstantModel("UCHAR_MAX", iLocation -> this.getMaxValue(iLocation, CPrimitive.CPrimitives.UCHAR)), new ILibraryModel.ConstantModel("USHRT_MAX", iLocation -> this.getMaxValue(iLocation, CPrimitive.CPrimitives.USHORT)), new ILibraryModel.ConstantModel("UINT_MAX", iLocation -> this.getMaxValue(iLocation, CPrimitive.CPrimitives.UINT)), new ILibraryModel.ConstantModel("ULONG_MAX", iLocation -> this.getMaxValue(iLocation, CPrimitive.CPrimitives.ULONG)), new ILibraryModel.ConstantModel("ULLONG_MAX", iLocation -> this.getMaxValue(iLocation, CPrimitive.CPrimitives.ULONGLONG)));
    }
}

