/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.ConstraintAdministrationSolver;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Heuristics;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusContainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.ReMus;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Shrinking;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Translator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.UnexploredMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.BooleanOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.DoubleOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.EnumOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.LongOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.TimeoutHandler;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class MusEnumerationScript
extends WrapperScript {
    TimeoutHandler mHandler;
    ScopedArrayList<Term> mRememberedAssertions;
    int mCustomNameId;
    boolean mAssertedTermsAreUnsat;
    EnumOption<HeuristicsType> mInterpolationHeuristic;
    DoubleOption mTolerance;
    LongOption mEnumerationTimeout;
    LongOption mHeuristicTimeout;
    BooleanOption mLogAdditionalInformation;
    BooleanOption mUnknownAllowed;
    LogProxy mLogger;
    Random mRandom;

    public MusEnumerationScript() {
        this(new SMTInterpol());
    }

    public MusEnumerationScript(SMTInterpol sMTInterpol) {
        this(sMTInterpol, null);
    }

    public MusEnumerationScript(SMTInterpol sMTInterpol, LogProxy logProxy) {
        super((Script)sMTInterpol);
        assert (sMTInterpol instanceof SMTInterpol) : "Currently, only SMTInterpol is supported.";
        SMTInterpol sMTInterpol2 = (SMTInterpol)this.mScript;
        this.mCustomNameId = 0;
        this.mAssertedTermsAreUnsat = false;
        this.mHandler = new TimeoutHandler(sMTInterpol2.getTerminationRequest());
        this.mLogger = logProxy == null ? sMTInterpol.getLogger() : logProxy;
        this.mRandom = new Random(this.getRandomSeed());
        this.mRememberedAssertions = new ScopedArrayList();
        this.mInterpolationHeuristic = new EnumOption<HeuristicsType>(HeuristicsType.RANDOM, true, HeuristicsType.class, "The Heuristic that is used to choose a minimal unsatisfiable subset/core for interpolant generation");
        this.mTolerance = new DoubleOption(0.1, true, "The tolerance value that is used by the SMALLESTAMONGWIDE and the WIDESTAMONGSMALL Heuristic.");
        this.mEnumerationTimeout = new LongOption(0L, true, "The time that is invested into enumerating Muses");
        this.mHeuristicTimeout = new LongOption(0L, true, "The time that is invested into finding the best Mus according to the set Heuristic");
        this.mLogAdditionalInformation = new BooleanOption(false, true, "Whether additional information (e.g. of the enumeration) should be logged.");
        this.mUnknownAllowed = new BooleanOption(false, true, "Whether LBool.UNKNOWN is allowed to occur in the enumeration process.");
    }

    private long getRandomSeed() {
        return ((BigInteger)this.getOption(":random-seed")).longValue();
    }

    private long getEnumerationTimeout() {
        return ((BigInteger)this.getOption(":enumeration-timeout")).longValue();
    }

    private long getHeuristicTimeout() {
        return ((BigInteger)this.getOption(":heuristic-timeout")).longValue();
    }

    public FunctionSymbol getFunctionSymbol(String string) {
        return this.mScript.getFunctionSymbol(string);
    }

    public Term[] getInterpolants(Term[] termArray) {
        int[] nArray = new int[termArray.length];
        return this.getInterpolants(termArray, nArray);
    }

    public Term[] getInterpolants(Term[] termArray, int[] nArray, Term term) {
        return this.mScript.getInterpolants(termArray, nArray, term);
    }

    public Term[] getInterpolants(Term[] termArray, int[] nArray) {
        Object object;
        if (!this.mAssertedTermsAreUnsat) {
            throw new SMTLIBException("Asserted terms must be determined to be unsatisfiable before an interpolant can be generated. Call checkSat to determine satisfiability.");
        }
        if (!((Boolean)this.getOption(":produce-proofs")).booleanValue()) {
            throw new SMTLIBException("Proof production must be enabled (you can do this via setOption).");
        }
        if (!((Boolean)this.getOption(":produce-unsat-cores")).booleanValue() && this.mInterpolationHeuristic.getValue() == HeuristicsType.FIRST) {
            throw new SMTLIBException("For the FIRST Heuristic, unsat core production must be enabled.");
        }
        Translator translator = new Translator();
        long l = this.getEnumerationTimeout();
        long l2 = this.getHeuristicTimeout();
        if (l > 0L) {
            this.mHandler.setTimeout(l);
        }
        long l3 = System.nanoTime();
        ArrayList<MusContainer> arrayList = this.mInterpolationHeuristic.getValue() == HeuristicsType.FIRST ? this.shrinkVanillaUnsatCore(translator) : this.executeReMus(translator);
        l3 = (System.nanoTime() - l3) / 1000000L;
        if (this.mLogAdditionalInformation.getValue()) {
            object = l <= 0L ? "Unlimited (no timeout set)" : Long.toString(l);
            this.mLogger.fatal("Timeout: " + (String)object);
            this.mLogger.fatal("Cardinality of Constraint set: " + translator.getNumberOfConstraints());
            this.mLogger.fatal("Number of enumerated Muses: " + arrayList.size());
            this.mLogger.fatal("Time needed for enumeration: " + l3);
        }
        this.mHandler.clearTimeout();
        if (arrayList.isEmpty()) {
            if (this.mLogAdditionalInformation.getValue()) {
                this.mLogger.fatal("Timeout for enumeration exceeded before any muses could be found.");
                this.mLogger.fatal("Heuristic: None (UC is from Vanilla-SMTInterpol)");
                if (((Boolean)this.getOption(":produce-unsat-cores")).booleanValue()) {
                    object = new MusContainer(translator.translateToBitSet(this.mScript.getUnsatCore()), null);
                    this.mLogger.fatal("Vanilla-UC has size: " + Heuristics.size((MusContainer)object));
                    this.mLogger.fatal("Vanilla-UC has depth: " + Heuristics.depth((MusContainer)object));
                    this.mLogger.fatal("Vanilla-UC has width: " + Heuristics.width((MusContainer)object));
                }
            }
            object = this.getInterpolants(termArray, nArray, this.mScript.getProof());
            return object;
        }
        if (l2 > 0L) {
            this.mHandler.setTimeout(l2);
        }
        l3 = System.nanoTime();
        object = this.chooseMusAccordingToHeuristic(arrayList, this.mHandler);
        l3 = (System.nanoTime() - l3) / 1000000L;
        if (this.mLogAdditionalInformation.getValue()) {
            this.mLogger.fatal("Time needed for Heuristics: " + l3);
        }
        this.mHandler.clearTimeout();
        Term[] termArray2 = this.getInterpolants(termArray, nArray, ((MusContainer)object).getProof());
        return termArray2;
    }

    public Term[] getUnsatCore() {
        Object object;
        if (!this.mAssertedTermsAreUnsat) {
            throw new SMTLIBException("Asserted Terms must be determined Unsat to return an unsat core. Call checkSat to determine satisfiability.");
        }
        if (!((Boolean)this.getOption(":produce-unsat-cores")).booleanValue()) {
            throw new SMTLIBException("Unsat core production must be enabled (you can do this via setOption).");
        }
        Translator translator = new Translator();
        long l = this.getEnumerationTimeout();
        long l2 = this.getHeuristicTimeout();
        if (l > 0L) {
            this.mHandler.setTimeout(l);
        }
        long l3 = System.nanoTime();
        ArrayList<MusContainer> arrayList = this.mInterpolationHeuristic.getValue() == HeuristicsType.FIRST ? this.shrinkVanillaUnsatCore(translator) : this.executeReMus(translator);
        l3 = (System.nanoTime() - l3) / 1000000L;
        if (this.mLogAdditionalInformation.getValue()) {
            object = l <= 0L ? "Unlimited (no timeout set)" : Long.toString(l);
            this.mLogger.fatal("Timeout: " + (String)object);
            this.mLogger.fatal("Cardinality of Constraint set: " + translator.getNumberOfConstraints());
            this.mLogger.fatal("Number of enumerated Muses: " + arrayList.size());
            this.mLogger.fatal("Time needed for enumeration: " + l3);
        }
        this.mHandler.clearTimeout();
        if (arrayList.isEmpty()) {
            object = this.mScript.getUnsatCore();
            if (this.mLogAdditionalInformation.getValue()) {
                this.mLogger.fatal("Enumeration timeout exceeded. Returning Unsat Core of wrapped Script.");
                MusContainer musContainer = new MusContainer(translator.translateToBitSet((Term[])object), null);
                this.mLogger.fatal("Heuristic: None (UC is from Vanilla-SMTInterpol)");
                this.mLogger.fatal("Vanilla-UC has size: " + Heuristics.size(musContainer));
                this.mLogger.fatal("Vanilla-UC has depth: " + Heuristics.depth(musContainer));
                this.mLogger.fatal("Vanilla-UC has width: " + Heuristics.width(musContainer));
            }
            return object;
        }
        if (l2 > 0L) {
            this.mHandler.setTimeout(l2);
        }
        l3 = System.nanoTime();
        object = this.chooseMusAccordingToHeuristic(arrayList, this.mHandler);
        l3 = (System.nanoTime() - l3) / 1000000L;
        if (this.mLogAdditionalInformation.getValue()) {
            this.mLogger.fatal("Time needed for Heuristics: " + l3);
        }
        this.mHandler.clearTimeout();
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>();
        Term[] termArray = translator.translateToTerms(((MusContainer)object).getMus());
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            if (term instanceof AnnotatedTerm) {
                AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
                Annotation[] annotationArray = annotatedTerm.getAnnotations();
                int n3 = annotationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation annotation = annotationArray[n4];
                    if (annotation.getKey().equals(":named")) {
                        String string = ((String)annotation.getValue()).intern();
                        arrayDeque.add(term.getTheory().term(string, new Term[0]));
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return arrayDeque.toArray(new Term[arrayDeque.size()]);
    }

    private ArrayList<MusContainer> executeReMus() {
        Translator translator = new Translator();
        return this.executeReMus(translator);
    }

    private ArrayList<MusContainer> executeReMus(Translator translator) {
        if (translator.getNumberOfConstraints() != 0) {
            throw new SMTLIBException("Translator must be new.");
        }
        TimeoutHandler timeoutHandler = new TimeoutHandler(this.mHandler);
        DPLLEngine dPLLEngine = new DPLLEngine(this.mLogger, timeoutHandler);
        Script script = this.createScriptForMuses((SMTInterpol)this.mScript, timeoutHandler);
        this.registerTermsForEnumeration(this.mRememberedAssertions, translator, dPLLEngine, script);
        this.resetCustomNameId();
        UnexploredMap unexploredMap = new UnexploredMap(dPLLEngine, translator);
        ConstraintAdministrationSolver constraintAdministrationSolver = new ConstraintAdministrationSolver(script, translator);
        int n = constraintAdministrationSolver.getNumberOfConstraints();
        BitSet bitSet = new BitSet(n);
        bitSet.flip(0, n);
        LogProxy logProxy = this.mLogAdditionalInformation.getValue() ? this.mLogger : null;
        ReMus reMus = new ReMus(constraintAdministrationSolver, unexploredMap, bitSet, timeoutHandler, 0L, this.mRandom, this.mUnknownAllowed.getValue(), logProxy);
        ArrayList<MusContainer> arrayList = reMus.enumerate();
        this.letScriptForReMusRetire(script, reMus);
        return arrayList;
    }

    private ArrayList<MusContainer> shrinkVanillaUnsatCore(Translator translator) {
        Term[] termArray = this.mScript.getUnsatCore();
        ArrayList<MusContainer> arrayList = new ArrayList<MusContainer>();
        TimeoutHandler timeoutHandler = this.mHandler;
        Script script = this.createScriptForMuses((SMTInterpol)this.mScript, timeoutHandler);
        this.registerTermsForShrinking(this.mRememberedAssertions, translator, script);
        this.resetCustomNameId();
        ConstraintAdministrationSolver constraintAdministrationSolver = new ConstraintAdministrationSolver(script, translator);
        BitSet bitSet = translator.translateToBitSet(termArray);
        MusContainer musContainer = Shrinking.shrink(constraintAdministrationSolver, bitSet, timeoutHandler, this.mRandom, this.mUnknownAllowed.getValue());
        if (musContainer != null) {
            arrayList.add(musContainer);
            if (this.mLogAdditionalInformation.getValue()) {
                MusContainer musContainer2 = new MusContainer(bitSet, null);
                int n = Heuristics.size(musContainer2) - Heuristics.size(musContainer);
                int n2 = Heuristics.depth(musContainer2) - Heuristics.depth(musContainer);
                int n3 = Heuristics.width(musContainer2) - Heuristics.width(musContainer);
                this.mLogger.fatal("Difference in size: " + n);
                this.mLogger.fatal("Difference in depth: " + n2);
                this.mLogger.fatal("Difference in width: " + n3);
            }
        }
        this.letScriptForShrinkerRetire(script, constraintAdministrationSolver);
        return arrayList;
    }

    private Script createScriptForMuses(SMTInterpol sMTInterpol, TerminationRequest terminationRequest) {
        Map<String, Object> map = this.createSMTInterpolOptionsForReMus();
        SMTInterpol sMTInterpol2 = new SMTInterpol(sMTInterpol, map, OptionMap.CopyMode.CURRENT_VALUE);
        sMTInterpol2.setTerminationRequest(terminationRequest);
        sMTInterpol2.push(1);
        return sMTInterpol2;
    }

    private Map<String, Object> createSMTInterpolOptionsForReMus() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(":produce-models", true);
        hashMap.put(":produce-proofs", true);
        hashMap.put(":interactive-mode", true);
        hashMap.put(":produce-unsat-cores", true);
        return hashMap;
    }

    private void letScriptForReMusRetire(Script script, ReMus reMus) {
        reMus.resetSolver();
        script.pop(1);
    }

    private void letScriptForShrinkerRetire(Script script, ConstraintAdministrationSolver constraintAdministrationSolver) {
        constraintAdministrationSolver.reset();
        script.pop(1);
    }

    private boolean hasName(Term term) {
        if (term instanceof AnnotatedTerm) {
            AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
            Annotation[] annotationArray = annotatedTerm.getAnnotations();
            String string = this.findName(annotationArray);
            return string != null;
        }
        return false;
    }

    private String findName(Annotation[] annotationArray) {
        String string = null;
        int n = 0;
        while (n < annotationArray.length) {
            if (annotationArray[n].getKey().equals(":named")) {
                string = (String)annotationArray[n].getValue();
            }
            ++n;
        }
        return string;
    }

    private AnnotatedTerm nameTerm(Term term, Script script) {
        Annotation annotation = new Annotation(":named", (Object)("constraint" + Integer.toString(this.mCustomNameId)));
        ++this.mCustomNameId;
        return (AnnotatedTerm)script.annotate(term, new Annotation[]{annotation});
    }

    private void registerTermsForEnumeration(ArrayList<Term> arrayList, Translator translator, DPLLEngine dPLLEngine, Script script) {
        for (Term term : arrayList) {
            if (!this.hasName(term)) {
                script.assertTerm(term);
                continue;
            }
            AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
            NamedAtom namedAtom = new NamedAtom((Term)annotatedTerm, 0);
            namedAtom.setPreferredStatus(namedAtom.getAtom());
            namedAtom.lockPreferredStatus();
            if (dPLLEngine != null) {
                dPLLEngine.addAtom(namedAtom);
            }
            translator.declareConstraint(namedAtom);
        }
    }

    private void registerTermsForShrinking(ArrayList<Term> arrayList, Translator translator, Script script) {
        this.registerTermsForEnumeration(arrayList, translator, null, script);
    }

    private MusContainer chooseMusAccordingToHeuristic(ArrayList<MusContainer> arrayList, TerminationRequest terminationRequest) {
        MusContainer musContainer;
        switch (this.mInterpolationHeuristic.getValue()) {
            case FIRST: {
                assert (arrayList.size() == 1) : "In case of the FIRST heuristic, only one mus should have been enumerated.";
                musContainer = arrayList.get(0);
            }
            case RANDOM: {
                musContainer = Heuristics.chooseRandomMus(arrayList, this.mRandom);
                break;
            }
            case SMALLEST: {
                musContainer = Heuristics.chooseSmallestMus(arrayList, this.mRandom, this.mHandler);
                break;
            }
            case BIGGEST: {
                musContainer = Heuristics.chooseBiggestMus(arrayList, this.mRandom, this.mHandler);
                break;
            }
            case LOWLEXORDER: {
                musContainer = Heuristics.chooseMusWithLowestLexicographicalOrder(arrayList, this.mRandom, this.mHandler);
                break;
            }
            case HIGHLEXORDER: {
                musContainer = Heuristics.chooseMusWithHighestLexicographicalOrder(arrayList, this.mRandom, this.mHandler);
                break;
            }
            case SHALLOWEST: {
                musContainer = Heuristics.chooseShallowestMus(arrayList, this.mRandom, this.mHandler);
                break;
            }
            case DEEPEST: {
                musContainer = Heuristics.chooseDeepestMus(arrayList, this.mRandom, this.mHandler);
                break;
            }
            case NARROWEST: {
                musContainer = Heuristics.chooseNarrowestMus(arrayList, this.mRandom, this.mHandler);
                break;
            }
            case WIDEST: {
                musContainer = Heuristics.chooseWidestMus(arrayList, this.mRandom, this.mHandler);
                break;
            }
            case SMALLESTAMONGWIDE: {
                double d = (Double)this.mTolerance.get();
                musContainer = Heuristics.chooseSmallestAmongWideMuses(arrayList, d, this.mRandom, this.mHandler);
                break;
            }
            case WIDESTAMONGSMALL: {
                double d = (Double)this.mTolerance.get();
                musContainer = Heuristics.chooseWidestAmongSmallMuses(arrayList, d, this.mRandom, this.mHandler);
                break;
            }
            default: {
                throw new SMTLIBException("Unknown Enum for Interpolation heuristic");
            }
        }
        if (this.mLogAdditionalInformation.getValue()) {
            String string = this.mInterpolationHeuristic.getValue().toString();
            this.mLogger.fatal("Heuristic: " + string);
            HeuristicsType heuristicsType = this.mInterpolationHeuristic.getValue();
            if (heuristicsType == HeuristicsType.SMALLESTAMONGWIDE || heuristicsType == HeuristicsType.WIDESTAMONGSMALL) {
                this.mLogger.fatal("Tolerance: " + (Double)this.mTolerance.get());
            }
            this.mLogger.fatal("Chosen Mus has size: " + Heuristics.size(musContainer));
            this.mLogger.fatal("Chosen Mus has depth: " + Heuristics.depth(musContainer));
            this.mLogger.fatal("Chosen Mus has width: " + Heuristics.width(musContainer));
        }
        return musContainer;
    }

    public Script.LBool checkSat() {
        Script.LBool lBool = this.mScript.checkSat();
        if (lBool == Script.LBool.UNSAT) {
            this.mAssertedTermsAreUnsat = true;
        }
        return lBool;
    }

    public void push(int n) throws SMTLIBException {
        super.push(n);
        int n2 = 0;
        while (n2 < n) {
            this.mRememberedAssertions.beginScope();
            ++n2;
        }
    }

    public void pop(int n) throws SMTLIBException {
        super.pop(n);
        int n2 = 0;
        while (n2 < n) {
            this.mRememberedAssertions.endScope();
            ++n2;
        }
        this.mAssertedTermsAreUnsat = false;
    }

    public void setOption(String string, Object object) throws UnsupportedOperationException, SMTLIBException {
        if (string.equals(":interpolation-heuristic")) {
            this.mInterpolationHeuristic.set(object);
        } else if (string.equals(":tolerance")) {
            this.mTolerance.set(object);
        } else if (string.equals(":random-seed")) {
            this.mScript.setOption(string, object);
            this.mRandom = new Random(this.getRandomSeed());
        } else if (string.equals(":enumeration-timeout")) {
            this.mEnumerationTimeout.set(object);
        } else if (string.equals(":heuristic-timeout")) {
            this.mHeuristicTimeout.set(object);
        } else if (string.equals(":log-additional-information")) {
            this.mLogAdditionalInformation.set(object);
        } else if (string.equals(":unknown-allowed")) {
            this.mUnknownAllowed.set(object);
        } else {
            this.mScript.setOption(string, object);
        }
    }

    public Object getOption(String string) throws UnsupportedOperationException {
        if (string.equals(":interpolation-heuristic")) {
            return this.mInterpolationHeuristic.get();
        }
        if (string.equals(":tolerance")) {
            return this.mTolerance.get();
        }
        if (string.equals(":enumeration-timeout")) {
            return this.mEnumerationTimeout.get();
        }
        if (string.equals(":heuristic-timeout")) {
            return this.mHeuristicTimeout.get();
        }
        if (string.equals(":log-additional-information")) {
            return this.mLogAdditionalInformation.getValue();
        }
        if (string.equals(":unknown-allowed")) {
            return this.mUnknownAllowed.getValue();
        }
        return this.mScript.getOption(string);
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mRememberedAssertions.add(term);
        this.mAssertedTermsAreUnsat = false;
        return this.mScript.assertTerm(term);
    }

    public void reset() {
        this.mScript.reset();
        this.mRememberedAssertions.clear();
        this.mCustomNameId = 0;
        this.mAssertedTermsAreUnsat = false;
        this.mInterpolationHeuristic.reset();
        this.mTolerance.reset();
        this.mEnumerationTimeout.reset();
        this.mHeuristicTimeout.reset();
        this.mLogAdditionalInformation.reset();
        this.mRandom = new Random(this.getRandomSeed());
    }

    public void resetAssertions() {
        this.mScript.resetAssertions();
        this.mRememberedAssertions.clear();
        this.mAssertedTermsAreUnsat = false;
    }

    private void resetCustomNameId() {
        this.mCustomNameId = 0;
    }

    public static enum HeuristicsType {
        RANDOM,
        SMALLEST,
        BIGGEST,
        LOWLEXORDER,
        HIGHLEXORDER,
        SHALLOWEST,
        DEEPEST,
        NARROWEST,
        WIDEST,
        SMALLESTAMONGWIDE,
        WIDESTAMONGSMALL,
        FIRST;

    }
}

