/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.IntBlastingWrapper;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationConstrainer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class BvToIntTransferrer
extends TermTransferrer {
    private final Script mScript;
    private final Script mBvScript;
    private static final String BITVEC_CONST_PATTERN = "bv\\d+";
    private final boolean mNutzTransformation;
    private final ManagedScript mMgdScript;
    private final TermVariable[] mFreeVars;
    private final TranslationConstrainer mTc;
    private final LinkedHashMap<Term, Term> mVariableMap;
    private final LinkedHashMap<Term, Term> mReversedVarMap;
    public final LinkedHashMap<Term, Term> mArrayConstraintMap;
    private final Set<Term> mOverapproxVariables;
    private boolean mIsOverapproximation;
    int utsCount = 0;
    int moduloCount = 0;
    int arithmeticBvCount = 0;
    int bvandCount = 0;
    int shiftsCount = 0;
    int concatCount = 0;
    int bvdivBvmodCount = 0;

    public BvToIntTransferrer(Script script, Script script2, ManagedScript managedScript, LinkedHashMap<Term, Term> linkedHashMap, TranslationConstrainer translationConstrainer, TermVariable[] termVariableArray, boolean bl) {
        super(script, script2);
        this.mMgdScript = managedScript;
        this.mScript = script2;
        this.mBvScript = script;
        this.mNutzTransformation = bl;
        this.mFreeVars = termVariableArray;
        this.mVariableMap = linkedHashMap != null ? linkedHashMap : new LinkedHashMap();
        this.mReversedVarMap = new LinkedHashMap();
        this.mArrayConstraintMap = new LinkedHashMap();
        this.mOverapproxVariables = new HashSet<Term>();
        this.mIsOverapproximation = false;
        this.mTc = translationConstrainer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void convert(Term term) {
        block45: {
            Sort sort;
            block44: {
                sort = SmtSortUtils.getIntSort(this.mScript);
                if (term instanceof TermVariable) {
                    TermVariable[] termVariableArray = this.mFreeVars;
                    int n = this.mFreeVars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TermVariable termVariable = termVariableArray[n2];
                        if (term == termVariable && SmtSortUtils.isBitvecSort(term.getSort())) {
                            Term term2 = this.translateVars(term, true);
                            assert (SmtSortUtils.isIntSort(term2.getSort()));
                            this.mTc.varConstraint(term, term2);
                            this.setResult(term2);
                            return;
                        }
                        ++n2;
                    }
                    this.setResult(this.translateVars(term, true));
                    return;
                }
                if (!(term instanceof ApplicationTerm)) break block44;
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                if (applicationTerm.getParameters().length == 0 && SmtUtils.isConstant((Term)applicationTerm)) {
                    Term term3 = this.translateVars(term, true);
                    if (SmtSortUtils.isBitvecSort(term.getSort())) {
                        this.mTc.varConstraint(term, term3);
                    }
                    this.setResult(term3);
                    return;
                }
                if (this.mTc.mMode.equals((Object)TranslationConstrainer.ConstraintsForBitwiseOperations.NONE) && this.overaproxWithVars(applicationTerm)) {
                    Sort sort2 = IntBlastingWrapper.translateSort(this.mScript, applicationTerm.getSort());
                    TermVariable termVariable = this.mMgdScript.constructFreshTermVariable("overaproxVar", sort2);
                    Term term4 = SmtUtils.termVariable2constant(this.mScript, termVariable, true);
                    this.mOverapproxVariables.add(term4);
                    this.mIsOverapproximation = true;
                    this.setResult(term4);
                    return;
                }
                if (!functionSymbol.isIntern()) break block45;
                switch (functionSymbol.getName()) {
                    case "bvor": {
                        Term term5 = BitvectorUtils.unfTerm(this.mBvScript, "bvsub", null, BitvectorUtils.unfTerm(this.mBvScript, "bvadd", null, applicationTerm.getParameters()), BitvectorUtils.unfTerm(this.mBvScript, "bvand", null, applicationTerm.getParameters()));
                        this.pushTerm(term5);
                        return;
                    }
                    case "bvxor": {
                        Term term6 = BitvectorUtils.unfTerm(this.mBvScript, "bvsub", null, BitvectorUtils.unfTerm(this.mBvScript, "bvsub", null, BitvectorUtils.unfTerm(this.mBvScript, "bvadd", null, applicationTerm.getParameters()), BitvectorUtils.unfTerm(this.mBvScript, "bvand", null, applicationTerm.getParameters())), BitvectorUtils.unfTerm(this.mBvScript, "bvand", null, applicationTerm.getParameters()));
                        this.pushTerm(term6);
                        return;
                    }
                    case "bvashr": {
                        this.pushTerm(this.bvashrAbbreviation(applicationTerm));
                        return;
                    }
                    case "sign_extend": {
                        this.pushTerm(this.signextendAbbreviation(applicationTerm));
                        return;
                    }
                    case "bvsrem": {
                        this.pushTerm(this.bvsremAbbreviation(applicationTerm));
                        return;
                    }
                    case "bvsdiv": {
                        this.pushTerm(this.bvsdivAbbreviation(applicationTerm));
                        return;
                    }
                    case "bvxnor": {
                        this.pushTerm(this.bvxnorAbbreviation(applicationTerm));
                        return;
                    }
                    case "bvnand": {
                        this.pushTerm(this.bvnandAbbreviation(applicationTerm));
                        return;
                    }
                    case "bvsmod": {
                        this.pushTerm(this.bvsmodAbbreviation(applicationTerm));
                        return;
                    }
                }
                break block45;
            }
            if (term instanceof ConstantTerm) {
                BigInteger bigInteger;
                String string;
                if (!SmtSortUtils.isBitvecSort(term.getSort())) throw new UnsupportedOperationException("unexpected constant sort");
                ConstantTerm constantTerm = (ConstantTerm)term;
                assert (this.isBitVecSort(constantTerm.getSort()));
                if (constantTerm.getValue() instanceof String) {
                    string = (String)constantTerm.getValue();
                    if (string.startsWith("#b")) {
                        string = (String)constantTerm.getValue();
                        bigInteger = new BigInteger(string.substring(2), 2);
                    } else {
                        if (!string.startsWith("#x")) throw new UnsupportedOperationException("Unexpected constant type");
                        bigInteger = new BigInteger(string.substring(2), 16);
                    }
                } else {
                    bigInteger = (BigInteger)constantTerm.getValue();
                }
                string = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE), sort);
                this.setResult((Term)string);
                return;
            }
        }
        super.convert(term);
    }

    private Term bvashrAbbreviation(ApplicationTerm applicationTerm) {
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term term = SmtUtils.rational2Term(this.mBvScript, Rational.ZERO, SmtSortUtils.getBitvectorSort(this.mBvScript, 1));
        Term term2 = BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]);
        Term term3 = SmtUtils.binaryEquality(this.mBvScript, term2, term);
        Term term4 = BitvectorUtils.unfTerm(this.mBvScript, "bvlshr", null, applicationTerm.getParameters());
        Term term5 = BitvectorUtils.unfTerm(this.mBvScript, "bvnot", null, BitvectorUtils.unfTerm(this.mBvScript, "bvlshr", null, BitvectorUtils.unfTerm(this.mBvScript, "bvnot", null, applicationTerm.getParameters()[0]), applicationTerm.getParameters()[1]));
        Term term6 = SmtUtils.ite(this.mBvScript, term3, term4, term5);
        return term6;
    }

    private Term bvxnorAbbreviation(ApplicationTerm applicationTerm) {
        Term term = BitvectorUtils.unfTerm(this.mBvScript, "bvor", null, BitvectorUtils.unfTerm(this.mBvScript, "bvor", null, BitvectorUtils.unfTerm(this.mBvScript, "bvand", null, applicationTerm.getParameters()), BitvectorUtils.unfTerm(this.mBvScript, "bvand", null, BitvectorUtils.unfTerm(this.mBvScript, "bvnot", null, applicationTerm.getParameters()[0]), BitvectorUtils.unfTerm(this.mBvScript, "bvnot", null, applicationTerm.getParameters()[1]))));
        return term;
    }

    private Term bvnandAbbreviation(ApplicationTerm applicationTerm) {
        Term term = BitvectorUtils.unfTerm(this.mBvScript, "bvnot", null, BitvectorUtils.unfTerm(this.mBvScript, "bvand", null, applicationTerm.getParameters()));
        return term;
    }

    private Term bvcompAbbreviation(ApplicationTerm applicationTerm) {
        Term term;
        int n = Integer.valueOf(applicationTerm.getSort().getIndices()[0]);
        if (n == 1) {
            Term term2;
            term = term2 = BitvectorUtils.unfTerm(this.mBvScript, "bvxnor", null, applicationTerm.getParameters());
        } else {
            Term term3;
            BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
            Term term4 = BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]);
            Term term5 = BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[1]);
            BigInteger[] bigIntegerArray2 = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 2), BigInteger.ZERO};
            Term term6 = BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]);
            Term term7 = BitvectorUtils.unfTerm(this.mBvScript, "bvxnor", null, term4, term5);
            Term term8 = BitvectorUtils.unfTerm(this.mBvScript, "bvcomp", null, term6);
            term = term3 = BitvectorUtils.unfTerm(this.mBvScript, "bvxnor", null, term7, term8);
        }
        return term;
    }

    private Term bvsmodAbbreviation(ApplicationTerm applicationTerm) {
        Term term;
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term term2 = BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]);
        Term term3 = BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[1]);
        Term term4 = SmtUtils.rational2Term(this.mBvScript, Rational.ZERO, SmtSortUtils.getBitvectorSort(this.mBvScript, 1));
        Term term5 = SmtUtils.rational2Term(this.mBvScript, Rational.ONE, SmtSortUtils.getBitvectorSort(this.mBvScript, 1));
        Term term6 = SmtUtils.equality(this.mBvScript, term4, term2);
        Term term7 = SmtUtils.equality(this.mBvScript, term4, term3);
        Term term8 = SmtUtils.equality(this.mBvScript, term5, term2);
        Term term9 = SmtUtils.equality(this.mBvScript, term5, term3);
        Term term10 = SmtUtils.ite(this.mBvScript, term6, applicationTerm.getParameters()[0], BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, applicationTerm.getParameters()[0]));
        Term term11 = SmtUtils.ite(this.mBvScript, term7, applicationTerm.getParameters()[1], BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, applicationTerm.getParameters()[1]));
        Term term12 = BitvectorUtils.unfTerm(this.mBvScript, "bvurem", null, term10, term11);
        int n = Integer.valueOf(applicationTerm.getSort().getIndices()[0]);
        Term term13 = SmtUtils.rational2Term(this.mBvScript, Rational.ZERO, SmtSortUtils.getBitvectorSort(this.mBvScript, n));
        Term term14 = SmtUtils.equality(this.mBvScript, term12, term13);
        Term term15 = SmtUtils.and(this.mBvScript, term6, term7);
        Term term16 = SmtUtils.and(this.mBvScript, term8, term7);
        Term term17 = SmtUtils.and(this.mBvScript, term6, term9);
        Term term18 = BitvectorUtils.unfTerm(this.mBvScript, "bvadd", null, BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, term12), applicationTerm.getParameters()[1]);
        Term term19 = BitvectorUtils.unfTerm(this.mBvScript, "bvadd", null, applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]);
        Term term20 = BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, term12);
        Term term21 = SmtUtils.ite(this.mBvScript, term17, term19, term20);
        Term term22 = SmtUtils.ite(this.mBvScript, term16, term18, term21);
        Term term23 = SmtUtils.ite(this.mBvScript, term15, term12, term22);
        Term term24 = term = SmtUtils.ite(this.mBvScript, term14, term12, term23);
        return term24;
    }

    private Term rotateLeftAbbreviation(ApplicationTerm applicationTerm) {
        Term term;
        int n = Integer.valueOf(applicationTerm.getSort().getIndices()[0]);
        if (n == 1) {
            term = applicationTerm.getParameters()[0];
        } else {
            BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 2), BigInteger.ZERO};
            BigInteger[] bigIntegerArray2 = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
            BigInteger[] bigIntegerArray3 = new BigInteger[]{BigInteger.valueOf(n - 1)};
            term = BitvectorUtils.unfTerm(this.mBvScript, "rotate_left", bigIntegerArray3, BitvectorUtils.unfTerm(this.mBvScript, "concat", null, BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]), BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray2, applicationTerm.getParameters()[0])));
        }
        return term;
    }

    private Term rotateRightAbbreviation(ApplicationTerm applicationTerm) {
        Term term;
        int n = Integer.valueOf(applicationTerm.getSort().getIndices()[0]);
        if (n == 1) {
            term = applicationTerm.getParameters()[0];
        } else {
            BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO};
            BigInteger[] bigIntegerArray2 = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.ONE};
            BigInteger[] bigIntegerArray3 = new BigInteger[]{BigInteger.valueOf(n - 1)};
            term = BitvectorUtils.unfTerm(this.mBvScript, "rotate_right", bigIntegerArray3, BitvectorUtils.unfTerm(this.mBvScript, "concat", null, BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]), BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray2, applicationTerm.getParameters()[0])));
        }
        return term;
    }

    private Term signextendAbbreviation(ApplicationTerm applicationTerm) {
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term term = applicationTerm.getParameters()[0];
        int n = Integer.valueOf(applicationTerm.getSort().getIndices()[0]) - Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]);
        int n2 = 0;
        while (n2 < n) {
            term = BitvectorUtils.unfTerm(this.mBvScript, "concat", null, BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]), term);
            ++n2;
        }
        return term;
    }

    private Term bvsremAbbreviation(ApplicationTerm applicationTerm) {
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term term = BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]);
        Term term2 = BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[1]);
        Term term3 = SmtUtils.rational2Term(this.mBvScript, Rational.ZERO, SmtSortUtils.getBitvectorSort(this.mBvScript, 1));
        Term term4 = SmtUtils.rational2Term(this.mBvScript, Rational.ONE, SmtSortUtils.getBitvectorSort(this.mBvScript, 1));
        Term term5 = SmtUtils.and(this.mBvScript, SmtUtils.equality(this.mBvScript, term3, term), SmtUtils.equality(this.mBvScript, term3, term2));
        Term term6 = SmtUtils.and(this.mBvScript, SmtUtils.equality(this.mBvScript, term4, term), SmtUtils.equality(this.mBvScript, term3, term2));
        Term term7 = SmtUtils.and(this.mBvScript, SmtUtils.equality(this.mBvScript, term3, term), SmtUtils.equality(this.mBvScript, term4, term2));
        Term term8 = BitvectorUtils.unfTerm(this.mBvScript, "bvurem", null, applicationTerm.getParameters());
        Term term9 = BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, BitvectorUtils.unfTerm(this.mBvScript, "bvurem", null, BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, applicationTerm.getParameters()[0]), applicationTerm.getParameters()[1]));
        Term term10 = BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, BitvectorUtils.unfTerm(this.mBvScript, "bvurem", null, applicationTerm.getParameters()[0], BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, applicationTerm.getParameters()[1])));
        Term term11 = BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, BitvectorUtils.unfTerm(this.mBvScript, "bvurem", null, BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, applicationTerm.getParameters()[0]), BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, applicationTerm.getParameters()[1])));
        Term term12 = SmtUtils.ite(this.mBvScript, term7, term10, term11);
        Term term13 = SmtUtils.ite(this.mBvScript, term6, term9, term12);
        Term term14 = SmtUtils.ite(this.mBvScript, term5, term8, term13);
        return term14;
    }

    private Term bvsdivAbbreviation(ApplicationTerm applicationTerm) {
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term term = BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]);
        Term term2 = BitvectorUtils.unfTerm(this.mBvScript, "extract", bigIntegerArray, applicationTerm.getParameters()[1]);
        Term term3 = SmtUtils.rational2Term(this.mBvScript, Rational.ZERO, SmtSortUtils.getBitvectorSort(this.mBvScript, 1));
        Term term4 = SmtUtils.rational2Term(this.mBvScript, Rational.ONE, SmtSortUtils.getBitvectorSort(this.mBvScript, 1));
        Term term5 = SmtUtils.and(this.mBvScript, SmtUtils.equality(this.mBvScript, term3, term), SmtUtils.equality(this.mBvScript, term3, term2));
        Term term6 = SmtUtils.and(this.mBvScript, SmtUtils.equality(this.mBvScript, term4, term), SmtUtils.equality(this.mBvScript, term3, term2));
        Term term7 = SmtUtils.and(this.mBvScript, SmtUtils.equality(this.mBvScript, term3, term), SmtUtils.equality(this.mBvScript, term4, term2));
        Term term8 = BitvectorUtils.unfTerm(this.mBvScript, "bvudiv", null, applicationTerm.getParameters());
        Term term9 = BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, BitvectorUtils.unfTerm(this.mBvScript, "bvudiv", null, BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, applicationTerm.getParameters()[0]), applicationTerm.getParameters()[1]));
        Term term10 = BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, BitvectorUtils.unfTerm(this.mBvScript, "bvudiv", null, applicationTerm.getParameters()[0], BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, applicationTerm.getParameters()[1])));
        Term term11 = BitvectorUtils.unfTerm(this.mBvScript, "bvudiv", null, BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, applicationTerm.getParameters()[0]), BitvectorUtils.unfTerm(this.mBvScript, "bvneg", null, applicationTerm.getParameters()[1]));
        Term term12 = SmtUtils.ite(this.mBvScript, term7, term10, term11);
        Term term13 = SmtUtils.ite(this.mBvScript, term6, term9, term12);
        Term term14 = SmtUtils.ite(this.mBvScript, term5, term8, term13);
        return term14;
    }

    private Sort translateArraySort(Sort sort) {
        return IntBlastingWrapper.translateSort(this.mMgdScript.getScript(), sort);
    }

    private Term translateVars(Term term, boolean bl) {
        TermVariable termVariable;
        if (term instanceof TermVariable) {
            String string = ((TermVariable)term).getName();
            termVariable = SmtSortUtils.isBitvecSort(term.getSort()) ? this.mScript.variable(string, SmtSortUtils.getIntSort(this.mMgdScript)) : this.mScript.variable(string, IntBlastingWrapper.translateSort(this.mScript, term.getSort()));
        } else if (term instanceof ApplicationTerm) {
            String string = ((ApplicationTerm)term).getFunction().getName();
            if (((ApplicationTerm)term).getParameters().length > 0) {
                throw new AssertionError((Object)"We support only constant symbols, not general function symbols");
            }
            termVariable = this.mScript.term(string, new Term[0]);
        } else {
            throw new AssertionError((Object)"Unsupported term");
        }
        this.mVariableMap.put(term, (Term)termVariable);
        this.mReversedVarMap.put((Term)termVariable, term);
        return termVariable;
    }

    @Override
    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        if (term != quantifiedFormula.getSubformula()) {
            int n = 0;
            while (n < quantifiedFormula.getVariables().length) {
                if (SmtSortUtils.isBitvecSort(quantifiedFormula.getVariables()[n].getSort())) {
                    var6_6 = this.mScript.variable(quantifiedFormula.getVariables()[n].getName(), SmtSortUtils.getIntSort(this.mMgdScript));
                    hashSet.add(var6_6);
                    if (!this.mNutzTransformation) {
                        hashSet2.add(this.mTc.getTvConstraint(quantifiedFormula.getVariables()[n], (Term)var6_6));
                    }
                } else if (SmtSortUtils.isArraySort(quantifiedFormula.getVariables()[n].getSort())) {
                    var6_6 = this.mVariableMap.get(quantifiedFormula.getVariables()[n]);
                    assert (this.mVariableMap.get(quantifiedFormula.getVariables()[n]) != null);
                    hashSet.add(var6_6);
                    Term term2 = this.mArrayConstraintMap.get(var6_6);
                    if (term2 != null) {
                        hashSet2.add(term2);
                    }
                    this.mArrayConstraintMap.remove(var6_6);
                } else {
                    var6_6 = this.mScript.variable(quantifiedFormula.getVariables()[n].getName(), IntBlastingWrapper.translateSort(this.mScript, quantifiedFormula.getVariables()[n].getSort()));
                    hashSet.add(var6_6);
                }
                ++n;
            }
            this.setResult(SmtUtils.quantifier(this.mScript, quantifiedFormula.getQuantifier(), hashSet, QuantifierUtils.applyDualFiniteConnective(this.mScript, quantifiedFormula.getQuantifier(), term, QuantifierUtils.negateIfUniversal(this.mScript, quantifiedFormula.getQuantifier(), SmtUtils.and(this.mScript, hashSet2)))));
        } else {
            super.postConvertQuantifier(quantifiedFormula, term);
        }
    }

    private boolean overaproxWithVars(ApplicationTerm applicationTerm) {
        block17: {
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            if (!functionSymbol.isIntern()) break block17;
            switch (functionSymbol.getName()) {
                case "bvashr": 
                case "bvlshr": 
                case "bvor": 
                case "bvand": 
                case "bvshl": 
                case "bvxor": {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void convertApplicationTerm(ApplicationTerm var1_1, Term[] var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[26] lbl207 : CaseStatement: default:\u000a, @NONE, blocks:[26] lbl207 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void postConvertLet(LetTerm letTerm, Term[] termArray, Term term) {
        throw new UnsupportedOperationException("Let terms are not yet supported.");
    }

    private Term translateExtract(ApplicationTerm applicationTerm, Term term) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        BigInteger bigInteger = BigInteger.valueOf(2L);
        int n = Integer.parseInt(applicationTerm.getFunction().getIndices()[1]);
        int n2 = Integer.parseInt(applicationTerm.getFunction().getIndices()[0]);
        Term term2 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)bigInteger.pow(n), (BigInteger)BigInteger.ONE), sort);
        Term term3 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)bigInteger.pow(n2 - n + 1), (BigInteger)BigInteger.ONE), sort);
        ++this.moduloCount;
        return SmtUtils.mod(this.mScript, SmtUtils.unfTerm(this.mScript, "div", null, SmtSortUtils.getIntSort(this.mMgdScript), term, term2), term3);
    }

    private Term translateBvudiv(Term term, Term term2, Term term3) {
        Term term4;
        Term term5;
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        if (this.mNutzTransformation) {
            this.moduloCount += 2;
            term5 = SmtUtils.mod(this.mScript, term2, term3);
            term4 = SmtUtils.mod(this.mScript, term, term3);
        } else {
            term5 = term2;
            term4 = term;
        }
        Term term6 = SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), term5, SmtUtils.rational2Term(this.mScript, Rational.ZERO, sort));
        Term term7 = SmtUtils.unfTerm(this.mScript, "-", null, SmtSortUtils.getIntSort(this.mMgdScript), term3, SmtUtils.rational2Term(this.mScript, Rational.ONE, sort));
        Term term8 = SmtUtils.unfTerm(this.mScript, "div", null, SmtSortUtils.getIntSort(this.mMgdScript), term4, term5);
        return SmtUtils.ite(this.mScript, term6, term7, term8);
    }

    private Term translateBvurem(Term term, Term term2, Term term3) {
        Term term4;
        Term term5;
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        if (this.mNutzTransformation) {
            this.moduloCount += 2;
            term5 = SmtUtils.mod(this.mScript, term2, term3);
            term4 = SmtUtils.mod(this.mScript, term, term3);
        } else {
            term5 = term2;
            term4 = term;
        }
        Term term6 = SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), term5, SmtUtils.rational2Term(this.mScript, Rational.ZERO, sort));
        Term term7 = term;
        Term term8 = SmtUtils.mod(this.mScript, term4, term5);
        ++this.moduloCount;
        return SmtUtils.ite(this.mScript, term6, term7, term8);
    }

    private Term translateBvshl(Term term, Term term2, int n, Term term3) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        if (this.mNutzTransformation) {
            this.moduloCount += 2;
            term2 = SmtUtils.mod(this.mScript, term2, term3);
            term = SmtUtils.mod(this.mScript, term, term3);
        }
        if (term2 instanceof ConstantTerm) {
            Term term4 = SmtUtils.unfTerm(this.mScript, "*", null, SmtSortUtils.getIntSort(this.mMgdScript), term, this.pow2(term2));
            ++this.moduloCount;
            return SmtUtils.mod(this.mScript, term4, term3);
        }
        Term term5 = SmtUtils.rational2Term(this.mScript, Rational.ZERO, sort);
        int n2 = n - 1;
        while (n2 >= 0) {
            if (n2 == 0) {
                var8_9 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((long)0L, (long)1L), sort);
                term5 = SmtUtils.ite(this.mScript, SmtUtils.binaryEquality(this.mScript, (Term)var8_9, term2), term, term5);
            } else {
                Term term6;
                var8_9 = Rational.valueOf((long)n2, (long)1L);
                Term term7 = SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), term2, SmtUtils.rational2Term(this.mScript, var8_9, sort));
                BigInteger bigInteger = BigInteger.valueOf(2L).pow(n2);
                if (this.mNutzTransformation) {
                    term6 = SmtUtils.unfTerm(this.mScript, "*", null, SmtSortUtils.getIntSort(this.mMgdScript), SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE), sort), term);
                } else {
                    ++this.moduloCount;
                    term6 = SmtUtils.mod(this.mScript, SmtUtils.unfTerm(this.mScript, "*", null, SmtSortUtils.getIntSort(this.mMgdScript), SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE), sort), term), term3);
                }
                term5 = SmtUtils.ite(this.mScript, term7, term6, term5);
            }
            --n2;
        }
        ++this.moduloCount;
        return term5;
    }

    private Term translateBvlshr(Term term, Term term2, int n, Term term3) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        if (this.mNutzTransformation) {
            ++this.moduloCount;
            term2 = SmtUtils.mod(this.mScript, term2, term3);
            term = SmtUtils.mod(this.mScript, term, term3);
        }
        if (term2 instanceof ConstantTerm) {
            Term term4 = SmtUtils.unfTerm(this.mScript, "div", null, SmtSortUtils.getIntSort(this.mMgdScript), term, this.pow2(term2));
            return term4;
        }
        Term term5 = SmtUtils.rational2Term(this.mScript, Rational.ZERO, sort);
        int n2 = n - 1;
        while (n2 >= 0) {
            if (n2 == 0) {
                var8_9 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((long)0L, (long)1L), sort);
                term5 = SmtUtils.ite(this.mScript, SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), new Term[]{var8_9, term2}), term, term5);
            } else {
                var8_9 = Rational.valueOf((long)n2, (long)1L);
                Term term6 = SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), term2, SmtUtils.rational2Term(this.mScript, var8_9, sort));
                BigInteger bigInteger = BigInteger.valueOf(2L).pow(n2);
                Term term7 = SmtUtils.unfTerm(this.mScript, "div", null, SmtSortUtils.getIntSort(this.mMgdScript), term, SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE), sort));
                term5 = SmtUtils.ite(this.mScript, term6, term7, term5);
            }
            --n2;
        }
        ++this.moduloCount;
        return term5;
    }

    private Term translateRelations(ApplicationTerm applicationTerm, FunctionSymbol functionSymbol, Term[] termArray, Term term, int n) {
        block52: {
            Term[] termArray2 = new Term[termArray.length];
            Term[] termArray3 = termArray;
            termArray2 = termArray;
            if (this.mNutzTransformation && SmtSortUtils.isNumericSort(termArray[0].getSort())) {
                this.moduloCount += 2;
            }
            if (!functionSymbol.isIntern()) break block52;
            switch (functionSymbol.getName()) {
                case "=": {
                    if (this.mNutzTransformation && SmtSortUtils.isNumericSort(termArray[0].getSort())) {
                        int n2 = 0;
                        while (n2 < termArray.length) {
                            termArray2[n2] = SmtUtils.mod(this.mScript, termArray[n2], term);
                            ++n2;
                        }
                    }
                    if (this.mNutzTransformation && SmtSortUtils.isArraySort(applicationTerm.getParameters()[0].getSort()) && SmtSortUtils.isBitvecSort(applicationTerm.getParameters()[0].getSort().getArguments()[1])) {
                        TermVariable termVariable = this.mNewScript.variable("AuxVar", SmtSortUtils.getIntSort((Script)this.mNewScript));
                        Term term2 = SmtUtils.and((Script)this.mNewScript, SmtUtils.leq((Script)this.mNewScript, SmtUtils.rational2Term((Script)this.mNewScript, Rational.ZERO, SmtSortUtils.getIntSort((Script)this.mNewScript)), (Term)termVariable), SmtUtils.leq((Script)this.mNewScript, (Term)termVariable, term));
                        Term term3 = SmtUtils.equality((Script)this.mNewScript, SmtUtils.select((Script)this.mNewScript, termArray[0], (Term)termVariable), SmtUtils.select((Script)this.mNewScript, termArray[1], (Term)termVariable));
                        Term term4 = SmtUtils.implies((Script)this.mNewScript, term2, term3);
                        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
                        hashSet.add(termVariable);
                        Term term5 = SmtUtils.quantifier((Script)this.mNewScript, 1, hashSet, term4);
                        Term term6 = SmtUtils.implies((Script)this.mNewScript, term5, SmtUtils.equality((Script)this.mNewScript, termArray));
                        this.mArrayConstraintMap.put((Term)applicationTerm, term6);
                    }
                    return SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), termArray2);
                }
                case "distinct": {
                    if (this.mNutzTransformation && SmtSortUtils.isNumericSort(termArray[0].getSort())) {
                        int n3 = 0;
                        while (n3 < termArray.length) {
                            termArray2[n3] = SmtUtils.mod(this.mScript, termArray[n3], term);
                            ++n3;
                        }
                    }
                    return SmtUtils.unfTerm(this.mScript, "distinct", null, SmtSortUtils.getIntSort(this.mMgdScript), termArray2);
                }
                case "bvult": {
                    if (this.mNutzTransformation) {
                        int n4 = 0;
                        while (n4 < termArray.length) {
                            termArray2[n4] = SmtUtils.mod(this.mScript, termArray[n4], term);
                            ++n4;
                        }
                    }
                    return SmtUtils.less(this.mScript, termArray2[0], termArray2[1]);
                }
                case "bvule": {
                    if (this.mNutzTransformation) {
                        int n5 = 0;
                        while (n5 < termArray.length) {
                            termArray2[n5] = SmtUtils.mod(this.mScript, termArray[n5], term);
                            ++n5;
                        }
                    }
                    return SmtUtils.leq(this.mScript, termArray2[0], termArray2[1]);
                }
                case "bvugt": {
                    if (this.mNutzTransformation) {
                        int n6 = 0;
                        while (n6 < termArray.length) {
                            termArray2[n6] = SmtUtils.mod(this.mScript, termArray[n6], term);
                            ++n6;
                        }
                    }
                    return SmtUtils.greater(this.mScript, termArray2[0], termArray2[1]);
                }
                case "bvuge": {
                    if (this.mNutzTransformation) {
                        int n7 = 0;
                        while (n7 < termArray.length) {
                            termArray2[n7] = SmtUtils.mod(this.mScript, termArray[n7], term);
                            ++n7;
                        }
                    }
                    return SmtUtils.geq(this.mScript, termArray2[0], termArray2[1]);
                }
                case "bvslt": {
                    int n8 = 0;
                    while (n8 < termArray.length) {
                        termArray3[n8] = this.uts(n, termArray[n8], this.mNutzTransformation);
                        ++n8;
                    }
                    return SmtUtils.less(this.mScript, termArray3[0], termArray3[1]);
                }
                case "bvsle": {
                    int n9 = 0;
                    while (n9 < termArray.length) {
                        termArray3[n9] = this.uts(n, termArray[n9], this.mNutzTransformation);
                        ++n9;
                    }
                    return SmtUtils.leq(this.mScript, termArray3[0], termArray3[1]);
                }
                case "bvsgt": {
                    int n10 = 0;
                    while (n10 < termArray.length) {
                        termArray3[n10] = this.uts(n, termArray[n10], this.mNutzTransformation);
                        ++n10;
                    }
                    return SmtUtils.greater(this.mScript, termArray3[0], termArray3[1]);
                }
                case "bvsge": {
                    int n11 = 0;
                    while (n11 < termArray.length) {
                        termArray3[n11] = this.uts(n, termArray[n11], this.mNutzTransformation);
                        ++n11;
                    }
                    return SmtUtils.geq(this.mScript, termArray3[0], termArray3[1]);
                }
            }
        }
        throw new UnsupportedOperationException("unexpected relation");
    }

    private final Term uts(int n, Term term, boolean bl) {
        ++this.utsCount;
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        Term term2 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L), (BigInteger)BigInteger.ONE), sort);
        Term term3 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(n - 1), (BigInteger)BigInteger.ONE), sort);
        if (bl) {
            Term term4 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(n), (BigInteger)BigInteger.ONE), sort);
            Term term5 = SmtUtils.mod(this.mScript, SmtUtils.mod(this.mScript, term, term4), term3);
            return SmtUtils.unfTerm(this.mScript, "-", null, SmtSortUtils.getIntSort(this.mMgdScript), SmtUtils.unfTerm(this.mScript, "*", null, SmtSortUtils.getIntSort(this.mMgdScript), term2, term5), SmtUtils.mod(this.mScript, term, term4));
        }
        Term term6 = SmtUtils.mod(this.mScript, term, term3);
        return SmtUtils.unfTerm(this.mScript, "-", null, SmtSortUtils.getIntSort(this.mMgdScript), SmtUtils.unfTerm(this.mScript, "*", null, SmtSortUtils.getIntSort(this.mMgdScript), term2, term6), term);
    }

    private Term pow2(Term term) {
        assert (term.getSort().isNumericSort());
        if (term instanceof ConstantTerm) {
            Term term2;
            Sort sort = SmtSortUtils.getIntSort(this.mScript);
            ConstantTerm constantTerm = (ConstantTerm)term;
            if (constantTerm.getValue() instanceof Rational) {
                Rational rational = (Rational)constantTerm.getValue();
                term2 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(rational.numerator().intValueExact()), (BigInteger)BigInteger.ONE), sort);
            } else {
                BigInteger bigInteger = (BigInteger)constantTerm.getValue();
                term2 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(bigInteger.intValueExact()), (BigInteger)BigInteger.ONE), sort);
            }
            return term2;
        }
        throw new UnsupportedOperationException("function pow2 not implemented");
    }

    private boolean isBitVecSort(Sort sort) {
        return sort.getName().equals("BitVec");
    }

    public LinkedHashMap<Term, Term> getVarMap() {
        return this.mVariableMap;
    }

    public LinkedHashMap<Term, Term> getReversedVarMap() {
        return this.mReversedVarMap;
    }

    public Set<Term> getOverapproxVariables() {
        return this.mOverapproxVariables;
    }

    public boolean wasOverapproximation() {
        return this.mIsOverapproximation;
    }
}

