/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.StateDeterminizerCache;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DeterminizedState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DifferenceSadd;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DifferenceState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IOpWithDelayedDeadEndRemoval;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa.Senwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa.SenwaWalker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISenwaStateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class DifferenceSenwa<LETTER, STATE>
extends BinaryNwaOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>>
implements SenwaWalker.ISuccessorVisitor<LETTER, STATE>,
IOpWithDelayedDeadEndRemoval<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mMinuend;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSubtrahend;
    private final IStateDeterminizer<LETTER, STATE> mStateDeterminizer;
    private final ISenwaStateFactory<STATE> mContentFactorySenwa;
    private final IIntersectionStateFactory<STATE> mContentFactoryIntersection;
    private final Senwa<LETTER, STATE> mSenwa;
    private final SenwaWalker<LETTER, STATE> mSenwaWalker;
    private final Map<STATE, DifferenceState<LETTER, STATE>> mResult2Operand = new HashMap<STATE, DifferenceState<LETTER, STATE>>();
    private final Map<DifferenceState<LETTER, STATE>, Map<DifferenceState<LETTER, STATE>, STATE>> mEntry2Operand2Result = new HashMap<DifferenceState<LETTER, STATE>, Map<DifferenceState<LETTER, STATE>, STATE>>();

    public <SF extends ISenwaStateFactory<STATE> & IDeterminizeStateFactory<STATE>> DifferenceSenwa(AutomataLibraryServices automataLibraryServices, SF SF, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        this(automataLibraryServices, SF, iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider, new PowersetDeterminizer<LETTER, STATE>(iNwaOutgoingLetterAndTransitionProvider, true, SF), true);
    }

    public <SF extends ISenwaStateFactory<STATE> & IIntersectionStateFactory<STATE>> DifferenceSenwa(AutomataLibraryServices automataLibraryServices, SF SF, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IStateDeterminizer<LETTER, STATE> iStateDeterminizer, boolean bl) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mContentFactorySenwa = SF;
        this.mContentFactoryIntersection = SF;
        this.mMinuend = iNestedWordAutomaton;
        this.mSubtrahend = iNwaOutgoingLetterAndTransitionProvider;
        this.mLogger.info((Object)this.startMessage());
        this.mStateDeterminizer = new StateDeterminizerCache<LETTER, STATE>(iStateDeterminizer);
        this.mSenwa = new Senwa(this.mServices, iNestedWordAutomaton.getVpAlphabet(), SF);
        this.mSenwaWalker = new SenwaWalker<LETTER, STATE>(this.mServices, this.mSenwa, this, bl);
        this.mLogger.info((Object)this.exitMessage());
    }

    private STATE getOrConstructResultState(DifferenceState<LETTER, STATE> differenceState, DifferenceState<LETTER, STATE> differenceState2, boolean bl) {
        STATE STATE;
        assert (this.mMinuend.getStates().contains(differenceState2.getMinuendState()));
        assert (this.mMinuend.getStates().contains(differenceState.getMinuendState()));
        Map<DifferenceState<LETTER, STATE>, STATE> map = this.mEntry2Operand2Result.get(differenceState);
        if (map == null) {
            map = new HashMap<DifferenceState<LETTER, STATE>, STATE>();
            this.mEntry2Operand2Result.put(differenceState, map);
        }
        if ((STATE = map.get(differenceState2)) == null) {
            STATE = this.mContentFactorySenwa.senwa(differenceState.getState(this.mContentFactoryIntersection, this.mStateDeterminizer), differenceState2.getState(this.mContentFactoryIntersection, this.mStateDeterminizer));
            map.put(differenceState2, STATE);
            this.mResult2Operand.put(STATE, differenceState2);
            STATE STATE2 = map.get(differenceState);
            assert (STATE2 != null);
            this.mSenwa.addState(STATE, bl, differenceState2.isFinal(), STATE2);
        }
        return STATE;
    }

    private DifferenceState<LETTER, STATE> getOperandState(STATE STATE) {
        assert (this.mSenwa.getStates().contains(STATE));
        DifferenceState<LETTER, STATE> differenceState = this.mResult2Operand.get(STATE);
        assert (differenceState != null);
        return differenceState;
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        ArrayList arrayList = new ArrayList();
        DeterminizedState<LETTER, STATE> determinizedState = this.mStateDeterminizer.initialState();
        for (Object e : this.mMinuend.getInitialStates()) {
            boolean bl = this.mMinuend.isFinal(e) && !determinizedState.containsFinal();
            DifferenceState differenceState = new DifferenceState(e, determinizedState, bl);
            Object e2 = this.getOrConstructResultState(differenceState, differenceState, true);
            arrayList.add(e2);
        }
        return arrayList;
    }

    @Override
    public Iterable<STATE> visitAndGetInternalSuccessors(STATE STATE) {
        STATE STATE2 = this.mSenwa.getEntry(STATE);
        DifferenceState<LETTER, STATE> differenceState = this.getOperandState(STATE2);
        HashSet<STATE> hashSet = new HashSet<STATE>();
        DifferenceState<LETTER, STATE> differenceState2 = this.getOperandState(STATE);
        STATE STATE3 = differenceState2.getMinuendState();
        DeterminizedState<LETTER, STATE> determinizedState = differenceState2.getSubtrahendDeterminizedState();
        for (Object LETTER : this.mMinuend.lettersInternal(STATE3)) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mMinuend.internalSuccessors(STATE3, LETTER)) {
                STATE STATE4 = outgoingInternalTransition.getSucc();
                DeterminizedState<LETTER, STATE> determinizedState2 = this.mStateDeterminizer.internalSuccessor(determinizedState, LETTER);
                boolean bl = this.mMinuend.isFinal(STATE4) && !determinizedState2.containsFinal();
                DifferenceState<LETTER, STATE> differenceState3 = new DifferenceState<LETTER, STATE>(STATE4, determinizedState2, bl);
                STATE STATE5 = this.getOrConstructResultState(differenceState, differenceState3, false);
                hashSet.add(STATE5);
                this.mSenwa.addInternalTransition(STATE, LETTER, STATE5);
            }
        }
        return hashSet;
    }

    @Override
    public Iterable<STATE> visitAndGetCallSuccessors(STATE STATE) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        DifferenceState<LETTER, STATE> differenceState = this.getOperandState(STATE);
        STATE STATE2 = differenceState.getMinuendState();
        DeterminizedState<LETTER, STATE> determinizedState = differenceState.getSubtrahendDeterminizedState();
        for (Object LETTER : this.mMinuend.lettersCall(STATE2)) {
            for (OutgoingCallTransition outgoingCallTransition : this.mMinuend.callSuccessors(STATE2, LETTER)) {
                STATE STATE3 = outgoingCallTransition.getSucc();
                DeterminizedState<LETTER, STATE> determinizedState2 = this.mStateDeterminizer.callSuccessor(determinizedState, LETTER);
                boolean bl = this.mMinuend.isFinal(STATE3) && !determinizedState2.containsFinal();
                DifferenceState<LETTER, STATE> differenceState2 = new DifferenceState<LETTER, STATE>(STATE3, determinizedState2, bl);
                STATE STATE4 = this.getOrConstructResultState(differenceState2, differenceState2, false);
                hashSet.add(STATE4);
                this.mSenwa.addCallTransition(STATE, LETTER, STATE4);
            }
        }
        return hashSet;
    }

    @Override
    public Iterable<STATE> visitAndGetReturnSuccessors(STATE STATE, STATE STATE2) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        DifferenceState<LETTER, STATE> differenceState = this.getOperandState(STATE);
        STATE STATE3 = differenceState.getMinuendState();
        DeterminizedState<LETTER, STATE> determinizedState = differenceState.getSubtrahendDeterminizedState();
        DifferenceState<LETTER, STATE> differenceState2 = this.getOperandState(STATE2);
        STATE STATE4 = differenceState2.getMinuendState();
        DeterminizedState<LETTER, STATE> determinizedState2 = differenceState2.getSubtrahendDeterminizedState();
        STATE STATE5 = this.mSenwa.getEntry(STATE2);
        DifferenceState<LETTER, STATE> differenceState3 = this.getOperandState(STATE5);
        for (OutgoingReturnTransition outgoingReturnTransition : this.mMinuend.returnSuccessorsGivenHier(STATE3, STATE4)) {
            STATE STATE6 = outgoingReturnTransition.getSucc();
            DeterminizedState<LETTER, STATE> determinizedState3 = this.mStateDeterminizer.returnSuccessor(determinizedState, determinizedState2, outgoingReturnTransition.getLetter());
            boolean bl = this.mMinuend.isFinal(STATE6) && !determinizedState3.containsFinal();
            DifferenceState<LETTER, STATE> differenceState4 = new DifferenceState<LETTER, STATE>(STATE6, determinizedState3, bl);
            STATE STATE7 = this.getOrConstructResultState(differenceState3, differenceState4, false);
            hashSet.add(STATE7);
            this.mSenwa.addReturnTransition(STATE, STATE2, outgoingReturnTransition.getLetter(), STATE7);
        }
        return hashSet;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mMinuend;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSubtrahend;
    }

    @Override
    public Senwa<LETTER, STATE> getResult() {
        return this.mSenwa;
    }

    public boolean removeStatesThatCanNotReachFinal(boolean bl) {
        return this.mSenwaWalker.removeStatesThatCanNotReachFinal(bl);
    }

    @Override
    public long getDeadEndRemovalTime() {
        return this.mSenwaWalker.getDeadEndRemovalTime();
    }

    @Override
    public Iterable<IOpWithDelayedDeadEndRemoval.UpDownEntry<STATE>> getRemovedUpDownEntry() {
        return null;
    }

    @Override
    public boolean removeDeadEnds() {
        return false;
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + ". Minuend " + this.mMinuend.sizeInformation() + ". Subtrahend " + this.mSubtrahend.sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + " Result " + this.mSenwa.sizeInformation() + ". Max degree of Nondeterminism is " + this.mStateDeterminizer.getMaxDegreeOfNondeterminism();
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        boolean bl = true;
        if (this.mStateDeterminizer instanceof PowersetDeterminizer) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
            Object object = new DifferenceSadd<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mMinuend, this.mSubtrahend).getResult();
            if (!(bl &= new IsEquivalent<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, object, this.mSenwa).getResult().booleanValue())) {
                AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mMinuend, this.mSubtrahend);
            }
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        } else {
            this.mLogger.warn((Object)"Unable to test correctness if state determinzier is not the PowersetDeterminizer.");
        }
        return bl;
    }
}

