/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.UnaryNetOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBlackWhiteStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class BuchiPetriNet2FiniteAutomaton<LETTER, PLACE>
extends UnaryNetOperation<LETTER, PLACE, IStateFactory<PLACE>> {
    private final IPetriNetTransitionProvider<LETTER, PLACE> mOperand;
    private final NestedWordAutomaton<LETTER, PLACE> mResult;
    private final Predicate<Marking<PLACE>> mIsKnownDeadEnd;
    private final List<Pair<Marking<PLACE>, Boolean>> mWorklist = new LinkedList<Pair<Marking<PLACE>, Boolean>>();
    private final Map<Marking<PLACE>, PLACE> mMarking2NonAcceptingState = new HashMap<Marking<PLACE>, PLACE>();
    private final Map<Marking<PLACE>, PLACE> mMarking2AcceptingState = new HashMap<Marking<PLACE>, PLACE>();
    private final IPetriNet2FiniteAutomatonStateFactory<PLACE> mContentFactory;
    private final IBlackWhiteStateFactory<PLACE> mAcceptingOrNonAcceptingStateFactory;

    public BuchiPetriNet2FiniteAutomaton(AutomataLibraryServices automataLibraryServices, IPetriNet2FiniteAutomatonStateFactory<PLACE> iPetriNet2FiniteAutomatonStateFactory, IBlackWhiteStateFactory<PLACE> iBlackWhiteStateFactory, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider) throws PetriNetNot1SafeException, AutomataOperationCanceledException {
        this(automataLibraryServices, iPetriNet2FiniteAutomatonStateFactory, iBlackWhiteStateFactory, iPetriNetTransitionProvider, null);
    }

    public BuchiPetriNet2FiniteAutomaton(AutomataLibraryServices automataLibraryServices, IPetriNet2FiniteAutomatonStateFactory<PLACE> iPetriNet2FiniteAutomatonStateFactory, IBlackWhiteStateFactory<PLACE> iBlackWhiteStateFactory, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider, Predicate<Marking<PLACE>> predicate) throws PetriNetNot1SafeException, AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iPetriNetTransitionProvider;
        this.mIsKnownDeadEnd = predicate;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mContentFactory = iPetriNet2FiniteAutomatonStateFactory;
        this.mAcceptingOrNonAcceptingStateFactory = iBlackWhiteStateFactory;
        HashSet hashSet = new HashSet(iPetriNetTransitionProvider.getAlphabet());
        VpAlphabet vpAlphabet = new VpAlphabet(hashSet, Collections.emptySet(), Collections.emptySet());
        this.mResult = new NestedWordAutomaton(this.mServices, vpAlphabet, iPetriNet2FiniteAutomatonStateFactory);
        this.getState(new Marking(ImmutableSet.of(iPetriNetTransitionProvider.getInitialPlaces())), true, false);
        while (!this.mWorklist.isEmpty()) {
            Pair<Marking<PLACE>, Boolean> pair = this.mWorklist.remove(0);
            this.constructOutgoingTransitions((Marking)pair.getFirst(), (Boolean)pair.getSecond());
            if (this.mServices.getProgressAwareTimer().continueProcessing()) continue;
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "constructing automaton for Petri net that has " + this.mOperand.sizeInformation() + ". Already constructed " + this.mMarking2NonAcceptingState.size() + " states. Currently " + this.mWorklist.size() + " states in worklist.");
            throw new AutomataOperationCanceledException(runningTaskInfo);
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult.sizeInformation();
    }

    private PLACE getState(Marking<PLACE> marking, boolean bl, boolean bl2) {
        if (this.isKnownDeadEnd(marking)) {
            return null;
        }
        if (bl2) {
            return this.getAcceptingState(marking, bl);
        }
        return this.getNonAcceptingState(marking, bl);
    }

    private PLACE getAcceptingState(Marking<PLACE> marking, boolean bl) {
        if (this.isKnownDeadEnd(marking)) {
            return null;
        }
        PLACE PLACE = this.mMarking2AcceptingState.get(marking);
        if (PLACE == null) {
            PLACE = this.mContentFactory.getContentOnPetriNet2FiniteAutomaton(marking);
            PLACE = this.mAcceptingOrNonAcceptingStateFactory.getWhiteContent(PLACE);
            this.mMarking2AcceptingState.put(marking, PLACE);
            this.mResult.addState(bl, true, PLACE);
            this.mWorklist.add(new Pair(marking, (Object)true));
        }
        return PLACE;
    }

    private PLACE getNonAcceptingState(Marking<PLACE> marking, boolean bl) {
        if (this.isKnownDeadEnd(marking)) {
            return null;
        }
        PLACE PLACE = this.mMarking2NonAcceptingState.get(marking);
        if (PLACE == null) {
            PLACE = this.mContentFactory.getContentOnPetriNet2FiniteAutomaton(marking);
            PLACE = this.mAcceptingOrNonAcceptingStateFactory.getBlackContent(PLACE);
            this.mMarking2NonAcceptingState.put(marking, PLACE);
            this.mResult.addState(bl, false, PLACE);
            this.mWorklist.add(new Pair(marking, (Object)false));
        }
        return PLACE;
    }

    private void constructOutgoingTransitions(Marking<PLACE> marking, boolean bl) throws PetriNetNot1SafeException {
        PLACE PLACE = this.getState(marking, false, bl);
        assert (PLACE != null) : "Dead-end marking should never be on worklist";
        Set<Transition<LETTER, PLACE>> set = this.getOutgoingNetTransitions(marking);
        for (Transition<LETTER, PLACE> transition : set) {
            if (!marking.isTransitionEnabled(transition)) continue;
            Marking<PLACE> marking2 = marking.fireTransition(transition);
            Object STATE = null;
            STATE = transition.getSuccessors().stream().anyMatch(this.mOperand::isAccepting) ? (Object)this.getState(marking2, false, true) : (Object)this.getState(marking2, false, false);
            if (STATE == null) continue;
            this.mResult.addInternalTransition(PLACE, transition.getSymbol(), STATE);
        }
    }

    private Set<Transition<LETTER, PLACE>> getOutgoingNetTransitions(Marking<PLACE> marking) {
        HashSet<Transition<LETTER, PLACE>> hashSet = new HashSet<Transition<LETTER, PLACE>>();
        for (PLACE PLACE : marking) {
            hashSet.addAll(this.mOperand.getSuccessors(PLACE));
        }
        return hashSet;
    }

    private boolean isKnownDeadEnd(Marking<PLACE> marking) {
        if (this.mIsKnownDeadEnd == null) {
            return false;
        }
        return this.mIsKnownDeadEnd.test(marking);
    }

    @Override
    protected IPetriNetTransitionProvider<LETTER, PLACE> getOperand() {
        return this.mOperand;
    }

    @Override
    public INestedWordAutomaton<LETTER, PLACE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<PLACE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

