/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.LexicographicRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.LinearRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LexicographicTemplate
extends RankingTemplate {
    public final int size;
    private static final String s_name_delta = "delta";
    private static final String s_name_function = "rank";
    private final Term[] mdeltas;
    private final AffineFunctionGenerator[] mfgens;

    public LexicographicTemplate(int n) {
        assert (n > 1);
        this.size = n;
        this.mdeltas = new Term[this.size];
        this.mfgens = new AffineFunctionGenerator[this.size];
    }

    @Override
    protected void init() {
        int n = 0;
        while (n < this.size) {
            this.mdeltas[n] = this.newDelta(s_name_delta + n);
            this.mfgens[n] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_function + n);
            ++n;
        }
    }

    @Override
    public String getName() {
        return this.size + "-lex";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.size);
        stringBuilder.append("-lex template:\n   ");
        int n = 0;
        while (n < this.size) {
            stringBuilder.append("delta_" + n + " > 0\n/\\ ");
            ++n;
        }
        n = 0;
        while (n < this.size) {
            stringBuilder.append("f_" + n + "(x) > 0\n/\\ ");
            ++n;
        }
        n = 0;
        while (n < this.size - 1) {
            stringBuilder.append("( f_" + n + "(x') <= f_" + n + "(x)");
            int n2 = n - 1;
            while (n2 >= 0) {
                stringBuilder.append(" \\/ f_" + n2 + "(x') < f_" + n2 + "(x) - delta_" + n2);
                --n2;
            }
            stringBuilder.append(" )\n/\\ ");
            ++n;
        }
        stringBuilder.append("( ");
        n = 0;
        while (n < this.size) {
            stringBuilder.append("f_" + n + "(x') < f_" + n + "(x) - delta_" + n);
            if (n < this.size - 1) {
                stringBuilder.append(" \\/ ");
            }
            ++n;
        }
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    @Override
    public List<List<LinearInequality>> getConstraints(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        LinearInequality linearInequality;
        LinearInequality linearInequality2;
        Serializable serializable;
        this.checkInitialized();
        ArrayList<List<LinearInequality>> arrayList = new ArrayList<List<LinearInequality>>();
        int n = 0;
        while (n < this.size) {
            serializable = this.mfgens[n].generate(map);
            ((LinearInequality)serializable).setStrict(true);
            ((LinearInequality)serializable).mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
            arrayList.add(Collections.singletonList(serializable));
            ++n;
        }
        n = 0;
        while (n < this.size - 1) {
            serializable = new ArrayList();
            linearInequality2 = this.mfgens[n].generate(map);
            linearInequality = this.mfgens[n].generate(map2);
            linearInequality.negate();
            linearInequality2.add(linearInequality);
            linearInequality2.setStrict(false);
            linearInequality2.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
            serializable.add(linearInequality2);
            int n2 = n - 1;
            while (n2 >= 0) {
                linearInequality2 = this.mfgens[n2].generate(map);
                LinearInequality linearInequality3 = this.mfgens[n2].generate(map2);
                linearInequality3.negate();
                linearInequality2.add(linearInequality3);
                AffineTerm affineTerm = new AffineTerm(this.mdeltas[n2], Rational.MONE);
                linearInequality2.add(affineTerm);
                linearInequality2.setStrict(true);
                linearInequality2.mMotzkinCoefficient = n2 == 0 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                serializable.add(linearInequality2);
                --n2;
            }
            arrayList.add((List<LinearInequality>)((Object)serializable));
            ++n;
        }
        ArrayList<LinearInequality> arrayList2 = new ArrayList<LinearInequality>();
        int n3 = 0;
        while (n3 < this.size) {
            linearInequality2 = this.mfgens[n3].generate(map);
            linearInequality = this.mfgens[n3].generate(map2);
            linearInequality.negate();
            linearInequality2.add(linearInequality);
            AffineTerm affineTerm = new AffineTerm(this.mdeltas[n3], Rational.MONE);
            linearInequality2.add(affineTerm);
            linearInequality2.setStrict(true);
            linearInequality2.mMotzkinCoefficient = n3 == 0 || n3 == this.size - 1 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
            arrayList2.add(linearInequality2);
            ++n3;
        }
        arrayList.add(arrayList2);
        return arrayList;
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n = 0;
        while (n < this.size) {
            arrayList.addAll(this.mfgens[n].getCoefficients());
            arrayList.add(this.mdeltas[n]);
            ++n;
        }
        return arrayList;
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> map) throws SMTLIBException {
        RankingFunction[] rankingFunctionArray = new RankingFunction[this.size];
        int n = 0;
        while (n < this.size) {
            AffineFunction affineFunction = this.mfgens[n].extractAffineFunction(map);
            rankingFunctionArray[n] = new LinearRankingFunction(affineFunction);
            ++n;
        }
        return new LexicographicRankingFunction(rankingFunctionArray);
    }

    @Override
    public List<String> getAnnotations() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.size) {
            arrayList.add("rank f" + n + " is bounded");
            ++n;
        }
        n = 0;
        while (n < this.size - 1) {
            arrayList.add("rank f" + n + " is not increasing unless a smaller index decreases");
            ++n;
        }
        arrayList.add("at least one rank index decreases");
        return arrayList;
    }

    @Override
    public int getDegree() {
        assert (this.size > 0);
        return this.size * (this.size - 1) / 2;
    }
}

