/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieProgramExecution;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.Activator;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieConstructedType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.lib.models.Multigraph;
import de.uni_freiburg.informatik.ultimate.core.lib.models.MultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ConditionAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResult;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.DefaultTranslator;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.ProgramExecutionFormatter;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BoogiePreprocessorBacktranslator
extends DefaultTranslator<BoogieASTNode, BoogieASTNode, Expression, Expression, String, String, ILocation> {
    private final ILogger mLogger;
    private final HashMap<BoogieASTNode, BoogieASTNode> mMapping;
    private final IUltimateServiceProvider mServices;
    private BoogieSymbolTable mSymbolTable;

    BoogiePreprocessorBacktranslator(IUltimateServiceProvider iUltimateServiceProvider) {
        super(BoogieASTNode.class, BoogieASTNode.class, Expression.class, Expression.class);
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mMapping = new HashMap();
    }

    public BoogieSymbolTable getSymbolTable() {
        return this.mSymbolTable;
    }

    public void setSymbolTable(BoogieSymbolTable boogieSymbolTable) {
        this.mSymbolTable = boogieSymbolTable;
    }

    void addMapping(BoogieASTNode boogieASTNode, BoogieASTNode boogieASTNode2) {
        BoogieASTNode boogieASTNode3 = this.mMapping.get(boogieASTNode);
        if (boogieASTNode3 == null) {
            boogieASTNode3 = boogieASTNode;
        }
        this.mMapping.put(boogieASTNode2, boogieASTNode3);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Create mapping between");
            this.mLogger.debug((Object)("\tOutput " + BoogiePreprocessorBacktranslator.printDebug(boogieASTNode2)));
            this.mLogger.debug((Object)("\tInput  " + BoogiePreprocessorBacktranslator.printDebug(boogieASTNode3)));
        }
    }

    public IProgramExecution<BoogieASTNode, Expression> translateProgramExecution(IProgramExecution<BoogieASTNode, Expression> iProgramExecution) {
        assert (this.checkCallStackSourceProgramExecution(this.mLogger, iProgramExecution)) : "callstack of initial program execution already broken";
        ArrayList<BoogieASTNode> arrayList = new ArrayList<BoogieASTNode>();
        ArrayList<IProgramExecution.ProgramState<Expression>> arrayList2 = new ArrayList<IProgramExecution.ProgramState<Expression>>();
        IProgramExecution.ProgramState programState = this.translateProgramState(iProgramExecution.getInitialProgramState());
        int n = iProgramExecution.getLength();
        int n2 = 0;
        while (n2 < n) {
            BoogieASTNode boogieASTNode = (BoogieASTNode)iProgramExecution.getTraceElement(n2).getTraceElement();
            arrayList.add(this.translateTraceElement(boogieASTNode));
            IProgramExecution.ProgramState programState2 = iProgramExecution.getProgramState(n2);
            arrayList2.add((IProgramExecution.ProgramState<Expression>)this.translateProgramState(programState2));
            ++n2;
        }
        return this.createProgramExecutionFromTrace(arrayList, (IProgramExecution.ProgramState<Expression>)programState, arrayList2, iProgramExecution);
    }

    private BoogieASTNode translateTraceElement(BoogieASTNode boogieASTNode) {
        BoogieASTNode boogieASTNode2 = this.mMapping.get(boogieASTNode);
        if (boogieASTNode2 == null) {
            if (boogieASTNode instanceof EnsuresSpecification) {
                EnsuresSpecification ensuresSpecification = (EnsuresSpecification)boogieASTNode;
                Expression expression = ensuresSpecification.getFormula();
                if (expression instanceof BooleanLiteral && ((BooleanLiteral)expression).getValue()) {
                    return null;
                }
                this.reportUnfinishedBacktranslation("Generated EnsuresSpecification " + BoogiePrettyPrinter.print((Specification)ensuresSpecification) + " is not ensure(true)");
                return null;
            }
            return boogieASTNode;
        }
        if (boogieASTNode2 instanceof Statement || boogieASTNode2 instanceof LoopInvariantSpecification) {
            return boogieASTNode2;
        }
        this.reportUnfinishedBacktranslation("Unfinished backtranslation: Ignored translation of " + boogieASTNode2.getClass().getSimpleName());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private IProgramExecution<BoogieASTNode, Expression> createProgramExecutionFromTrace(List<BoogieASTNode> list, IProgramExecution.ProgramState<Expression> programState, List<IProgramExecution.ProgramState<Expression>> list2, IProgramExecution<BoogieASTNode, Expression> iProgramExecution) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < list.size()) {
            object = list.get(n);
            if (object == null) {
                arrayList.add(null);
            } else {
                AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n);
                if (object instanceof WhileStatement) {
                    void var10_16;
                    assert (this.checkProcedureNames((BoogieASTNode)object, (AtomicTraceElement<BoogieASTNode>)atomicTraceElement));
                    var9_11 = (WhileStatement)object;
                    if (atomicTraceElement.getTraceElement() instanceof AssumeStatement) {
                        var11_22 = (AssumeStatement)atomicTraceElement.getTraceElement();
                        Expression expression = var9_11.getCondition();
                        AtomicTraceElement.StepInfo stepInfo = this.getStepInfoFromCondition(var11_22.getFormula(), expression);
                    } else {
                        AtomicTraceElement.StepInfo stepInfo = (AtomicTraceElement.StepInfo)atomicTraceElement.getStepInfo().iterator().next();
                        assert (atomicTraceElement.getStepInfo().size() == 1);
                        assert (stepInfo == AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE || stepInfo == AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE);
                    }
                    arrayList.add(BoogiePreprocessorBacktranslator.createAtomicTraceElement((AtomicTraceElement<BoogieASTNode>)atomicTraceElement, (BoogieASTNode)var9_11, (BoogieASTNode)var9_11.getCondition(), (AtomicTraceElement.StepInfo)var10_16));
                } else if (object instanceof IfStatement) {
                    void var10_19;
                    assert (this.checkProcedureNames((BoogieASTNode)object, (AtomicTraceElement<BoogieASTNode>)atomicTraceElement));
                    var9_11 = (IfStatement)object;
                    if (atomicTraceElement.getTraceElement() instanceof AssumeStatement) {
                        var11_22 = (AssumeStatement)atomicTraceElement.getTraceElement();
                        AtomicTraceElement.StepInfo stepInfo = this.getStepInfoFromCondition(var11_22.getFormula(), var9_11.getCondition());
                    } else {
                        AtomicTraceElement.StepInfo stepInfo = (AtomicTraceElement.StepInfo)atomicTraceElement.getStepInfo().iterator().next();
                        assert (atomicTraceElement.getStepInfo().size() == 1);
                        assert (stepInfo == AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE || stepInfo == AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE);
                    }
                    arrayList.add(BoogiePreprocessorBacktranslator.createAtomicTraceElement((AtomicTraceElement<BoogieASTNode>)atomicTraceElement, (BoogieASTNode)var9_11, (BoogieASTNode)var9_11.getCondition(), (AtomicTraceElement.StepInfo)var10_19));
                } else if (object instanceof CallStatement) {
                    var9_11 = AtomicTraceElement.AtomicTraceElementBuilder.from((AtomicTraceElement)atomicTraceElement).setToStringFunc(BoogiePrettyPrinter.getBoogieToStringProvider()).setStepAndElement(object);
                    if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.NONE)) {
                        arrayList.add(var9_11.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.FUNC_CALL}).build());
                    } else {
                        assert (this.checkProcedureNames((BoogieASTNode)object, (AtomicTraceElement<BoogieASTNode>)atomicTraceElement)) : "Call stack broken";
                        arrayList.add(var9_11.build());
                    }
                } else {
                    assert (this.checkProcedureNames((BoogieASTNode)object, (AtomicTraceElement<BoogieASTNode>)atomicTraceElement));
                    arrayList.add(BoogiePreprocessorBacktranslator.createAtomicTraceElement((AtomicTraceElement<BoogieASTNode>)atomicTraceElement, (BoogieASTNode)object, (BoogieASTNode)object, atomicTraceElement.getStepInfo()));
                }
            }
            ++n;
        }
        ArrayList<AtomicTraceElement> arrayList2 = new ArrayList<AtomicTraceElement>();
        object = new HashMap();
        object.put(-1, programState);
        int n2 = 0;
        int n3 = 0;
        for (AtomicTraceElement atomicTraceElement : arrayList) {
            if (atomicTraceElement != null) {
                arrayList2.add(atomicTraceElement);
                object.put(n3, list2.get(n2));
                ++n3;
            }
            ++n2;
        }
        assert (this.checkCallStackTarget(this.mLogger, arrayList2)) : "callstack broke during translation by " + ((Object)((Object)this)).getClass().getSimpleName();
        return new BoogieProgramExecution((Map)object, arrayList2, iProgramExecution.isConcurrent());
    }

    private static AtomicTraceElement<BoogieASTNode> createAtomicTraceElement(AtomicTraceElement<BoogieASTNode> atomicTraceElement, BoogieASTNode boogieASTNode, BoogieASTNode boogieASTNode2, EnumSet<AtomicTraceElement.StepInfo> enumSet) {
        AtomicTraceElement.AtomicTraceElementBuilder atomicTraceElementBuilder = new AtomicTraceElement.AtomicTraceElementBuilder();
        if (atomicTraceElement.hasThreadId()) {
            atomicTraceElementBuilder.setThreadId(atomicTraceElement.getThreadId());
        }
        if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.FORK)) {
            atomicTraceElementBuilder.setForkedThreadId(atomicTraceElement.getForkedThreadId());
        }
        if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.JOIN)) {
            atomicTraceElementBuilder.setJoinedThreadId(atomicTraceElement.getJoinedThreadId());
        }
        atomicTraceElementBuilder.setToStringFunc(BoogiePrettyPrinter.getBoogieToStringProvider());
        atomicTraceElementBuilder.setElement((Object)boogieASTNode);
        atomicTraceElementBuilder.setStep((Object)boogieASTNode2);
        atomicTraceElementBuilder.setStepInfo(enumSet);
        atomicTraceElementBuilder.setRelevanceInformation(atomicTraceElement.getRelevanceInformation());
        return atomicTraceElementBuilder.build();
    }

    private static AtomicTraceElement<BoogieASTNode> createAtomicTraceElement(AtomicTraceElement<BoogieASTNode> atomicTraceElement, BoogieASTNode boogieASTNode, BoogieASTNode boogieASTNode2, AtomicTraceElement.StepInfo stepInfo) {
        return BoogiePreprocessorBacktranslator.createAtomicTraceElement(atomicTraceElement, boogieASTNode, boogieASTNode2, EnumSet.of(stepInfo));
    }

    private boolean checkProcedureNames(BoogieASTNode boogieASTNode, AtomicTraceElement<BoogieASTNode> atomicTraceElement) {
        if (boogieASTNode instanceof CallStatement) {
            boolean bl = BoogiePreprocessorBacktranslator.checkProcedureNames((CallStatement)boogieASTNode, atomicTraceElement);
            if (!bl) {
                this.mLogger.fatal((Object)("Call stack broken at " + String.valueOf(atomicTraceElement)));
                return false;
            }
            return true;
        }
        if (boogieASTNode instanceof ForkStatement) {
            return true;
        }
        if (boogieASTNode instanceof JoinStatement) {
            return true;
        }
        if (!Objects.equals(atomicTraceElement.getPrecedingProcedure(), atomicTraceElement.getSucceedingProcedure())) {
            this.mLogger.fatal((Object)("Call stack broken at " + String.valueOf(atomicTraceElement)));
            return false;
        }
        return true;
    }

    private static boolean checkProcedureNames(CallStatement callStatement, AtomicTraceElement<BoogieASTNode> atomicTraceElement) {
        if (atomicTraceElement.hasThreadId()) {
            return true;
        }
        if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.PROC_CALL)) {
            return callStatement.getMethodName().equals(atomicTraceElement.getSucceedingProcedure());
        }
        if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.PROC_RETURN)) {
            return callStatement.getMethodName().equals(atomicTraceElement.getPrecedingProcedure());
        }
        if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.NONE)) {
            return atomicTraceElement.getPrecedingProcedure() == null && atomicTraceElement.getSucceedingProcedure() == null;
        }
        return false;
    }

    private AtomicTraceElement.StepInfo getStepInfoFromCondition(Expression expression, Expression expression2) {
        if (!(expression instanceof UnaryExpression)) {
            return AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE;
        }
        UnaryExpression unaryExpression = (UnaryExpression)expression;
        if (unaryExpression.getOperator() != UnaryExpression.Operator.LOGICNEG) {
            return AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE;
        }
        if (!(expression2 instanceof UnaryExpression)) {
            return AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE;
        }
        UnaryExpression unaryExpression2 = (UnaryExpression)expression2;
        if (unaryExpression.getOperator() != UnaryExpression.Operator.LOGICNEG) {
            return AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE;
        }
        return this.getStepInfoFromCondition(unaryExpression.getExpr(), unaryExpression2.getExpr());
    }

    public List<BoogieASTNode> translateTrace(List<BoogieASTNode> list) {
        return super.translateTrace(list);
    }

    public Expression translateExpression(Expression expression) {
        return new ExpressionTranslator().processExpression(expression);
    }

    public String targetExpressionToString(Expression expression) {
        return BoogiePrettyPrinter.print((Expression)expression);
    }

    public List<String> targetTraceToString(List<BoogieASTNode> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BoogieASTNode boogieASTNode : list) {
            if (boogieASTNode instanceof Statement) {
                arrayList.add(BoogiePrettyPrinter.print((Statement)((Statement)boogieASTNode)));
                continue;
            }
            return super.targetTraceToString(list);
        }
        return arrayList;
    }

    public IBacktranslatedCFG<String, BoogieASTNode> translateCFG(IBacktranslatedCFG<String, BoogieASTNode> iBacktranslatedCFG) {
        IBacktranslatedCFG iBacktranslatedCFG2 = this.translateCFG(iBacktranslatedCFG, (map, iMultigraphEdge, multigraph) -> this.translateCFGEdge((Map<IExplicitEdgesMultigraph<?, ?, String, ? extends BoogieASTNode, ?>, Multigraph<String, BoogieASTNode>>)map, (IMultigraphEdge<?, ?, String, BoogieASTNode, ?>)iMultigraphEdge, (Multigraph<String, BoogieASTNode>)multigraph));
        return iBacktranslatedCFG2;
    }

    private Multigraph<String, BoogieASTNode> translateCFGEdge(Map<IExplicitEdgesMultigraph<?, ?, String, ? extends BoogieASTNode, ?>, Multigraph<String, BoogieASTNode>> map, IMultigraphEdge<?, ?, String, BoogieASTNode, ?> iMultigraphEdge, Multigraph<String, BoogieASTNode> multigraph) {
        BoogieASTNode boogieASTNode = this.translateTraceElement((BoogieASTNode)iMultigraphEdge.getLabel());
        IExplicitEdgesMultigraph iExplicitEdgesMultigraph = iMultigraphEdge.getTarget();
        Multigraph multigraph2 = map.get(iExplicitEdgesMultigraph);
        if (multigraph2 == null) {
            multigraph2 = this.createLabeledWitnessNode(iExplicitEdgesMultigraph);
            map.put(iExplicitEdgesMultigraph, (Multigraph<String, BoogieASTNode>)multigraph2);
        }
        MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, (Object)boogieASTNode, multigraph2);
        ConditionAnnotation conditionAnnotation = ConditionAnnotation.getAnnotation((IElement)((IElement)iMultigraphEdge.getLabel()));
        if (conditionAnnotation != null) {
            conditionAnnotation.annotate((IElement)multigraphEdge);
        }
        return multigraph2;
    }

    private void reportUnfinishedBacktranslation(String string) {
        boolean bl = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Show backtranslation warnings");
        if (!bl) {
            return;
        }
        this.mLogger.warn((Object)string);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new GenericResult(Activator.PLUGIN_ID, "Unfinished Backtranslation", string, IResultWithSeverity.Severity.WARNING));
    }

    protected void printBrokenCallStackSource(List<AtomicTraceElement<BoogieASTNode>> list, int n) {
        this.mLogger.fatal((Object)new ProgramExecutionFormatter((IBacktranslationValueProvider)new BoogieBacktranslationValueProvider()).formatProgramExecution((IProgramExecution)new BoogieProgramExecution(list.subList(0, n), false)));
    }

    protected void printBrokenCallStackTarget(List<AtomicTraceElement<BoogieASTNode>> list, int n) {
        this.printBrokenCallStackSource(list, n);
    }

    private static String printDebug(BoogieASTNode boogieASTNode) {
        if (boogieASTNode instanceof Statement) {
            return BoogiePrettyPrinter.print((Statement)((Statement)boogieASTNode));
        }
        if (boogieASTNode instanceof Expression) {
            return BoogiePrettyPrinter.print((Expression)((Expression)boogieASTNode));
        }
        if (boogieASTNode instanceof Procedure) {
            return BoogiePrettyPrinter.printSignature((Procedure)((Procedure)boogieASTNode));
        }
        if (boogieASTNode instanceof VarList) {
            return BoogiePrettyPrinter.print((VarList)((VarList)boogieASTNode));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(boogieASTNode.getClass().getSimpleName());
        ILocation iLocation = boogieASTNode.getLocation();
        if (iLocation != null) {
            int n = iLocation.getStartLine();
            int n2 = iLocation.getEndLine();
            stringBuilder.append(" L");
            stringBuilder.append(n);
            if (n != n2) {
                stringBuilder.append(":");
                stringBuilder.append(n2);
            }
            int n3 = iLocation.getStartColumn();
            int n4 = iLocation.getEndColumn();
            stringBuilder.append(" C");
            stringBuilder.append(n3);
            if (n3 != n4) {
                stringBuilder.append(":");
                stringBuilder.append(n4);
            }
        }
        return stringBuilder.toString();
    }

    private class ExpressionTranslator
    extends BoogieTransformer {
        private ExpressionTranslator() {
        }

        protected Expression processExpression(Expression expression) {
            if (expression == null) {
                return null;
            }
            if (BoogiePreprocessorBacktranslator.this.mSymbolTable == null) {
                BoogiePreprocessorBacktranslator.this.reportUnfinishedBacktranslation("No symboltable available, using identity as back-translation of " + String.valueOf(expression));
                return expression;
            }
            if (!(expression instanceof IdentifierExpression)) {
                return super.processExpression(expression);
            }
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            if (identifierExpression.getDeclarationInformation() == null) {
                BoogiePreprocessorBacktranslator.this.reportUnfinishedBacktranslation("Identifier has no declaration information, using identity as back-translation of " + String.valueOf(expression));
                return expression;
            }
            if (identifierExpression.getDeclarationInformation().getStorageClass() == DeclarationInformation.StorageClass.QUANTIFIED) {
                BoogiePreprocessorBacktranslator.this.reportUnfinishedBacktranslation("Identifier is quantified, using identity as back-translation of " + String.valueOf(expression));
                return expression;
            }
            Declaration declaration = BoogiePreprocessorBacktranslator.this.mSymbolTable.getDeclaration(identifierExpression);
            if (declaration == null) {
                BoogiePreprocessorBacktranslator.this.reportUnfinishedBacktranslation("No declaration in symboltable, using identity as back-translation of " + String.valueOf(expression));
                return expression;
            }
            BoogieASTNode boogieASTNode = this.getMapping((BoogieASTNode)declaration);
            if (boogieASTNode instanceof Declaration) {
                return this.extractIdentifier((Declaration)boogieASTNode, identifierExpression);
            }
            if (boogieASTNode instanceof VarList) {
                return this.extractIdentifier(boogieASTNode.getLocation(), (VarList)boogieASTNode, identifierExpression);
            }
            return expression;
        }

        private BoogieASTNode getMapping(BoogieASTNode boogieASTNode) {
            BoogieASTNode boogieASTNode2 = BoogiePreprocessorBacktranslator.this.mMapping.get(boogieASTNode);
            if (boogieASTNode2 != null) {
                return boogieASTNode2;
            }
            if (boogieASTNode instanceof VariableDeclaration) {
                VariableDeclaration variableDeclaration = (VariableDeclaration)boogieASTNode;
                VarList[] varListArray = variableDeclaration.getVariables();
                int n = varListArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VarList varList = varListArray[n2];
                    boogieASTNode2 = this.getMapping((BoogieASTNode)varList);
                    if (boogieASTNode2 != null) {
                        return boogieASTNode2;
                    }
                    ++n2;
                }
            }
            return null;
        }

        private IdentifierExpression extractIdentifier(Declaration declaration, IdentifierExpression identifierExpression) {
            IdentifierExpression identifierExpression2 = identifierExpression;
            if (declaration instanceof VariableDeclaration) {
                VariableDeclaration variableDeclaration = (VariableDeclaration)declaration;
                identifierExpression2 = this.extractIdentifier(variableDeclaration.getLocation(), variableDeclaration.getVariables(), identifierExpression);
                if (identifierExpression2 != identifierExpression) {
                    return identifierExpression2;
                }
                BoogiePreprocessorBacktranslator.this.reportUnfinishedBacktranslation("Unfinished backtranslation: Name guessing unsuccessful for VarDecl " + BoogiePrettyPrinter.print((VariableDeclaration)variableDeclaration) + " and expression " + BoogiePrettyPrinter.print((Expression)identifierExpression));
            } else if (declaration instanceof Procedure) {
                Procedure procedure = (Procedure)declaration;
                identifierExpression2 = this.extractIdentifier(procedure.getLocation(), procedure.getInParams(), identifierExpression);
                if (identifierExpression2 != identifierExpression) {
                    return identifierExpression2;
                }
                identifierExpression2 = this.extractIdentifier(procedure.getLocation(), procedure.getOutParams(), identifierExpression);
                if (identifierExpression2 != identifierExpression) {
                    return identifierExpression2;
                }
                BoogiePreprocessorBacktranslator.this.reportUnfinishedBacktranslation("Unfinished backtranslation: Name guessing unsuccessful for Procedure " + BoogiePrettyPrinter.printSignature((Procedure)procedure) + " and expression " + BoogiePrettyPrinter.print((Expression)identifierExpression));
            } else {
                BoogiePreprocessorBacktranslator.this.reportUnfinishedBacktranslation("Unfinished backtranslation: Declaration " + declaration.getClass().getSimpleName() + " not handled for expression " + BoogiePrettyPrinter.print((Expression)identifierExpression));
            }
            return identifierExpression2;
        }

        private IdentifierExpression extractIdentifier(ILocation iLocation, VarList[] varListArray, IdentifierExpression identifierExpression) {
            if (varListArray == null || varListArray.length == 0) {
                return identifierExpression;
            }
            IdentifierExpression identifierExpression2 = identifierExpression;
            VarList[] varListArray2 = varListArray;
            int n = varListArray.length;
            int n2 = 0;
            while (n2 < n) {
                VarList varList = varListArray2[n2];
                identifierExpression2 = this.extractIdentifier(iLocation, varList, identifierExpression);
                if (identifierExpression2 != identifierExpression) {
                    return identifierExpression2;
                }
                ++n2;
            }
            return identifierExpression2;
        }

        private IdentifierExpression extractIdentifier(ILocation iLocation, VarList varList, IdentifierExpression identifierExpression) {
            if (varList == null) {
                return identifierExpression;
            }
            IBoogieType iBoogieType = varList.getType().getBoogieType();
            if (!(iBoogieType instanceof BoogieType)) {
                throw new UnsupportedOperationException("The BoogiePreprocessorBacktranslator cannot handle " + iBoogieType.getClass().getSimpleName() + " as type of VarList");
            }
            BoogieType boogieType = (BoogieType)iBoogieType;
            return this.extractIdentifier(iLocation, varList, identifierExpression, boogieType);
        }

        private IdentifierExpression extractIdentifier(ILocation iLocation, VarList varList, IdentifierExpression identifierExpression, BoogieType boogieType) {
            if (boogieType instanceof BoogieStructType) {
                return this.extractStructIdentifier(iLocation, varList, identifierExpression, boogieType, (BoogieStructType)boogieType);
            }
            if (boogieType instanceof BoogieConstructedType) {
                BoogieConstructedType boogieConstructedType = (BoogieConstructedType)boogieType;
                if (boogieConstructedType.equals((Object)boogieConstructedType.getUnderlyingType())) {
                    if (boogieConstructedType.getClass() != boogieConstructedType.getUnderlyingType().getClass()) {
                        return this.extractIdentifier(iLocation, varList, identifierExpression, boogieConstructedType.getUnderlyingType());
                    }
                    return this.matchIdentifier(iLocation, varList, identifierExpression);
                }
                return this.extractIdentifier(iLocation, varList, identifierExpression, boogieConstructedType.getUnderlyingType());
            }
            if (boogieType instanceof BoogiePrimitiveType) {
                return this.matchIdentifier(iLocation, varList, identifierExpression);
            }
            if (boogieType instanceof BoogieArrayType) {
                return this.matchIdentifier(iLocation, varList, identifierExpression);
            }
            BoogiePreprocessorBacktranslator.this.reportUnfinishedBacktranslation("Unfinished Backtranslation: Type" + String.valueOf(boogieType) + " of VarList " + BoogiePrettyPrinter.print((VarList)varList) + " not handled");
            return identifierExpression;
        }

        private IdentifierExpression matchIdentifier(ILocation iLocation, VarList varList, IdentifierExpression identifierExpression) {
            String string = identifierExpression.getIdentifier();
            String[] stringArray = varList.getIdentifiers();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string.equals(string2)) {
                    return new IdentifierExpression(iLocation, varList.getType().getBoogieType(), string2, identifierExpression.getDeclarationInformation());
                }
                ++n2;
            }
            return identifierExpression;
        }

        private IdentifierExpression extractStructIdentifier(ILocation iLocation, VarList varList, IdentifierExpression identifierExpression, BoogieType boogieType, BoogieStructType boogieStructType) {
            String[] stringArray = identifierExpression.getIdentifier().split("\\.");
            if (stringArray.length == 1) {
                String string = identifierExpression.getIdentifier();
                String[] stringArray2 = varList.getIdentifiers();
                int n = stringArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray2[n2];
                    if (string.equals(string2)) {
                        return new IdentifierExpression(iLocation, (IBoogieType)boogieType, string2, identifierExpression.getDeclarationInformation());
                    }
                    ++n2;
                }
            } else if (stringArray.length == 2) {
                String string;
                String string3 = null;
                String string4 = stringArray[0];
                String[] stringArray3 = varList.getIdentifiers();
                int n = stringArray3.length;
                int n3 = 0;
                while (n3 < n) {
                    string = stringArray3[n3];
                    if (string4.contains(string)) {
                        string3 = string;
                        break;
                    }
                    ++n3;
                }
                if (string3 != null) {
                    stringArray3 = boogieStructType.getFieldIds();
                    n = stringArray3.length;
                    n3 = 0;
                    while (n3 < n) {
                        string = stringArray3[n3];
                        if (stringArray[1].contains(string)) {
                            return new IdentifierExpression(iLocation, (IBoogieType)boogieType, string3 + "!" + string, identifierExpression.getDeclarationInformation());
                        }
                        ++n3;
                    }
                }
            } else {
                BoogiePreprocessorBacktranslator.this.reportUnfinishedBacktranslation("Unfinished Backtranslation: Nested struct field access of VarList " + BoogiePrettyPrinter.print((VarList)varList) + " not handled");
            }
            return identifierExpression;
        }
    }
}

