/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class ArrayAccessExpression
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(ArrayAccessExpression.class);
    Expression array;
    Expression index;

    public ArrayAccessExpression(Expression expression, Expression expression2) {
        this.array = expression;
        this.index = expression2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ArrayAccessExpression: " + String.valueOf(this);
    }

    public ArrayAccessExpression(ACSLType aCSLType, Expression expression, Expression expression2) {
        super(aCSLType);
        this.array = expression;
        this.index = expression2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ArrayAccessExpression: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ArrayAccessExpression").append('[');
        stringBuffer.append(this.array);
        stringBuffer.append(',').append(this.index);
        return stringBuffer.append(']').toString();
    }

    public Expression getArray() {
        return this.array;
    }

    public Expression getIndex() {
        return this.index;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.array);
        list.add(this.index);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.array != null) {
                this.array.accept(aCSLVisitor);
            }
            if (this.index != null) {
                this.index.accept(aCSLVisitor);
            }
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.array != null) {
            expression2 = this.array.accept(aCSLTransformer);
        }
        Expression expression3 = null;
        if (this.index != null) {
            expression3 = this.index.accept(aCSLTransformer);
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        if (this.array != expression2 || this.index != expression3 || this.type != aCSLType) {
            return new ArrayAccessExpression(aCSLType, expression2, expression3);
        }
        return this;
    }
}

