/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;

class TextWriter {
    private StringBuilder buffer;
    private int startOffset;
    private int endOffset;
    private boolean isClosed = false;

    public TextWriter(int start, int length) {
        this.buffer = new StringBuilder(length);
        this.startOffset = start;
        this.endOffset = start + length;
    }

    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
        }
    }

    public int getCharCount() {
        return this.endOffset - this.startOffset;
    }

    public int getStart() {
        return this.startOffset;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String toString() {
        return this.buffer.toString();
    }

    void write(String string) {
        this.buffer.append(string);
    }

    void write(String string, int offset) {
        if (offset < 0 || offset > this.buffer.length()) {
            return;
        }
        this.buffer.insert(offset, string);
    }

    void write(int i) {
        this.buffer.append(i);
    }

    void write(char i) {
        this.buffer.append(i);
    }

    public void writeLine(String line, int lineOffset) {
        int copyEnd;
        int lineLength;
        int writeOffset;
        if (this.isClosed) {
            SWT.error(39);
        }
        if ((writeOffset = this.startOffset - lineOffset) >= (lineLength = line.length())) {
            return;
        }
        int lineIndex = writeOffset > 0 ? writeOffset : 0;
        if (lineIndex < (copyEnd = Math.min(lineLength, this.endOffset - lineOffset))) {
            this.write(line.substring(lineIndex, copyEnd));
        }
    }

    public void writeLineDelimiter(String lineDelimiter) {
        if (this.isClosed) {
            SWT.error(39);
        }
        this.write(lineDelimiter);
    }
}

