/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models;

import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IDirectedGraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILabeledEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.ISimpleAST;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class VisualizationNode
implements IExplicitEdgesMultigraph<VisualizationNode, VisualizationEdge, VisualizationNode, VisualizationEdge, VisualizationNode> {
    private static final long serialVersionUID = 1L;
    private final VisualizationWrapperNode mBacking;
    private List<VisualizationNode> mOutgoing;

    public VisualizationNode(IExplicitEdgesMultigraph<?, ?, ?, ?, VisualizationNode> iExplicitEdgesMultigraph) {
        this.mBacking = new VisualizationWrapperNode(this, (IElement)iExplicitEdgesMultigraph, (IExplicitEdgesMultigraph)iExplicitEdgesMultigraph){
            private final /* synthetic */ IExplicitEdgesMultigraph val$node;
            {
                this.val$node = iExplicitEdgesMultigraph;
                super(iElement);
            }

            @Override
            protected void createIncoming() {
                for (IMultigraphEdge iMultigraphEdge : this.val$node.getIncomingEdges()) {
                    if (iMultigraphEdge.getSource() == null) continue;
                    VisualizationEdge visualizationEdge = iMultigraphEdge.hasPayload() ? new VisualizationEdge((VisualizationNode)iMultigraphEdge.getSource().getVisualizationGraph(), this, iMultigraphEdge.getPayload(), iMultigraphEdge) : new VisualizationEdge((VisualizationNode)iMultigraphEdge.getSource().getVisualizationGraph(), this, iMultigraphEdge);
                    this.mIncoming.add(visualizationEdge);
                }
            }

            @Override
            protected void createOutgoing() {
                for (IMultigraphEdge iMultigraphEdge : this.val$node.getOutgoingEdges()) {
                    if (iMultigraphEdge.getTarget() == null) continue;
                    VisualizationEdge visualizationEdge = iMultigraphEdge.hasPayload() ? new VisualizationEdge(this, (VisualizationNode)iMultigraphEdge.getTarget().getVisualizationGraph(), iMultigraphEdge.getPayload(), iMultigraphEdge) : new VisualizationEdge(this, (VisualizationNode)iMultigraphEdge.getTarget().getVisualizationGraph(), iMultigraphEdge);
                    this.mOutgoing.add(visualizationEdge);
                }
            }

            @Override
            protected List<IWalkable> getSuccessors() {
                return this.getOutgoingEdges();
            }
        };
    }

    private static IPayload extractPayload(Object object) {
        IElement iElement;
        IPayload iPayload = null;
        if (object instanceof IPayload) {
            iPayload = (IPayload)object;
        } else if (object instanceof IElement && (iElement = (IElement)object).hasPayload()) {
            iPayload = iElement.getPayload();
        }
        return iPayload;
    }

    public <T extends ILabeledEdgesMultigraph<T, L, VisualizationNode>, L> VisualizationNode(ILabeledEdgesMultigraph<T, L, VisualizationNode> iLabeledEdgesMultigraph) {
        this.mBacking = new VisualizationWrapperNode(this, (IElement)iLabeledEdgesMultigraph, (ILabeledEdgesMultigraph)iLabeledEdgesMultigraph){
            private final /* synthetic */ ILabeledEdgesMultigraph val$node;
            {
                this.val$node = iLabeledEdgesMultigraph;
                super(iElement);
            }

            @Override
            protected void createIncoming() {
                for (ILabeledEdgesMultigraph iLabeledEdgesMultigraph : this.val$node.getIncomingNodes()) {
                    IPayload iPayload = VisualizationNode.extractPayload(this.val$node.getIncomingEdgeLabel(iLabeledEdgesMultigraph));
                    VisualizationEdge visualizationEdge = iPayload != null ? new VisualizationEdge((VisualizationNode)iLabeledEdgesMultigraph.getVisualizationGraph(), this, iPayload, null) : new VisualizationEdge((VisualizationNode)iLabeledEdgesMultigraph.getVisualizationGraph(), this, (Object)null);
                    this.mIncoming.add(visualizationEdge);
                }
            }

            @Override
            protected void createOutgoing() {
                for (ILabeledEdgesMultigraph iLabeledEdgesMultigraph : this.val$node.getOutgoingNodes()) {
                    IPayload iPayload = VisualizationNode.extractPayload(this.val$node.getOutgoingEdgeLabel(iLabeledEdgesMultigraph));
                    VisualizationEdge visualizationEdge = iPayload != null ? new VisualizationEdge(this, (VisualizationNode)iLabeledEdgesMultigraph.getVisualizationGraph(), iPayload, null) : new VisualizationEdge(this, (VisualizationNode)iLabeledEdgesMultigraph.getVisualizationGraph(), (Object)null);
                    this.mOutgoing.add(visualizationEdge);
                }
            }

            @Override
            protected List<IWalkable> getSuccessors() {
                ArrayList<IWalkable> arrayList = new ArrayList<IWalkable>();
                Iterator iterator = this.val$node.getOutgoingNodes().iterator();
                while (iterator.hasNext()) {
                    ILabeledEdgesMultigraph iLabeledEdgesMultigraph;
                    ILabeledEdgesMultigraph iLabeledEdgesMultigraph2 = iLabeledEdgesMultigraph = (ILabeledEdgesMultigraph)iterator.next();
                    arrayList.add(new IWalkableImplementation(this.val$node, iLabeledEdgesMultigraph2));
                }
                return arrayList;
            }
        };
    }

    public VisualizationNode(ISimpleAST<?, VisualizationNode> iSimpleAST) {
        this.mBacking = new VisualizationWrapperNode(this, (IElement)iSimpleAST, (ISimpleAST)iSimpleAST){
            private final /* synthetic */ ISimpleAST val$node;
            {
                this.val$node = iSimpleAST;
                super(iElement);
            }

            @Override
            protected List<IWalkable> getSuccessors() {
                return this.getOutgoingEdges();
            }

            @Override
            protected void createOutgoing() {
                this.mIncoming = new ArrayList();
                for (ISimpleAST iSimpleAST : this.val$node.getOutgoingNodes()) {
                    if (iSimpleAST == null) continue;
                    VisualizationEdge visualizationEdge = iSimpleAST.hasPayload() ? new VisualizationEdge(this, (VisualizationNode)iSimpleAST.getVisualizationGraph(), iSimpleAST.getPayload(), iSimpleAST) : new VisualizationEdge(this, (VisualizationNode)iSimpleAST.getVisualizationGraph(), iSimpleAST);
                    this.mOutgoing.add(visualizationEdge);
                }
            }

            @Override
            protected void createIncoming() {
            }
        };
    }

    public VisualizationNode(IDirectedGraph<?, VisualizationNode> iDirectedGraph) {
        this(iDirectedGraph, new HashMap<IElement, VisualizationWrapperNode>());
    }

    private VisualizationNode(IDirectedGraph<?, VisualizationNode> iDirectedGraph, HashMap<IElement, VisualizationWrapperNode> hashMap) {
        if (hashMap.containsKey(iDirectedGraph)) {
            this.mBacking = hashMap.get(iDirectedGraph);
        } else {
            this.mBacking = new VisualizationWrapperNode(this, (IElement)iDirectedGraph, (IDirectedGraph)iDirectedGraph, hashMap){
                private final /* synthetic */ IDirectedGraph val$node;
                private final /* synthetic */ HashMap val$backingDirectory;
                {
                    this.val$node = iDirectedGraph;
                    this.val$backingDirectory = hashMap;
                    super(iElement);
                }

                @Override
                protected List<IWalkable> getSuccessors() {
                    return this.getOutgoingEdges();
                }

                @Override
                protected void createOutgoing() {
                    for (IDirectedGraph iDirectedGraph : this.val$node.getOutgoingNodes()) {
                        this.mOutgoing.add(new VisualizationEdge(this, new VisualizationNode(iDirectedGraph, this.val$backingDirectory), (Object)null));
                    }
                }

                @Override
                protected void createIncoming() {
                    for (IDirectedGraph iDirectedGraph : this.val$node.getOutgoingNodes()) {
                        this.mIncoming.add(new VisualizationEdge(new VisualizationNode(iDirectedGraph, this.val$backingDirectory), this, (Object)null));
                    }
                }
            };
            hashMap.put((IElement)iDirectedGraph, this.mBacking);
        }
    }

    public List<VisualizationNode> getOutgoingNodes() {
        if (this.mOutgoing == null) {
            this.mOutgoing = new ArrayList<VisualizationNode>();
            for (VisualizationEdge visualizationEdge : this.getOutgoingEdges()) {
                this.mOutgoing.add((VisualizationNode)visualizationEdge.getTarget());
            }
        }
        return this.mOutgoing;
    }

    public Object getBacking() {
        if (this.mBacking == null) {
            return null;
        }
        return this.mBacking.mBackingNode;
    }

    public IPayload getPayload() {
        return this.mBacking.getPayload();
    }

    public boolean hasPayload() {
        return this.mBacking.hasPayload();
    }

    public VisualizationNode getVisualizationGraph() {
        return this.mBacking.getVisualizationGraph();
    }

    public List<IWalkable> getSuccessors() {
        return this.mBacking.getSuccessors();
    }

    public List<VisualizationEdge> getIncomingEdges() {
        return this.mBacking.getIncomingEdges();
    }

    public List<VisualizationEdge> getOutgoingEdges() {
        return this.mBacking.getOutgoingEdges();
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            return this.mBacking.equals(((VisualizationNode)object).mBacking);
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.mBacking.hashCode();
    }

    public String toString() {
        String string = this.mBacking.toString();
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        return string;
    }

    public VisualizationNode getLabel() {
        return this;
    }

    private static final class IWalkableImplementation<T extends ILabeledEdgesMultigraph<T, L, VisualizationNode>, L>
    implements IWalkable {
        private final T mNode;
        private final T mChild;
        private static final long serialVersionUID = 1L;

        private IWalkableImplementation(T t, T t2) {
            this.mNode = t;
            this.mChild = t2;
        }

        public boolean hasPayload() {
            return VisualizationNode.extractPayload(this.mNode.getOutgoingEdgeLabel(this.mChild)) != null;
        }

        public IPayload getPayload() {
            return VisualizationNode.extractPayload(this.mNode.getOutgoingEdgeLabel(this.mChild));
        }

        public List<IWalkable> getSuccessors() {
            return Collections.singletonList(this.mChild);
        }
    }

    private abstract class VisualizationWrapperNode {
        private final IElement mBackingNode;
        protected List<VisualizationEdge> mOutgoing;
        protected List<VisualizationEdge> mIncoming;

        protected VisualizationWrapperNode(IElement iElement) {
            this.mBackingNode = iElement;
        }

        protected IPayload getPayload() {
            return this.mBackingNode.getPayload();
        }

        protected boolean hasPayload() {
            return this.mBackingNode.hasPayload();
        }

        protected VisualizationNode getVisualizationGraph() {
            return VisualizationNode.this;
        }

        protected List<VisualizationEdge> getOutgoingEdges() {
            if (this.mOutgoing == null) {
                this.mOutgoing = new ArrayList<VisualizationEdge>();
                this.createOutgoing();
            }
            return this.mOutgoing;
        }

        protected List<VisualizationEdge> getIncomingEdges() {
            if (this.mIncoming == null) {
                this.mIncoming = new ArrayList<VisualizationEdge>();
                this.createIncoming();
            }
            return this.mIncoming;
        }

        protected abstract void createIncoming();

        protected abstract void createOutgoing();

        protected abstract List<IWalkable> getSuccessors();

        public boolean equals(Object object) {
            if (object instanceof VisualizationWrapperNode) {
                return this.mBackingNode.equals(((VisualizationWrapperNode)object).mBackingNode);
            }
            return super.equals(object);
        }

        public int hashCode() {
            return this.mBackingNode.hashCode();
        }

        public String toString() {
            return this.mBackingNode.toString();
        }
    }
}

