/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.CongruenceClosureSmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.Diet;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCcManager;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.RemoveCcElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PartialOrderCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

class WeakEquivalenceEdgeLabel<NODE extends IEqNodeIdentifier<NODE>> {
    private static final boolean MEET_IN_PLACE = true;
    private final WeakEquivalenceGraph<NODE> mWeakEquivalenceGraph;
    private final WeqCcManager<NODE> mWeqCcManager;
    private final Set<CongruenceClosure<NODE>> mDisjuncts;
    boolean mIsFrozen;

    WeakEquivalenceEdgeLabel(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, boolean bl) {
        this.mWeakEquivalenceGraph = weakEquivalenceGraph;
        this.mWeqCcManager = weakEquivalenceGraph.getWeqCcManager();
        this.mDisjuncts = new HashSet<CongruenceClosure<NODE>>(weakEquivalenceEdgeLabel.getNumberOfDisjuncts());
        for (CongruenceClosure<NODE> congruenceClosure2 : weakEquivalenceEdgeLabel.getDisjuncts()) {
            assert (!congruenceClosure2.isInconsistent());
            assert (!congruenceClosure2.isTautological() || weakEquivalenceEdgeLabel.getDisjuncts().size() == 1);
            this.mDisjuncts.add(this.mWeqCcManager.copyCc(congruenceClosure2, !this.mWeakEquivalenceGraph.isFrozen()));
        }
        assert (!this.mWeakEquivalenceGraph.isFrozen() || this.mDisjuncts.stream().allMatch(congruenceClosure -> congruenceClosure.isFrozen()));
        assert (bl || this.sanityCheck());
    }

    WeakEquivalenceEdgeLabel(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, Set<CongruenceClosure<NODE>> set) {
        this(weakEquivalenceGraph, set, false);
    }

    WeakEquivalenceEdgeLabel(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, Set<CongruenceClosure<NODE>> set, boolean bl) {
        this.mWeakEquivalenceGraph = weakEquivalenceGraph;
        this.mWeqCcManager = weakEquivalenceGraph.getWeqCcManager();
        this.mDisjuncts = this.mWeqCcManager.filterRedundantCcs(set);
        if (this.mDisjuncts.size() == 1 && this.mDisjuncts.iterator().next().isInconsistent()) {
            this.mDisjuncts.clear();
        }
        assert (this.mDisjuncts.stream().allMatch(congruenceClosure -> !this.mWeakEquivalenceGraph.isFrozen() || congruenceClosure.isFrozen()));
        assert (bl || this.sanityCheck());
    }

    WeakEquivalenceEdgeLabel(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, CongruenceClosure<NODE> congruenceClosure) {
        this.mWeakEquivalenceGraph = weakEquivalenceGraph;
        this.mWeqCcManager = weakEquivalenceGraph.getWeqCcManager();
        this.mDisjuncts = new HashSet<CongruenceClosure<NODE>>();
        if (weakEquivalenceGraph.isFrozen()) {
            this.mWeqCcManager.freezeIfNecessary(congruenceClosure);
            this.mDisjuncts.add(congruenceClosure);
        } else {
            this.mDisjuncts.add(this.mWeqCcManager.getCcManager().unfreezeIfNecessary(congruenceClosure));
        }
        assert (this.sanityCheck());
    }

    void setExternalRemInfo(IRemovalInfo<NODE> iRemovalInfo) {
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            congruenceClosure.setExternalRemInfo(iRemovalInfo);
        }
    }

    boolean hasExternalRemInfo() {
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            assert (congruenceClosure.assertHasExternalRemInfo());
        }
        return true;
    }

    boolean assertHasOnlyWeqVarConstraints(Set<NODE> set) {
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            if (congruenceClosure.assertHasOnlyWeqVarConstraints(set)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    void projectWeqVarNode(NODE NODE) {
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            if (congruenceClosure instanceof CongruenceClosure) {
                RemoveCcElement.removeSimpleElementDontIntroduceNewNodes(congruenceClosure, NODE);
                continue;
            }
            throw new AssertionError((Object)"implement this?");
        }
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
    }

    Set<NODE> projectAwaySimpleElement(NODE NODE) {
        if (this.isTautological()) {
            return Collections.emptySet();
        }
        if (this.isInconsistent()) {
            return Collections.emptySet();
        }
        HashSet hashSet = new HashSet();
        ArrayList<CongruenceClosure<NODE>> arrayList = new ArrayList<CongruenceClosure<NODE>>(this.getNumberOfDisjuncts());
        for (CongruenceClosure<NODE> congruenceClosure2 : this.getDisjuncts()) {
            assert (congruenceClosure2.sanityCheckOnlyCc(this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved()));
            RemoveCcElement.removeSimpleElementDontIntroduceNewNodes(congruenceClosure2, NODE);
            assert (congruenceClosure2.assertSingleElementIsFullyRemoved(NODE));
            if (congruenceClosure2.isTautological()) {
                this.setToTrue(this.mWeqCcManager.getEmptyCc(false));
                return Collections.emptySet();
            }
            assert (congruenceClosure2.sanityCheckOnlyCc(this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved()));
            assert (congruenceClosure2.assertSingleElementIsFullyRemoved(NODE));
            assert (!congruenceClosure2.isTautological());
            assert (congruenceClosure2.sanityCheckOnlyCc(this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved()));
            arrayList.add(congruenceClosure2);
        }
        this.setNewLabelContents(arrayList);
        assert (this.getDisjuncts().stream().allMatch(congruenceClosure -> congruenceClosure.assertSingleElementIsFullyRemoved((ICongruenceClosureElement)NODE)));
        assert (this.sanityCheck());
        return hashSet;
    }

    private int getNumberOfDisjuncts() {
        return this.mDisjuncts.size();
    }

    WeakEquivalenceEdgeLabel<NODE> projectToElements(Set<NODE> set, boolean bl) {
        assert (this.mWeakEquivalenceGraph.mWeqCc.mDiet == Diet.THIN);
        if (this.isInconsistent()) {
            return this;
        }
        if (set.isEmpty()) {
            return this;
        }
        HashSet<CongruenceClosure<NODE>> hashSet = new HashSet<CongruenceClosure<NODE>>();
        for (CongruenceClosure<NODE> object2 : this.getDisjuncts()) {
            CongruenceClosure<NODE> congruenceClosure2 = this.mWeqCcManager.projectToElements(object2, set, this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved(), bl);
            hashSet.add(congruenceClosure2);
        }
        assert (hashSet.stream().allMatch(congruenceClosure -> congruenceClosure.sanityCheckOnlyCc()));
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel = new WeakEquivalenceEdgeLabel<NODE>(this.mWeakEquivalenceGraph, hashSet);
        assert (weakEquivalenceEdgeLabel.sanityCheck());
        return weakEquivalenceEdgeLabel;
    }

    void inOrDecreaseWeqVarIndices(int n, List<NODE> list) {
        assert (n == 1 || n == -1) : "we don't expect any other cases";
        assert (n != 1 || !this.getAppearingNodes().contains(list.get(list.size() - 1))) : "project the highest weqvar before increasing!";
        assert (n != -1 || !this.getAppearingNodes().contains(list.get(0))) : "project the lowest weqvar before decreasing!";
        if (this.isTautological() || this.isInconsistent()) {
            return;
        }
        HashMap<Term, TermVariable> hashMap = new HashMap<Term, TermVariable>();
        int n2 = 0;
        while (n2 < list.size()) {
            IEqNodeIdentifier iEqNodeIdentifier2 = (IEqNodeIdentifier)list.get(n2);
            int n3 = n2 + n;
            if (n3 >= 0 && n3 < list.size()) {
                hashMap.put(iEqNodeIdentifier2.getTerm(), this.mWeqCcManager.getWeqVariableForDimension(n3, iEqNodeIdentifier2.getSort()));
            }
            ++n2;
        }
        this.transformElements(iEqNodeIdentifier -> iEqNodeIdentifier.renameVariables(hashMap));
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
    }

    boolean isConstrained(NODE NODE) {
        return this.getDisjuncts().stream().anyMatch(congruenceClosure -> congruenceClosure.isConstrained((ICongruenceClosureElement)NODE));
    }

    Set<CongruenceClosure<NODE>> getDisjuncts() {
        return Collections.unmodifiableSet(this.mDisjuncts);
    }

    boolean isInconsistent() {
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            if (!congruenceClosure.isInconsistent()) {
                return false;
            }
            assert (this.getDisjuncts().size() == 1) : "we are filtering out all but one 'bottoms', right?";
        }
        return true;
    }

    @Deprecated
    WeakEquivalenceEdgeLabel<NODE> reportChangeInGroundPartialArrangement(Predicate<CongruenceClosure<NODE>> predicate) {
        assert (this.sanityCheck());
        HashSet<CongruenceClosure<NODE>> hashSet = new HashSet<CongruenceClosure<NODE>>();
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            assert (this.mWeakEquivalenceGraph.mWeqCc.sanityCheck());
            assert (congruenceClosure.sanityCheckOnlyCc());
            CongruenceClosure<NODE> congruenceClosure2 = this.mWeqCcManager.getSettings().isMeetWithGpaOnReportchange() ? this.mWeqCcManager.meet(congruenceClosure, this.mWeakEquivalenceGraph.mWeqCc.getCongruenceClosure(), this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved(), false) : congruenceClosure;
            if (congruenceClosure2.isInconsistent()) continue;
            boolean bl = predicate.test(congruenceClosure2);
            if (!bl) {
                hashSet.add(congruenceClosure);
                assert (!congruenceClosure2.isInconsistent());
                continue;
            }
            if (this.mWeqCcManager.getSettings().isMeetWithGpaOnReportchange()) {
                CongruenceClosure<NODE> congruenceClosure3 = this.mWeqCcManager.projectToElements(congruenceClosure2, this.mWeakEquivalenceGraph.getWeqCcManager().getAllWeqNodes(), this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved(), true);
                hashSet.add(congruenceClosure3);
            } else {
                hashSet.add(congruenceClosure2);
            }
            assert (this.sanityCheck());
        }
        assert (hashSet.stream().allMatch(CongruenceClosure::sanityCheckOnlyCc));
        return new WeakEquivalenceEdgeLabel<NODE>(this.mWeakEquivalenceGraph, hashSet);
    }

    List<Term> toDnf(Script script) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Iterator<CongruenceClosure<NODE>> iterator = this.getDisjuncts().iterator();
        while (iterator.hasNext()) {
            CongruenceClosure<NODE> congruenceClosure;
            CongruenceClosure<NODE> congruenceClosure2 = congruenceClosure = iterator.next();
            List<Term> list = CongruenceClosureSmtUtils.congruenceClosureToCube(script, congruenceClosure2, this.mWeqCcManager.getNonTheoryLiteralDisequalitiesIfNecessary());
            Term term = SmtUtils.and((Script)script, list);
            arrayList.add(term);
        }
        return arrayList;
    }

    void transformElements(Function<NODE, NODE> function) {
        assert (!this.isFrozen());
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
        HashSet<CongruenceClosure<NODE>> hashSet = new HashSet<CongruenceClosure<NODE>>();
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            if (congruenceClosure.isFrozen()) {
                CongruenceClosure congruenceClosure2 = this.mWeqCcManager.getCcManager().unfreeze(congruenceClosure);
                congruenceClosure2.transformElementsAndFunctions(function);
                hashSet.add(congruenceClosure2);
            } else {
                congruenceClosure.transformElementsAndFunctions(function);
                hashSet.add(congruenceClosure);
            }
            assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
        }
        this.setNewLabelContents(hashSet);
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
    }

    Set<NODE> getAppearingNodes() {
        HashSet hashSet = new HashSet();
        this.getDisjuncts().forEach(congruenceClosure -> {
            boolean bl = hashSet.addAll(congruenceClosure.getAllElements());
        });
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    WeakEquivalenceEdgeLabel<NODE> meet(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, boolean bl) {
        void var5_9;
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
        assert (!bl || !this.isFrozen());
        WeakEquivalenceEdgeLabel weakEquivalenceEdgeLabel2 = null;
        if (WeqCcManager.areAssertsEnabled() && bl) {
            weakEquivalenceEdgeLabel2 = this.mWeqCcManager.copy(this, true, true);
        } else if (WeqCcManager.areAssertsEnabled() && !bl) {
            weakEquivalenceEdgeLabel2 = this;
        }
        HashSet hashSet = new HashSet();
        for (CongruenceClosure<NODE> object2 : this.getDisjuncts()) {
            for (CongruenceClosure<NODE> congruenceClosure2 : weakEquivalenceEdgeLabel.getDisjuncts()) {
                if (bl && !object2.isFrozen()) {
                    this.mWeqCcManager.meet(object2, congruenceClosure2, true);
                    hashSet.add(object2);
                    continue;
                }
                CongruenceClosure<NODE> congruenceClosure3 = this.mWeqCcManager.meet(object2, congruenceClosure2, false);
                hashSet.add(congruenceClosure3);
            }
        }
        assert (this.mWeqCcManager.checkMeetWeqLabels(weakEquivalenceEdgeLabel2, weakEquivalenceEdgeLabel, new WeakEquivalenceEdgeLabel<NODE>(this.mWeakEquivalenceGraph, hashSet, true)));
        if (bl) {
            Set<CongruenceClosure<NODE>> set = this.mWeqCcManager.filterRedundantCcs(hashSet);
            assert (set.stream().allMatch(congruenceClosure -> congruenceClosure.sanityCheckOnlyCc()));
            this.setNewLabelContents(set);
            WeakEquivalenceEdgeLabel weakEquivalenceEdgeLabel3 = this;
        } else {
            WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel4 = new WeakEquivalenceEdgeLabel<NODE>(this.mWeakEquivalenceGraph, hashSet);
        }
        if (!bl) {
            var5_9.freeze();
        }
        assert (var5_9.sanityCheck());
        return var5_9;
    }

    WeakEquivalenceEdgeLabel<NODE> union(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel) {
        return this.union(weakEquivalenceEdgeLabel, null);
    }

    WeakEquivalenceEdgeLabel<NODE> union(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, PartialOrderCache<CongruenceClosure<NODE>> partialOrderCache) {
        assert (this.sanityCheck() && weakEquivalenceEdgeLabel.sanityCheck());
        if (this.isTautological()) {
            return this;
        }
        if (weakEquivalenceEdgeLabel.isTautological()) {
            return weakEquivalenceEdgeLabel;
        }
        if (this.isInconsistent()) {
            return weakEquivalenceEdgeLabel;
        }
        if (weakEquivalenceEdgeLabel.isInconsistent()) {
            return this;
        }
        ArrayList<CongruenceClosure<NODE>> arrayList = new ArrayList<CongruenceClosure<NODE>>(this.getNumberOfDisjuncts() + weakEquivalenceEdgeLabel.getNumberOfDisjuncts());
        arrayList.addAll(this.getDisjuncts());
        arrayList.addAll(weakEquivalenceEdgeLabel.getDisjuncts());
        Set<CongruenceClosure<NODE>> set = partialOrderCache == null ? this.mWeqCcManager.filterRedundantCcs(new HashSet(arrayList)) : this.mWeqCcManager.filterRedundantCcs(new HashSet(arrayList), partialOrderCache);
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2 = new WeakEquivalenceEdgeLabel<NODE>(this.mWeakEquivalenceGraph, set);
        assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained2() || WeakEquivalenceEdgeLabel.assertUnionIntroducesNoNewNodes(this, weakEquivalenceEdgeLabel, weakEquivalenceEdgeLabel2)) : "union of two labels may not introduce any new nodes";
        assert (weakEquivalenceEdgeLabel2.sanityCheck());
        return weakEquivalenceEdgeLabel2;
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> boolean assertUnionIntroducesNoNewNodes(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel3) {
        Set set = DataStructureUtils.difference(weakEquivalenceEdgeLabel3.getAppearingNodes(), (Set)DataStructureUtils.union(weakEquivalenceEdgeLabel.getAppearingNodes(), weakEquivalenceEdgeLabel2.getAppearingNodes()));
        if (!set.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }

    boolean isTautological() {
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            if (!congruenceClosure.isTautological()) continue;
            assert (this.getDisjuncts().size() == 1);
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.getNumberOfDisjuncts() < this.mWeqCcManager.getSettings().getMaxNoEdgelabeldisjunctsForVerboseToString()) {
            return this.toLogString();
        }
        return "weq edge label, size: " + this.mDisjuncts.size();
    }

    public String toLogString() {
        if (this.isInconsistent()) {
            return "False";
        }
        if (this.isTautological()) {
            return "True";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.getDisjuncts().forEach(congruenceClosure -> {
            StringBuilder stringBuilder2 = stringBuilder.append(congruenceClosure.toLogString() + "\n");
        });
        return stringBuilder.toString();
    }

    boolean sanityCheck() {
        return this.sanityCheck(this.mWeakEquivalenceGraph.mWeqCc);
    }

    private boolean sanityCheck(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        if (this.mWeakEquivalenceGraph.getWeqCcManager() == null) {
            return true;
        }
        if (this.getDisjuncts().stream().anyMatch(congruenceClosure -> congruenceClosure.isTautological()) && this.getDisjuncts().size() > 1) {
            assert (false);
            return false;
        }
        if (this.getDisjuncts().stream().anyMatch(congruenceClosure -> congruenceClosure.isInconsistent())) {
            assert (false);
            return false;
        }
        if (weqCongruenceClosure != null) {
            for (CongruenceClosure<NODE> congruenceClosure2 : this.getDisjuncts()) {
                for (IEqNodeIdentifier iEqNodeIdentifier : congruenceClosure2.getAllElements()) {
                    if (!CongruenceClosure.dependsOnAny((ICongruenceClosureElement)iEqNodeIdentifier, this.mWeakEquivalenceGraph.getWeqCcManager().getAllWeqPrimedNodes())) continue;
                    assert (false);
                    return false;
                }
            }
        }
        return this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc);
    }

    void meetWithCcGpa() {
        HashSet<CongruenceClosure<NODE>> hashSet = new HashSet<CongruenceClosure<NODE>>();
        for (CongruenceClosure<NODE> congruenceClosure2 : this.getDisjuncts()) {
            assert (congruenceClosure2 instanceof CongruenceClosure);
            if (congruenceClosure2.isTautological()) {
                if (this.getNumberOfDisjuncts() == 1) {
                    return;
                }
                this.setToTrue(this.mWeqCcManager.getCcManager().unfreeze(this.mWeakEquivalenceGraph.mEmptyDisjunct));
                return;
            }
            CongruenceClosure congruenceClosure3 = this.mWeqCcManager.getCcManager().unfreezeIfNecessary(congruenceClosure2);
            this.mWeqCcManager.meet(congruenceClosure3, this.mWeakEquivalenceGraph.mWeqCc.getCongruenceClosure(), this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved(), true);
            if (congruenceClosure3.isInconsistent()) continue;
            if (congruenceClosure3.isTautological()) {
                assert (false) : "this should never happen because if the meet is tautological then mLabel.get(i)is, too, right?";
                this.setToTrue(this.mWeqCcManager.getCcManager().unfreeze(this.mWeakEquivalenceGraph.mEmptyDisjunct));
                return;
            }
            hashSet.add(congruenceClosure3);
        }
        assert (hashSet.size() <= 1 || !hashSet.stream().anyMatch(congruenceClosure -> congruenceClosure.isTautological()));
        this.setNewLabelContents(hashSet);
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
    }

    private void setNewLabelContents(Collection<CongruenceClosure<NODE>> collection) {
        assert (collection.stream().allMatch(congruenceClosure -> !this.mWeakEquivalenceGraph.isFrozen() || congruenceClosure.isFrozen()));
        this.mDisjuncts.clear();
        this.mDisjuncts.addAll(collection);
    }

    private void setToTrue(CongruenceClosure<NODE> congruenceClosure) {
        assert (this.mWeakEquivalenceGraph.isFrozen() == congruenceClosure.isFrozen());
        this.mDisjuncts.clear();
        this.mDisjuncts.add(congruenceClosure);
    }

    boolean sanityCheckDontEnforceProjectToWeqVars(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        if (weqCongruenceClosure != null) {
            for (CongruenceClosure<NODE> congruenceClosure2 : this.getDisjuncts()) {
                if (congruenceClosure2.sanityCheckOnlyCc(weqCongruenceClosure.getElementCurrentlyBeingRemoved())) continue;
                assert (false);
                return false;
            }
        }
        if (this.getDisjuncts().stream().anyMatch(congruenceClosure -> congruenceClosure.isTautological()) && this.getNumberOfDisjuncts() != 1) {
            assert (false) : "missing normalization: if there is one 'true' disjunct, we can dropall other disjuncts";
            return false;
        }
        if (this.getDisjuncts().stream().anyMatch(congruenceClosure -> congruenceClosure.isInconsistent())) {
            assert (false) : "missing normalization: contains 'false' disjuncts";
            return false;
        }
        return true;
    }

    boolean assertWeqVarSelectsHaveCorrectVarForDimension(int n) {
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            for (IEqNodeIdentifier iEqNodeIdentifier : congruenceClosure.getAllElements()) {
                if (!this.mWeqCcManager.getAllWeqNodes().contains(iEqNodeIdentifier) || this.mWeqCcManager.getDimensionOfWeqVar(iEqNodeIdentifier) < n) continue;
                assert (false);
                return false;
            }
        }
        return true;
    }

    boolean assertElementIsFullyRemoved(NODE NODE) {
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            if (congruenceClosure.assertSingleElementIsFullyRemoved(NODE)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    WeakEquivalenceGraph<NODE> getWeqGraph() {
        return this.mWeakEquivalenceGraph;
    }

    public boolean assertDisjunctsAreUnfrozen() {
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            if (!congruenceClosure.isFrozen()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean assertDisjunctsAreFrozen() {
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            if (congruenceClosure.isFrozen()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public void freeze() {
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            this.mWeqCcManager.freezeIfNecessary(congruenceClosure);
        }
        this.mIsFrozen = true;
    }

    public boolean assertIsSlim() {
        assert (this.assertHasOnlyWeqVarConstraints(this.mWeqCcManager.getAllWeqNodes()));
        assert (this.mWeakEquivalenceGraph.mEmptyDisjunct instanceof CongruenceClosure);
        assert (DataStructureUtils.intersection(this.getAppearingNodes(), this.mWeqCcManager.getAllWeqPrimedNodes()).isEmpty());
        return true;
    }

    public WeakEquivalenceEdgeLabel<NODE> thin(WeakEquivalenceGraph<NODE> weakEquivalenceGraph) {
        HashSet<CongruenceClosure<NODE>> hashSet = new HashSet<CongruenceClosure<NODE>>();
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            CongruenceClosure<NODE> congruenceClosure2 = this.mWeqCcManager.copyCc(congruenceClosure, true);
            CongruenceClosure<NODE> congruenceClosure3 = congruenceClosure2;
            CongruenceClosure<NODE> congruenceClosure4 = this.mWeqCcManager.projectToElements(congruenceClosure3, this.mWeqCcManager.getAllWeqNodes(), null, true);
            if (congruenceClosure4.isTautological()) {
                return new WeakEquivalenceEdgeLabel<NODE>(weakEquivalenceGraph, this.mWeqCcManager.getEmptyCc(true));
            }
            if (congruenceClosure4.isInconsistent()) continue;
            hashSet.add(congruenceClosure4);
        }
        return new WeakEquivalenceEdgeLabel<NODE>(weakEquivalenceGraph, hashSet);
    }

    public void freezeIfNecessary() {
        if (this.mIsFrozen) {
            return;
        }
        for (CongruenceClosure<NODE> congruenceClosure : this.getDisjuncts()) {
            this.mWeqCcManager.freezeIfNecessary(congruenceClosure);
        }
        this.mIsFrozen = true;
    }

    public boolean isFrozen() {
        return this.mIsFrozen;
    }

    public Set<SetConstraint<NODE>> getContainsConstraintForElement(NODE NODE) {
        Set set = null;
        for (CongruenceClosure<NODE> congruenceClosure : this.mDisjuncts) {
            Set set2 = congruenceClosure.getContainsConstraintForElement(NODE);
            if (set2 == null) {
                return null;
            }
            set = set == null ? set2 : this.mWeqCcManager.getCcManager().getSetConstraintManager().join(set, set2);
        }
        return set;
    }
}

