/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomatonCache;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NwaCacheBookkeeping;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import java.util.Collection;
import java.util.Set;

public abstract class AbstractInterpolantAutomaton<LETTER>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> {
    protected final IUltimateServiceProvider mServices;
    protected final ILogger mLogger;
    protected final CfgSmtToolkit mCsToolkit;
    protected final IHoareTripleChecker mIHoareTripleChecker;
    protected final IPredicate mIaFalseState;
    protected final NestedWordAutomatonCache<LETTER, IPredicate> mAlreadyConstructedAutomaton;
    protected final INestedWordAutomaton<LETTER, IPredicate> mInputInterpolantAutomaton;
    private Mode mMode = Mode.ON_DEMAND_CONSTRUCTION;
    private final InternalSuccessorComputationHelper mInSucComp;
    private final CallSuccessorComputationHelper mCaSucComp;
    private final ReturnSuccessorComputationHelper mReSucComp;
    private final ISuccessorComputationBookkeeping<LETTER> mSuccessorComputationBookkeeping;

    public AbstractInterpolantAutomaton(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, IHoareTripleChecker iHoareTripleChecker, boolean bl, IPredicate iPredicate, INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mCsToolkit = cfgSmtToolkit;
        this.mIHoareTripleChecker = iHoareTripleChecker;
        this.mIaFalseState = iPredicate;
        this.mInputInterpolantAutomaton = iNestedWordAutomaton;
        this.mInSucComp = new InternalSuccessorComputationHelper();
        this.mCaSucComp = new CallSuccessorComputationHelper();
        this.mReSucComp = new ReturnSuccessorComputationHelper();
        this.mAlreadyConstructedAutomaton = new NestedWordAutomatonCache(new AutomataLibraryServices(this.mServices), iNestedWordAutomaton.getVpAlphabet(), (IEmptyStackStateFactory)iNestedWordAutomaton.getStateFactory());
        this.mSuccessorComputationBookkeeping = bl ? new SuccessorComputationBookkeepingForTotalAutomata() : new DefaultSuccessorComputationBookkeeping();
    }

    public final void switchToReadonlyMode() {
        if (this.mMode == Mode.READ_ONLY) {
            throw new AssertionError((Object)"already in mode READ_ONLY");
        }
        this.mMode = Mode.READ_ONLY;
        this.mIHoareTripleChecker.releaseLock();
        this.mLogger.info((Object)this.switchToReadonlyMessage());
    }

    public final void switchToOnDemandConstructionMode() {
        if (this.mMode == Mode.ON_DEMAND_CONSTRUCTION) {
            throw new AssertionError((Object)"already in mode ON_DEMAND_CONSTRUCTION");
        }
        this.mMode = Mode.ON_DEMAND_CONSTRUCTION;
        this.mLogger.info((Object)this.switchToOnDemandConstructionMessage());
    }

    protected abstract String startMessage();

    protected abstract String switchToReadonlyMessage();

    protected abstract String switchToOnDemandConstructionMessage();

    protected abstract void computeSuccs(IPredicate var1, IPredicate var2, LETTER var3, SuccessorComputationHelper var4);

    public final int size() {
        return this.mAlreadyConstructedAutomaton.size();
    }

    public final Set<LETTER> getAlphabet() {
        return this.mAlreadyConstructedAutomaton.getAlphabet();
    }

    public final String sizeInformation() {
        if (this.mInputInterpolantAutomaton == null) {
            return "yet neither states nor transitions";
        }
        return this.mInputInterpolantAutomaton.sizeInformation();
    }

    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mAlreadyConstructedAutomaton.getVpAlphabet();
    }

    public final IStateFactory<IPredicate> getStateFactory() {
        return this.mAlreadyConstructedAutomaton.getStateFactory();
    }

    public final IPredicate getEmptyStackState() {
        return (IPredicate)this.mAlreadyConstructedAutomaton.getEmptyStackState();
    }

    public final Iterable<IPredicate> getInitialStates() {
        return this.mAlreadyConstructedAutomaton.getInitialStates();
    }

    public final boolean isInitial(IPredicate iPredicate) {
        return this.mAlreadyConstructedAutomaton.isInitial((Object)iPredicate);
    }

    public final boolean isFinal(IPredicate iPredicate) {
        return this.mAlreadyConstructedAutomaton.isFinal((Object)iPredicate);
    }

    public final Set<LETTER> lettersInternal(IPredicate iPredicate) {
        return this.getVpAlphabet().getInternalAlphabet();
    }

    public final Set<LETTER> lettersCall(IPredicate iPredicate) {
        return this.getVpAlphabet().getCallAlphabet();
    }

    public final Set<LETTER> lettersReturn(IPredicate iPredicate, IPredicate iPredicate2) {
        return this.getVpAlphabet().getReturnAlphabet();
    }

    public final Iterable<OutgoingInternalTransition<LETTER, IPredicate>> internalSuccessors(IPredicate iPredicate, LETTER LETTER) {
        if (this.mMode == Mode.ON_DEMAND_CONSTRUCTION && !this.mSuccessorComputationBookkeeping.areInternalSuccsComputed(iPredicate, LETTER)) {
            this.computeSuccs(iPredicate, null, LETTER, this.mInSucComp);
        }
        return this.mAlreadyConstructedAutomaton.internalSuccessors((Object)iPredicate, LETTER);
    }

    public final Iterable<OutgoingInternalTransition<LETTER, IPredicate>> internalSuccessors(IPredicate iPredicate) {
        if (this.mMode == Mode.ON_DEMAND_CONSTRUCTION) {
            for (LETTER LETTER : this.lettersInternal(iPredicate)) {
                if (this.mSuccessorComputationBookkeeping.areInternalSuccsComputed(iPredicate, LETTER)) continue;
                this.computeSuccs(iPredicate, null, LETTER, this.mInSucComp);
            }
        }
        return this.mAlreadyConstructedAutomaton.internalSuccessors((Object)iPredicate);
    }

    public final Iterable<OutgoingCallTransition<LETTER, IPredicate>> callSuccessors(IPredicate iPredicate, LETTER LETTER) {
        if (this.mMode == Mode.ON_DEMAND_CONSTRUCTION && !this.mSuccessorComputationBookkeeping.areCallSuccsComputed(iPredicate, LETTER)) {
            this.computeSuccs(iPredicate, null, LETTER, this.mCaSucComp);
        }
        return this.mAlreadyConstructedAutomaton.callSuccessors((Object)iPredicate, LETTER);
    }

    public final Iterable<OutgoingCallTransition<LETTER, IPredicate>> callSuccessors(IPredicate iPredicate) {
        if (this.mMode == Mode.ON_DEMAND_CONSTRUCTION) {
            for (LETTER LETTER : this.lettersCall(iPredicate)) {
                if (this.mAlreadyConstructedAutomaton.callSuccessors((Object)iPredicate, LETTER).iterator().hasNext()) continue;
                this.computeSuccs(iPredicate, null, LETTER, this.mCaSucComp);
            }
        }
        return this.mAlreadyConstructedAutomaton.callSuccessors((Object)iPredicate);
    }

    public final Iterable<OutgoingReturnTransition<LETTER, IPredicate>> returnSuccessors(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
        if (this.mMode == Mode.ON_DEMAND_CONSTRUCTION && !this.mSuccessorComputationBookkeeping.areReturnSuccsComputed(iPredicate, iPredicate2, LETTER)) {
            this.computeSuccs(iPredicate, iPredicate2, LETTER, this.mReSucComp);
        }
        return this.mAlreadyConstructedAutomaton.returnSuccessors((Object)iPredicate, (Object)iPredicate2, LETTER);
    }

    public final Iterable<OutgoingReturnTransition<LETTER, IPredicate>> returnSuccessorsGivenHier(IPredicate iPredicate, IPredicate iPredicate2) {
        if (this.mMode == Mode.ON_DEMAND_CONSTRUCTION) {
            for (LETTER LETTER : this.lettersReturn(iPredicate, iPredicate2)) {
                if (this.mAlreadyConstructedAutomaton.returnSuccessors((Object)iPredicate, (Object)iPredicate2, LETTER).iterator().hasNext()) continue;
                this.computeSuccs(iPredicate, iPredicate2, LETTER, this.mReSucComp);
            }
        }
        return this.mAlreadyConstructedAutomaton.returnSuccessorsGivenHier((Object)iPredicate, (Object)iPredicate2);
    }

    public final String toString() {
        if (this.mMode == Mode.READ_ONLY) {
            return AutomatonDefinitionPrinter.toString((AutomataLibraryServices)new AutomataLibraryServices(this.mServices), (String)"nwa", (IAutomaton)this);
        }
        return "automaton under construction";
    }

    public int computeNumberOfInternalTransitions() {
        return this.mAlreadyConstructedAutomaton.computeNumberOfInternalTransitions();
    }

    protected class CallSuccessorComputationHelper
    extends SuccessorComputationHelper {
        protected CallSuccessorComputationHelper() {
        }

        @Override
        public boolean isLinearPredecessorFalse(IPredicate iPredicate) {
            return iPredicate == AbstractInterpolantAutomaton.this.mIaFalseState;
        }

        @Override
        public boolean isHierarchicalPredecessorFalse(IPredicate iPredicate) {
            assert (iPredicate == null);
            return false;
        }

        @Override
        public void addTransition(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, IPredicate iPredicate3) {
            assert (iPredicate2 == null);
            AbstractInterpolantAutomaton.this.mAlreadyConstructedAutomaton.addCallTransition((Object)iPredicate, LETTER, (Object)iPredicate3);
        }

        @Override
        public IncrementalPlicationChecker.Validity computeSuccWithSolver(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, IPredicate iPredicate3) {
            assert (iPredicate2 == null);
            return AbstractInterpolantAutomaton.this.mIHoareTripleChecker.checkCall(iPredicate, (ICallAction)LETTER, iPredicate3);
        }

        @Override
        public Collection<IPredicate> getSuccsInterpolantAutomaton(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
            assert (iPredicate2 == null);
            Set set = NestedWordAutomataUtils.constructCallSuccessors(AbstractInterpolantAutomaton.this.mInputInterpolantAutomaton, (Object)iPredicate, LETTER);
            return set;
        }

        @Override
        public void reportSuccsComputed(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
            assert (iPredicate2 == null);
            AbstractInterpolantAutomaton.this.mSuccessorComputationBookkeeping.reportCallSuccsComputed(iPredicate, LETTER);
        }
    }

    private class DefaultSuccessorComputationBookkeeping
    implements ISuccessorComputationBookkeeping<LETTER> {
        private final NwaCacheBookkeeping<LETTER, IPredicate> mResultBookkeeping = new NwaCacheBookkeeping();

        private DefaultSuccessorComputationBookkeeping() {
        }

        @Override
        public boolean areInternalSuccsComputed(IPredicate iPredicate, LETTER LETTER) {
            return this.mResultBookkeeping.isCachedInternal((Object)iPredicate, LETTER);
        }

        @Override
        public void reportInternalSuccsComputed(IPredicate iPredicate, LETTER LETTER) {
            this.mResultBookkeeping.reportCachedInternal((Object)iPredicate, LETTER);
        }

        @Override
        public boolean areCallSuccsComputed(IPredicate iPredicate, LETTER LETTER) {
            return this.mResultBookkeeping.isCachedCall((Object)iPredicate, LETTER);
        }

        @Override
        public void reportCallSuccsComputed(IPredicate iPredicate, LETTER LETTER) {
            this.mResultBookkeeping.reportCachedCall((Object)iPredicate, LETTER);
        }

        @Override
        public boolean areReturnSuccsComputed(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
            return this.mResultBookkeeping.isCachedReturn((Object)iPredicate, (Object)iPredicate2, LETTER);
        }

        @Override
        public void reportReturnSuccsComputed(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
            this.mResultBookkeeping.reportCachedReturn((Object)iPredicate, (Object)iPredicate2, LETTER);
        }
    }

    public static interface ISuccessorComputationBookkeeping<LETTER> {
        public boolean areInternalSuccsComputed(IPredicate var1, LETTER var2);

        public void reportInternalSuccsComputed(IPredicate var1, LETTER var2);

        public boolean areCallSuccsComputed(IPredicate var1, LETTER var2);

        public void reportCallSuccsComputed(IPredicate var1, LETTER var2);

        public boolean areReturnSuccsComputed(IPredicate var1, IPredicate var2, LETTER var3);

        public void reportReturnSuccsComputed(IPredicate var1, IPredicate var2, LETTER var3);
    }

    protected class InternalSuccessorComputationHelper
    extends SuccessorComputationHelper {
        protected InternalSuccessorComputationHelper() {
        }

        @Override
        public boolean isLinearPredecessorFalse(IPredicate iPredicate) {
            return iPredicate == AbstractInterpolantAutomaton.this.mIaFalseState;
        }

        @Override
        public boolean isHierarchicalPredecessorFalse(IPredicate iPredicate) {
            assert (iPredicate == null);
            return false;
        }

        @Override
        public void addTransition(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, IPredicate iPredicate3) {
            assert (iPredicate2 == null);
            AbstractInterpolantAutomaton.this.mAlreadyConstructedAutomaton.addInternalTransition((Object)iPredicate, LETTER, (Object)iPredicate3);
        }

        @Override
        public IncrementalPlicationChecker.Validity computeSuccWithSolver(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, IPredicate iPredicate3) {
            assert (iPredicate2 == null);
            return AbstractInterpolantAutomaton.this.mIHoareTripleChecker.checkInternal(iPredicate, (IInternalAction)LETTER, iPredicate3);
        }

        @Override
        public Collection<IPredicate> getSuccsInterpolantAutomaton(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
            assert (iPredicate2 == null);
            Set set = NestedWordAutomataUtils.constructInternalSuccessors(AbstractInterpolantAutomaton.this.mInputInterpolantAutomaton, (Object)iPredicate, LETTER);
            return set;
        }

        @Override
        public void reportSuccsComputed(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
            assert (iPredicate2 == null);
            AbstractInterpolantAutomaton.this.mSuccessorComputationBookkeeping.reportInternalSuccsComputed(iPredicate, LETTER);
        }
    }

    public static enum Mode {
        ON_DEMAND_CONSTRUCTION,
        READ_ONLY;

    }

    public class ReturnSuccessorComputationHelper
    extends SuccessorComputationHelper {
        @Override
        public boolean isLinearPredecessorFalse(IPredicate iPredicate) {
            return iPredicate == AbstractInterpolantAutomaton.this.mIaFalseState;
        }

        @Override
        public boolean isHierarchicalPredecessorFalse(IPredicate iPredicate) {
            return iPredicate == AbstractInterpolantAutomaton.this.mIaFalseState;
        }

        @Override
        public void addTransition(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, IPredicate iPredicate3) {
            AbstractInterpolantAutomaton.this.mAlreadyConstructedAutomaton.addReturnTransition((Object)iPredicate, (Object)iPredicate2, LETTER, (Object)iPredicate3);
        }

        @Override
        public IncrementalPlicationChecker.Validity computeSuccWithSolver(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, IPredicate iPredicate3) {
            return AbstractInterpolantAutomaton.this.mIHoareTripleChecker.checkReturn(iPredicate, iPredicate2, (IReturnAction)LETTER, iPredicate3);
        }

        @Override
        public Collection<IPredicate> getSuccsInterpolantAutomaton(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
            Set set = NestedWordAutomataUtils.constructReturnSuccessors(AbstractInterpolantAutomaton.this.mInputInterpolantAutomaton, (Object)iPredicate, (Object)iPredicate2, LETTER);
            return set;
        }

        @Override
        public void reportSuccsComputed(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
            AbstractInterpolantAutomaton.this.mSuccessorComputationBookkeeping.reportReturnSuccsComputed(iPredicate, iPredicate2, LETTER);
        }
    }

    private class SuccessorComputationBookkeepingForTotalAutomata
    implements ISuccessorComputationBookkeeping<LETTER> {
        private SuccessorComputationBookkeepingForTotalAutomata() {
        }

        @Override
        public boolean areInternalSuccsComputed(IPredicate iPredicate, LETTER LETTER) {
            Set set = AbstractInterpolantAutomaton.this.mAlreadyConstructedAutomaton.succInternal((Object)iPredicate, LETTER);
            return set.iterator().hasNext();
        }

        @Override
        public boolean areCallSuccsComputed(IPredicate iPredicate, LETTER LETTER) {
            Set set = AbstractInterpolantAutomaton.this.mAlreadyConstructedAutomaton.succCall((Object)iPredicate, LETTER);
            return set.iterator().hasNext();
        }

        @Override
        public boolean areReturnSuccsComputed(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
            Set set = AbstractInterpolantAutomaton.this.mAlreadyConstructedAutomaton.succReturn((Object)iPredicate, (Object)iPredicate2, LETTER);
            return set.iterator().hasNext();
        }

        @Override
        public void reportInternalSuccsComputed(IPredicate iPredicate, LETTER LETTER) {
        }

        @Override
        public void reportCallSuccsComputed(IPredicate iPredicate, LETTER LETTER) {
        }

        @Override
        public void reportReturnSuccsComputed(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
        }
    }

    public abstract class SuccessorComputationHelper {
        public abstract boolean isLinearPredecessorFalse(IPredicate var1);

        public abstract boolean isHierarchicalPredecessorFalse(IPredicate var1);

        public abstract void addTransition(IPredicate var1, IPredicate var2, LETTER var3, IPredicate var4);

        public abstract IncrementalPlicationChecker.Validity computeSuccWithSolver(IPredicate var1, IPredicate var2, LETTER var3, IPredicate var4);

        public abstract Collection<IPredicate> getSuccsInterpolantAutomaton(IPredicate var1, IPredicate var2, LETTER var3);

        public abstract void reportSuccsComputed(IPredicate var1, IPredicate var2, LETTER var3);
    }
}

