/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.ArrayDomainExpressionProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.ArrayDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.ArrayDomainToolkit;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.Segmentation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.SegmentationMap;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.TemporaryBoogieVar;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ArrayDomainStatementProcessor<STATE extends IAbstractState<STATE>> {
    private final ArrayDomainExpressionProcessor<STATE> mExpressionProcessor;
    private final ArrayDomainToolkit<STATE> mToolkit;

    public ArrayDomainStatementProcessor(ArrayDomainToolkit<STATE> arrayDomainToolkit) {
        this.mToolkit = arrayDomainToolkit;
        this.mExpressionProcessor = new ArrayDomainExpressionProcessor<STATE>(arrayDomainToolkit);
    }

    public ArrayDomainState<STATE> process(ArrayDomainState<STATE> arrayDomainState, Statement statement) {
        if (statement instanceof AssignmentStatement) {
            return this.processAssignment(arrayDomainState, (AssignmentStatement)statement);
        }
        if (statement instanceof AssumeStatement) {
            return this.processAssume(arrayDomainState, (AssumeStatement)statement);
        }
        if (statement instanceof HavocStatement) {
            return this.processHavoc(arrayDomainState, (HavocStatement)statement);
        }
        if (statement instanceof Label) {
            return arrayDomainState;
        }
        throw new UnsupportedOperationException("Unknonwn type of statement: " + String.valueOf(statement));
    }

    private ArrayDomainState<STATE> processHavoc(ArrayDomainState<STATE> arrayDomainState, HavocStatement havocStatement) {
        List list = Arrays.asList(havocStatement.getIdentifiers()).stream().map(this.mToolkit::getBoogieVar).collect(Collectors.toList());
        return arrayDomainState.removeVariables((Collection)list).addVariables((Collection)list);
    }

    private ArrayDomainState<STATE> processAssume(ArrayDomainState<STATE> arrayDomainState, AssumeStatement assumeStatement) {
        return this.mExpressionProcessor.processAssume(arrayDomainState, assumeStatement.getFormula()).simplify();
    }

    private ArrayDomainState<STATE> processAssignment(ArrayDomainState<STATE> arrayDomainState, AssignmentStatement assignmentStatement) {
        LeftHandSide[] leftHandSideArray = assignmentStatement.getLhs();
        Expression[] expressionArray = assignmentStatement.getRhs();
        int n = leftHandSideArray.length;
        assert (leftHandSideArray.length == expressionArray.length && n > 0) : "Broken assignment statement";
        if (n > 1) {
            return this.processMultiAssignment(leftHandSideArray, expressionArray, arrayDomainState);
        }
        return this.processSingleAssignment(leftHandSideArray[0], expressionArray[0], arrayDomainState);
    }

    private ArrayDomainState<STATE> processMultiAssignment(LeftHandSide[] leftHandSideArray, Expression[] expressionArray, ArrayDomainState<STATE> arrayDomainState) {
        ArrayDomainState<STATE> arrayDomainState2 = arrayDomainState;
        int n = 0;
        while (n < leftHandSideArray.length) {
            IProgramVarOrConst iProgramVarOrConst = this.getLhsVariable(leftHandSideArray[n]);
            ArrayDomainState<STATE> arrayDomainState3 = this.processSingleAssignment(leftHandSideArray[n], expressionArray[n], arrayDomainState);
            ArrayDomainState<STATE> arrayDomainState4 = this.project(iProgramVarOrConst, arrayDomainState3);
            arrayDomainState2 = arrayDomainState2.patch(arrayDomainState4);
            ++n;
        }
        return arrayDomainState2;
    }

    private ArrayDomainState<STATE> processSingleAssignment(LeftHandSide leftHandSide, Expression expression, ArrayDomainState<STATE> arrayDomainState) {
        Pair<ArrayDomainState<STATE>, Expression> pair = this.mExpressionProcessor.processExpression(arrayDomainState, expression);
        ArrayDomainState arrayDomainState2 = (ArrayDomainState)pair.getFirst();
        Expression expression2 = (Expression)pair.getSecond();
        if (leftHandSide instanceof VariableLHS) {
            IProgramVar iProgramVar = this.mToolkit.getBoogieVar((VariableLHS)leftHandSide);
            if (iProgramVar.getSort().isArraySort()) {
                if (expression2 instanceof IdentifierExpression) {
                    IProgramVarOrConst iProgramVarOrConst = this.mToolkit.getBoogieVar((IdentifierExpression)expression2);
                    SegmentationMap segmentationMap = arrayDomainState2.getSegmentationMap();
                    segmentationMap.move((IProgramVarOrConst)iProgramVar, iProgramVarOrConst);
                    return arrayDomainState2.updateState(segmentationMap).simplify();
                }
                Pair pair2 = arrayDomainState2.getSegmentation(expression2);
                ArrayDomainState<IAbstractState> arrayDomainState3 = (ArrayDomainState<IAbstractState>)pair2.getFirst();
                Segmentation segmentation = (Segmentation)pair2.getSecond();
                SegmentationMap segmentationMap = arrayDomainState3.getSegmentationMap();
                if (segmentationMap.getEquivalenceClass((IProgramVarOrConst)iProgramVar).size() > 1) {
                    ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
                    ArrayList<Term> arrayList2 = new ArrayList<Term>();
                    Script script = this.mToolkit.getScript();
                    for (IProgramVar iProgramVar2 : segmentation.getValues()) {
                        TermVariable termVariable = iProgramVar2.getTermVariable();
                        TemporaryBoogieVar temporaryBoogieVar = this.mToolkit.createValueVar(iProgramVar2.getSort());
                        Term term = SmtUtils.filterFormula((Term)arrayDomainState3.getSubTerm(), Collections.singleton(termVariable), (Script)script);
                        arrayList2.add(PureSubstitution.apply((Script)script, Collections.singletonMap(termVariable, temporaryBoogieVar.getTermVariable()), (Term)term));
                        arrayList.add(temporaryBoogieVar);
                    }
                    segmentation = new Segmentation(segmentation.getBounds(), arrayList);
                    arrayDomainState3 = arrayDomainState3.updateState(this.mToolkit.handleAssumptionBySubdomain(arrayDomainState3.getSubState().addVariables(new ArrayList<IProgramVar>(arrayList)), SmtUtils.and((Script)script, arrayList2)));
                }
                segmentationMap.remove((IProgramVarOrConst)iProgramVar);
                segmentationMap.add((IProgramVarOrConst)iProgramVar, segmentation);
                return arrayDomainState3.updateState(segmentationMap).simplify();
            }
            AssignmentStatement assignmentStatement = ArrayDomainStatementProcessor.constructSingleAssignment(leftHandSide, expression2);
            STATE STATE = this.mToolkit.handleStatementBySubdomain(arrayDomainState2.getSubState(), (Statement)assignmentStatement);
            return arrayDomainState2.updateState(STATE).simplify();
        }
        if (leftHandSide instanceof ArrayLHS) {
            ArrayLHS arrayLHS = (ArrayLHS)leftHandSide;
            LeftHandSide leftHandSide2 = arrayLHS.getArray();
            if (!(leftHandSide2 instanceof VariableLHS)) {
                throw new UnsupportedOperationException("Unsupported assignment: " + String.valueOf(leftHandSide) + " := " + String.valueOf(expression));
            }
            TermVariable termVariable = this.mToolkit.getBoogieVar((VariableLHS)leftHandSide2).getTermVariable();
            Expression expression3 = this.mToolkit.getExpression((Term)termVariable);
            Expression[] expressionArray = arrayLHS.getIndices();
            ArrayStoreExpression arrayStoreExpression = new ArrayStoreExpression(null, expression3, expressionArray, expression);
            return this.processSingleAssignment(leftHandSide2, (Expression)arrayStoreExpression, arrayDomainState);
        }
        throw new UnsupportedOperationException("Unkonwn type of " + String.valueOf(leftHandSide));
    }

    private static AssignmentStatement constructSingleAssignment(LeftHandSide leftHandSide, Expression expression) {
        return new AssignmentStatement(null, new LeftHandSide[]{leftHandSide}, new Expression[]{expression});
    }

    private IProgramVarOrConst getLhsVariable(LeftHandSide leftHandSide) {
        if (leftHandSide instanceof VariableLHS) {
            return this.mToolkit.getBoogieVar((VariableLHS)leftHandSide);
        }
        if (leftHandSide instanceof ArrayLHS) {
            return this.getLhsVariable(((ArrayLHS)leftHandSide).getArray());
        }
        throw new UnsupportedOperationException("Unkonwn type of " + String.valueOf(leftHandSide));
    }

    private ArrayDomainState<STATE> project(IProgramVarOrConst iProgramVarOrConst, ArrayDomainState<STATE> arrayDomainState) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)arrayDomainState.getVariables());
        hashSet.remove(iProgramVarOrConst);
        return arrayDomainState.removeVariables(hashSet);
    }
}

