/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.translation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.Multigraph;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.BacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.ProcedureContract;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DefaultTranslator<STE, TTE, SE, TE, SVL, TVL, CTX>
implements ITranslator<STE, TTE, SE, TE, SVL, TVL, CTX> {
    private final Class<? extends STE> mSourceTraceElementType;
    private final Class<? extends TTE> mTargetTraceElementType;
    private final Class<SE> mSourceExpressionType;
    private final Class<TE> mTargetExpressionType;

    public DefaultTranslator(Class<? extends STE> clazz, Class<? extends TTE> clazz2, Class<SE> clazz3, Class<TE> clazz4) {
        this.mSourceTraceElementType = clazz;
        this.mTargetTraceElementType = clazz2;
        this.mSourceExpressionType = clazz3;
        this.mTargetExpressionType = clazz4;
        assert (this.mTargetExpressionType != null);
        assert (this.mTargetTraceElementType != null);
        assert (this.mSourceExpressionType != null);
        assert (this.mSourceTraceElementType != null);
    }

    public Class<? extends STE> getSourceTraceElementClass() {
        return this.mSourceTraceElementType;
    }

    public Class<? extends TTE> getTargetTraceElementClass() {
        return this.mTargetTraceElementType;
    }

    public Class<SE> getSourceExpressionClass() {
        return this.mSourceExpressionType;
    }

    public Class<TE> getTargetExpressionClass() {
        return this.mTargetExpressionType;
    }

    public List<TTE> translateTrace(List<STE> list) {
        List<STE> list2 = null;
        try {
            list2 = list;
            assert (this.consistsOfTargetTraceElements(list));
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)"Type of source trace element and type of target trace element are different. DefaultTranslator can only be applied to traces of same type.");
        }
        return list2;
    }

    public List<String> targetTraceToString(List<TTE> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TTE TTE : list) {
            arrayList.add(TTE.toString());
        }
        return arrayList;
    }

    public TE translateExpression(SE SE) {
        SE SE2;
        try {
            SE2 = SE;
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)"Type of SourceExpression and type of TargetExpression are different. DefaultTranslator can only be applied to expression of same type.");
        }
        return (TE)SE2;
    }

    public TE translateExpressionWithContext(SE SE, CTX CTX) {
        return this.translateExpression(SE);
    }

    public String targetExpressionToString(TE TE) {
        if (TE == null) {
            return null;
        }
        return TE.toString();
    }

    public IProgramExecution<TTE, TE> translateProgramExecution(IProgramExecution<STE, SE> iProgramExecution) {
        try {
            IProgramExecution<STE, SE> iProgramExecution2 = iProgramExecution;
            assert (this.consistsOfTargetTraceElements(iProgramExecution));
            return iProgramExecution2;
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)"Type of source trace element and type of target trace element are different. DefaultTranslator can only be applied to traces of same type.");
        }
    }

    public IBacktranslatedCFG<TVL, TTE> translateCFG(IBacktranslatedCFG<SVL, STE> iBacktranslatedCFG) {
        try {
            return iBacktranslatedCFG;
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)"Type of source trace element and type of target trace element are different. DefaultTranslator can only be applied to the same type.");
        }
    }

    private boolean consistsOfTargetTraceElements(IProgramExecution<STE, SE> iProgramExecution) {
        ArrayList<AtomicTraceElement> arrayList = new ArrayList<AtomicTraceElement>(iProgramExecution.getLength());
        int n = 0;
        while (n < iProgramExecution.getLength()) {
            arrayList.add(iProgramExecution.getTraceElement(n));
            ++n;
        }
        return true;
    }

    private boolean consistsOfTargetTraceElements(List<STE> list) {
        ArrayList<STE> arrayList = new ArrayList<STE>(list.size());
        for (STE STE : list) {
            try {
                arrayList.add(STE);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return true;
    }

    public static <STE, TTE, SE, TE, SVL, TVL, CTX> TE translateExpressionIteratively(SE SE, ITranslator<?, ?, ?, ?, ?, ?, CTX> ... iTranslatorArray) {
        Object object;
        if (iTranslatorArray.length == 0) {
            object = SE;
        } else {
            ITranslator<?, ?, ?, ?, ?, ?, CTX> iTranslator = iTranslatorArray[iTranslatorArray.length - 1];
            ITranslator<?, ?, ?, ?, ?, ?, CTX>[] iTranslatorArray2 = Arrays.copyOf(iTranslatorArray, iTranslatorArray.length - 1);
            Object object2 = iTranslator.translateExpression(SE);
            object = DefaultTranslator.translateExpressionIteratively(object2, iTranslatorArray2);
        }
        return (TE)object;
    }

    public static <STE, TTE, SE, TE, SVL, TVL, CTX> List<TTE> translateTraceIteratively(List<STE> list, ITranslator<?, ?, ?, ?, ?, ?, CTX> ... iTranslatorArray) {
        List<Object> list2;
        if (iTranslatorArray.length == 0) {
            list2 = list;
        } else {
            ITranslator<?, ?, ?, ?, ?, ?, CTX>[] iTranslatorArray2 = Arrays.copyOf(iTranslatorArray, iTranslatorArray.length - 1);
            list2 = DefaultTranslator.translateTraceIteratively(list, iTranslatorArray2);
        }
        return list2;
    }

    public static <STE, TTE, SE, TE, SVL, TVL, CTX> IProgramExecution<TTE, TE> translateProgramExecutionIteratively(IProgramExecution<STE, SE> iProgramExecution, ITranslator<?, ?, ?, ?, ?, ?, CTX> ... iTranslatorArray) {
        Object object;
        if (iTranslatorArray.length == 0) {
            object = iProgramExecution;
        } else {
            ITranslator<?, ?, ?, ?, ?, ?, CTX> iTranslator = iTranslatorArray[iTranslatorArray.length - 1];
            ITranslator<?, ?, ?, ?, ?, ?, CTX>[] iTranslatorArray2 = Arrays.copyOf(iTranslatorArray, iTranslatorArray.length - 1);
            IProgramExecution iProgramExecution2 = iTranslator.translateProgramExecution(iProgramExecution);
            object = DefaultTranslator.translateProgramExecutionIteratively(iProgramExecution2, iTranslatorArray2);
        }
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" SE=");
        stringBuilder.append(this.getSourceExpressionClass().getName());
        stringBuilder.append(" TE=");
        stringBuilder.append(this.getTargetExpressionClass().getName());
        stringBuilder.append(" STE=");
        stringBuilder.append(this.getSourceTraceElementClass().getName());
        stringBuilder.append(" TTE=");
        stringBuilder.append(this.getTargetTraceElementClass().getName());
        return stringBuilder.toString();
    }

    protected IBacktranslatedCFG<TVL, TTE> translateCFG(IBacktranslatedCFG<SVL, STE> iBacktranslatedCFG, IFunction<Map<IExplicitEdgesMultigraph<?, ?, SVL, ? extends STE, ?>, Multigraph<TVL, TTE>>, IMultigraphEdge<?, ?, SVL, STE, ?>, Multigraph<TVL, TTE>, Multigraph<TVL, TTE>> iFunction, IFunction<String, List<Multigraph<TVL, TTE>>, Class<? extends TTE>, IBacktranslatedCFG<TVL, TTE>> iFunction2) {
        List list = iBacktranslatedCFG.getCFGs();
        ArrayList arrayList = new ArrayList();
        for (IExplicitEdgesMultigraph iExplicitEdgesMultigraph : list) {
            Multigraph multigraph = this.createUnlabeledWitnessNode((IElement)iExplicitEdgesMultigraph);
            HashMap hashMap = new HashMap();
            ArrayDeque<Pair> arrayDeque = new ArrayDeque<Pair>();
            HashSet<IExplicitEdgesMultigraph> hashSet = new HashSet<IExplicitEdgesMultigraph>();
            arrayList.add(multigraph);
            hashMap.put(iExplicitEdgesMultigraph, multigraph);
            arrayDeque.add(new Pair((Object)iExplicitEdgesMultigraph, multigraph));
            while (!arrayDeque.isEmpty()) {
                Pair pair = (Pair)arrayDeque.remove();
                IExplicitEdgesMultigraph iExplicitEdgesMultigraph2 = (IExplicitEdgesMultigraph)pair.getFirst();
                Multigraph multigraph2 = (Multigraph)pair.getSecond();
                if (!hashSet.add(iExplicitEdgesMultigraph2)) continue;
                for (IMultigraphEdge iMultigraphEdge : iExplicitEdgesMultigraph2.getOutgoingEdges()) {
                    Multigraph<TVL, TTE> multigraph3 = iFunction.create(hashMap, iMultigraphEdge, multigraph2);
                    if (multigraph3 == null) continue;
                    arrayDeque.add(new Pair((Object)iMultigraphEdge.getTarget(), multigraph3));
                }
            }
        }
        return iFunction2.create(iBacktranslatedCFG.getFilename(), arrayList, this.mTargetTraceElementType);
    }

    protected IBacktranslatedCFG<TVL, TTE> translateCFG(IBacktranslatedCFG<SVL, STE> iBacktranslatedCFG, IFunction<Map<IExplicitEdgesMultigraph<?, ?, SVL, ? extends STE, ?>, Multigraph<TVL, TTE>>, IMultigraphEdge<?, ?, SVL, STE, ?>, Multigraph<TVL, TTE>, Multigraph<TVL, TTE>> iFunction) {
        return this.translateCFG(iBacktranslatedCFG, iFunction, (string, list, clazz) -> new BacktranslatedCFG((String)string, list, clazz));
    }

    protected <VL> Multigraph<VL, TTE> createLabeledWitnessNode(IExplicitEdgesMultigraph<?, ?, VL, STE, ?> iExplicitEdgesMultigraph) {
        Multigraph multigraph = new Multigraph(iExplicitEdgesMultigraph.getLabel());
        ModelUtils.copyAnnotations(iExplicitEdgesMultigraph, multigraph);
        return multigraph;
    }

    public ProcedureContract<TE, ? extends TE> translateProcedureContract(ProcedureContract<SE, ? extends SE> procedureContract, CTX CTX) {
        Object var3_3 = procedureContract.getRequires() == null ? null : this.translateExpressionWithContext(procedureContract.getRequires(), CTX);
        Object var4_4 = procedureContract.getEnsures() == null ? null : this.translateExpressionWithContext(procedureContract.getEnsures(), CTX);
        Set set = procedureContract.hasModifies() ? procedureContract.getModifies().stream().map(object2 -> this.translateExpressionWithContext(object2, CTX)).collect(Collectors.toSet()) : null;
        return new ProcedureContract(procedureContract.getProcedure(), var3_3, var4_4, set);
    }

    protected <VL> Multigraph<VL, TTE> createUnlabeledWitnessNode(IElement iElement) {
        Multigraph multigraph = new Multigraph(null);
        ModelUtils.copyAnnotations((IElement)iElement, multigraph);
        return multigraph;
    }

    protected void printCFG(IBacktranslatedCFG<?, ?> iBacktranslatedCFG, Consumer<String> consumer) {
        for (IExplicitEdgesMultigraph iExplicitEdgesMultigraph : iBacktranslatedCFG.getCFGs()) {
            ArrayDeque<IExplicitEdgesMultigraph> arrayDeque = new ArrayDeque<IExplicitEdgesMultigraph>();
            HashSet<IExplicitEdgesMultigraph> hashSet = new HashSet<IExplicitEdgesMultigraph>();
            arrayDeque.add(iExplicitEdgesMultigraph);
            while (!arrayDeque.isEmpty()) {
                IExplicitEdgesMultigraph iExplicitEdgesMultigraph2 = (IExplicitEdgesMultigraph)arrayDeque.remove();
                if (!hashSet.add(iExplicitEdgesMultigraph2)) continue;
                consumer.accept(iExplicitEdgesMultigraph2.toString());
                for (IMultigraphEdge iMultigraphEdge : iExplicitEdgesMultigraph2.getOutgoingEdges()) {
                    consumer.accept("  --" + String.valueOf(iMultigraphEdge) + "--> " + String.valueOf(iMultigraphEdge.getTarget()));
                    arrayDeque.add(iMultigraphEdge.getTarget());
                }
            }
        }
    }

    protected void printHondas(IBacktranslatedCFG<?, ?> iBacktranslatedCFG, Consumer<String> consumer) {
        for (IExplicitEdgesMultigraph iExplicitEdgesMultigraph : iBacktranslatedCFG.getCFGs()) {
            Set set = this.getHondas(iExplicitEdgesMultigraph);
            if (set.isEmpty()) {
                consumer.accept("No Hondas");
            }
            for (Object VL : set) {
                consumer.accept("Honda: " + String.valueOf(VL));
            }
        }
    }

    protected <VL, EL> Set<VL> getHondas(IExplicitEdgesMultigraph<?, ?, VL, EL, ?> iExplicitEdgesMultigraph2) {
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        HashSet<IExplicitEdgesMultigraph> hashSet = new HashSet<IExplicitEdgesMultigraph>();
        HashSet<IExplicitEdgesMultigraph> hashSet2 = new HashSet<IExplicitEdgesMultigraph>();
        arrayDeque.add(iExplicitEdgesMultigraph2);
        while (!arrayDeque.isEmpty()) {
            IExplicitEdgesMultigraph iExplicitEdgesMultigraph3 = (IExplicitEdgesMultigraph)arrayDeque.remove();
            if (!hashSet.add(iExplicitEdgesMultigraph3)) {
                hashSet2.add(iExplicitEdgesMultigraph3);
                continue;
            }
            for (IMultigraphEdge iMultigraphEdge : iExplicitEdgesMultigraph3.getOutgoingEdges()) {
                arrayDeque.add(iMultigraphEdge.getTarget());
            }
        }
        return hashSet2.stream().map(iExplicitEdgesMultigraph -> iExplicitEdgesMultigraph.getLabel()).collect(Collectors.toSet());
    }

    protected boolean checkProcedureNames(AtomicTraceElement<STE> atomicTraceElement, AtomicTraceElement<TTE> atomicTraceElement2) {
        return Objects.equals(atomicTraceElement.getSucceedingProcedure(), atomicTraceElement2.getSucceedingProcedure()) && Objects.equals(atomicTraceElement.getPrecedingProcedure(), atomicTraceElement2.getPrecedingProcedure());
    }

    protected boolean checkCallStackSourceProgramExecution(ILogger iLogger, IProgramExecution<STE, SE> iProgramExecution) {
        ArrayList<AtomicTraceElement<STE>> arrayList = new ArrayList<AtomicTraceElement<STE>>();
        iProgramExecution.iterator().forEachRemaining(arrayList::add);
        return this.checkCallStackSource(iLogger, arrayList);
    }

    protected boolean checkCallStackSourceLassoProgramExecution(ILogger iLogger, IBacktranslationService.Lasso<IProgramExecution<STE, SE>> lasso) {
        ArrayList<AtomicTraceElement<STE>> arrayList = new ArrayList<AtomicTraceElement<STE>>();
        lasso.stem().iterator().forEachRemaining(arrayList::add);
        lasso.loop().iterator().forEachRemaining(arrayList::add);
        return this.checkCallStackSource(iLogger, arrayList);
    }

    protected boolean checkCallStackTargetProgramExecution(ILogger iLogger, IProgramExecution<TTE, TE> iProgramExecution) {
        ArrayList<AtomicTraceElement<TTE>> arrayList = new ArrayList<AtomicTraceElement<TTE>>();
        iProgramExecution.iterator().forEachRemaining(arrayList::add);
        return this.checkCallStackTarget(iLogger, arrayList);
    }

    protected boolean checkCallStackTargetLassoProgramExecution(ILogger iLogger, IBacktranslationService.Lasso<IProgramExecution<TTE, TE>> lasso) {
        ArrayList<AtomicTraceElement<TTE>> arrayList = new ArrayList<AtomicTraceElement<TTE>>();
        lasso.stem().iterator().forEachRemaining(arrayList::add);
        lasso.loop().iterator().forEachRemaining(arrayList::add);
        return this.checkCallStackTarget(iLogger, arrayList);
    }

    protected boolean checkCallStackSource(ILogger iLogger, List<AtomicTraceElement<STE>> list) {
        int n = DefaultTranslator.getBrokenCallStackIndexForTrace(iLogger, list);
        if (n == -1) {
            return true;
        }
        this.printBrokenCallStackSource(list, n);
        return false;
    }

    protected boolean checkCallStackTarget(ILogger iLogger, List<AtomicTraceElement<TTE>> list) {
        int n = DefaultTranslator.getBrokenCallStackIndexForTrace(iLogger, list);
        if (n == -1) {
            return true;
        }
        this.printBrokenCallStackTarget(list, n);
        return false;
    }

    private static int getBrokenCallStackIndexForTrace(ILogger iLogger, List<? extends AtomicTraceElement<?>> list) {
        HashMap hashMap = new HashMap();
        hashMap.put(0, new ArrayDeque());
        int n = 0;
        for (AtomicTraceElement<?> atomicTraceElement : list) {
            ++n;
            int n2 = atomicTraceElement.hasThreadId() ? atomicTraceElement.getThreadId() : 0;
            Deque deque = (Deque)hashMap.get(n2);
            if (deque == null) {
                iLogger.fatal("No callstack for unknown thread with threadid %d", new Object[]{n2});
                return n;
            }
            if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.PROC_CALL)) {
                if (atomicTraceElement.getSucceedingProcedure() == null) {
                    iLogger.fatal((Object)("Callstack has procedure call flag but succeeding procedure is empty at " + String.valueOf(atomicTraceElement)));
                    return n;
                }
                deque.push(atomicTraceElement.getSucceedingProcedure());
            }
            if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.PROC_RETURN)) {
                if (deque.isEmpty()) {
                    iLogger.fatal((Object)("Callstack is empty and returning with " + String.valueOf(atomicTraceElement)));
                    return n;
                }
                String string = (String)deque.pop();
                if (!string.equals(atomicTraceElement.getPrecedingProcedure())) {
                    iLogger.fatal((Object)("Callstack is " + string + " but returning with " + String.valueOf(atomicTraceElement)));
                    return n;
                }
            }
            if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.FORK)) {
                if (hashMap.containsKey(atomicTraceElement.getForkedThreadId())) {
                    iLogger.fatal("Forking thread with threadid %d which is already in use", new Object[]{atomicTraceElement.getForkedThreadId()});
                    return n;
                }
                hashMap.put(atomicTraceElement.getForkedThreadId(), new ArrayDeque());
            }
            if (!atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.JOIN)) continue;
            if (!hashMap.containsKey(atomicTraceElement.getJoinedThreadId())) {
                iLogger.fatal("Joining thread with threadid %d which does not exist", new Object[]{atomicTraceElement.getJoinedThreadId()});
                return n;
            }
            hashMap.remove(atomicTraceElement.getJoinedThreadId());
        }
        return -1;
    }

    protected void printBrokenCallStackSource(List<AtomicTraceElement<STE>> list, int n) {
    }

    protected void printBrokenCallStackTarget(List<AtomicTraceElement<TTE>> list, int n) {
    }

    public IProgramExecution.ProgramState<TE> translateProgramState(IProgramExecution.ProgramState<SE> programState) {
        if (programState == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        for (Object e : programState.getVariables()) {
            Object object2;
            ArrayList<TE> arrayList = new ArrayList<TE>();
            for (Object object2 : programState.getValues(e)) {
                arrayList.add(this.translateExpression(object2));
            }
            object2 = this.translateExpression(e);
            hashMap.put(object2, arrayList);
        }
        return new IProgramExecution.ProgramState(hashMap, this.getTargetExpressionClass());
    }

    @FunctionalInterface
    public static interface IFunction<P1, P2, P3, R> {
        public R create(P1 var1, P2 var2, P3 var3);
    }
}

