/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HoareTripleCheckerWithPreconditionRelevanceAnalysis
extends IncrementalHoareTripleChecker {
    private List<IPredicate> mAssertedPrecond;

    public HoareTripleCheckerWithPreconditionRelevanceAnalysis(CfgSmtToolkit cfgSmtToolkit, ILogger iLogger) {
        super(cfgSmtToolkit, false);
    }

    private Script.LBool assertPrecondition(List<IPredicate> list) {
        Object object;
        Object object2;
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "Assert CodeBlock first";
        assert (this.mAssertedPrecond == null) : "precond already asserted";
        this.mAssertedPrecond = list;
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        Script.LBool lBool = null;
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        int n = 0;
        while (n < list.size()) {
            object2 = list.get(n).getClosedFormula();
            object = new Annotation(":named", (Object)this.getIdentifierForPrecond(n));
            object2 = this.mManagedScript.annotate((Object)this, object2, new Annotation[]{object});
            lBool = this.mManagedScript.assertTerm((Object)this, object2);
            hashSet.addAll(list.get(n).getVars());
            ++n;
        }
        String string = this.mAssertedAction.getPrecedingProcedure();
        object2 = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string);
        object = HoareTripleCheckerWithPreconditionRelevanceAnalysis.constructNonModOldVarsEquality(hashSet, (Set<IProgramNonOldVar>)object2, this.mManagedScript, this);
        if (!object.isEmpty()) {
            Term term = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])object.toArray(new Term[object.size()]));
            Annotation annotation = new Annotation(":named", (Object)"precondNonModGlobalEquality");
            term = this.mManagedScript.annotate((Object)this, term, new Annotation[]{annotation});
            lBool = this.mManagedScript.assertTerm((Object)this, term);
        }
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return lBool;
    }

    private String getIdentifierForPrecond(int n) {
        return "precondition" + n;
    }

    private void unAssertPrecondition() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedPrecond != null) : "No PrePred asserted";
        this.mAssertedPrecond = null;
        this.mManagedScript.pop((Object)this, 1);
        if (this.mAssertedAction == null) {
            throw new AssertionError((Object)"CodeBlock is assigned first");
        }
    }

    public Pair<IncrementalPlicationChecker.Validity, List<IPredicate>> checkInternal(List<IPredicate> list, IInternalAction iInternalAction, IPredicate iPredicate) {
        this.assertCodeBlock(iInternalAction);
        this.assertPrecondition(list);
        this.assertPostcond(iPredicate);
        IncrementalPlicationChecker.Validity validity = this.checkValidity();
        List<IPredicate> list2 = validity == IncrementalPlicationChecker.Validity.VALID ? this.determinePreconditionsInUnsatCore() : null;
        this.unAssertPostcondition();
        this.unAssertPrecondition();
        this.unAssertCodeBlock();
        return new Pair((Object)validity, list2);
    }

    private List<IPredicate> determinePreconditionsInUnsatCore() {
        Term term;
        Term[] termArray = this.mManagedScript.getUnsatCore((Object)this);
        HashSet<String> hashSet = new HashSet<String>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term = termArray2[n2];
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            hashSet.add(applicationTerm.getFunction().getApplicationString());
            ++n2;
        }
        term = new ArrayList();
        n2 = 0;
        while (n2 < this.mAssertedPrecond.size()) {
            if (hashSet.contains(this.getIdentifierForPrecond(n2))) {
                term.add(this.mAssertedPrecond.get(n2));
            }
            ++n2;
        }
        return term;
    }

    public Pair<IncrementalPlicationChecker.Validity, List<IPredicate>> checkCall(List<IPredicate> list, ICallAction iCallAction, IPredicate iPredicate) {
        this.assertCodeBlock(iCallAction);
        this.assertPrecondition(list);
        this.assertPostcond(iPredicate);
        IncrementalPlicationChecker.Validity validity = this.checkValidity();
        List<IPredicate> list2 = validity == IncrementalPlicationChecker.Validity.VALID ? this.determinePreconditionsInUnsatCore() : null;
        this.unAssertPostcondition();
        this.unAssertPrecondition();
        this.unAssertCodeBlock();
        return new Pair((Object)validity, list2);
    }

    public Pair<IncrementalPlicationChecker.Validity, List<IPredicate>> checkReturn(List<IPredicate> list, IPredicate iPredicate, IReturnAction iReturnAction, IPredicate iPredicate2) {
        this.assertCodeBlock(iReturnAction);
        this.assertPrecondition(list);
        this.assertHierPred(iPredicate);
        this.assertPostcond(iPredicate2);
        IncrementalPlicationChecker.Validity validity = this.checkValidity();
        List<IPredicate> list2 = validity == IncrementalPlicationChecker.Validity.VALID ? this.determinePreconditionsInUnsatCore() : null;
        this.unAssertPostcondition();
        this.unAssertHierPred();
        this.unAssertPrecondition();
        this.unAssertCodeBlock();
        return new Pair((Object)validity, list2);
    }
}

