/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Behavior;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Completeness;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ContractStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class Contract
extends ACSLNode {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Contract.class);
    ContractStatement[] contractStmt;
    Behavior[] behaviors;
    Completeness completeness;

    public Contract(ContractStatement[] contractStatementArray) {
        this.contractStmt = contractStatementArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Contract: " + String.valueOf(this);
    }

    public Contract(ContractStatement[] contractStatementArray, Behavior[] behaviorArray, Completeness completeness) {
        this.contractStmt = contractStatementArray;
        this.behaviors = behaviorArray;
        this.completeness = completeness;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Contract: " + String.valueOf(this);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Contract").append('[');
        if (this.contractStmt == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.contractStmt.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.contractStmt[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.behaviors == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.behaviors.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.behaviors[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append(this.completeness);
        return stringBuffer.append(']').toString();
    }

    public ContractStatement[] getContractStmt() {
        return this.contractStmt;
    }

    public Behavior[] getBehaviors() {
        return this.behaviors;
    }

    public void setBehaviors(Behavior[] behaviorArray) {
        this.behaviors = behaviorArray;
    }

    public Completeness getCompleteness() {
        return this.completeness;
    }

    public void setCompleteness(Completeness completeness) {
        this.completeness = completeness;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        if (this.contractStmt != null) {
            list.addAll(Arrays.asList(this.contractStmt));
        }
        if (this.behaviors != null) {
            list.addAll(Arrays.asList(this.behaviors));
        }
        list.add(this.completeness);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (aCSLVisitor.visit(this)) {
            ACSLNode aCSLNode;
            int n;
            int n2;
            ACSLNode[] aCSLNodeArray;
            if (this.contractStmt != null) {
                aCSLNodeArray = this.contractStmt;
                n2 = this.contractStmt.length;
                n = 0;
                while (n < n2) {
                    aCSLNode = aCSLNodeArray[n];
                    ((ContractStatement)aCSLNode).accept(aCSLVisitor);
                    ++n;
                }
            }
            if (this.behaviors != null) {
                aCSLNodeArray = this.behaviors;
                n2 = this.behaviors.length;
                n = 0;
                while (n < n2) {
                    aCSLNode = aCSLNodeArray[n];
                    ((Behavior)aCSLNode).accept(aCSLVisitor);
                    ++n;
                }
            }
            if (this.completeness != null) {
                this.completeness.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Contract accept(ACSLTransformer aCSLTransformer) {
        Object object;
        Object object2;
        int n;
        Contract contract = aCSLTransformer.transform(this);
        if (contract != this) {
            return contract;
        }
        boolean bl = false;
        ArrayList<Behavior[]> arrayList = new ArrayList<Behavior[]>();
        if (this.contractStmt != null) {
            ContractStatement[] contractStatementArray = this.contractStmt;
            n = this.contractStmt.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = contractStatementArray[n2];
                object = ((ContractStatement)object2).accept(aCSLTransformer);
                bl = bl || object != object2;
                arrayList.add((Behavior[])object);
                ++n2;
            }
        }
        object2 = new ArrayList();
        if (this.behaviors != null) {
            object = this.behaviors;
            int n3 = this.behaviors.length;
            n = 0;
            while (n < n3) {
                Behavior behavior = object[n];
                Behavior behavior2 = behavior.accept(aCSLTransformer);
                bl = bl || behavior2 != behavior;
                ((ArrayList)object2).add(behavior2);
                ++n;
            }
        }
        Completeness completeness = null;
        if (this.completeness != null) {
            completeness = this.completeness.accept(aCSLTransformer);
        }
        if (bl || this.completeness != completeness) {
            return new Contract(arrayList.toArray(new ContractStatement[0]), ((ArrayList)object2).toArray(new Behavior[0]), completeness);
        }
        return this;
    }
}

