/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;

public class SourceAnnotation
implements IAnnotation {
    public static final SourceAnnotation EMPTY_SOURCE_ANNOT = new SourceAnnotation("", null);
    private final String mAnnot;
    private final Term mProof;
    private final boolean mFromQuantTheory;

    public SourceAnnotation(String string, Term term) {
        this.mAnnot = string;
        this.mProof = term;
        this.mFromQuantTheory = false;
    }

    public SourceAnnotation(SourceAnnotation sourceAnnotation, boolean bl) {
        this.mAnnot = sourceAnnotation.mAnnot;
        this.mProof = sourceAnnotation.mProof;
        this.mFromQuantTheory = bl;
    }

    public SourceAnnotation(SourceAnnotation sourceAnnotation, Term term) {
        this.mAnnot = sourceAnnotation.mAnnot;
        this.mProof = term;
        this.mFromQuantTheory = sourceAnnotation.mFromQuantTheory;
    }

    public String getAnnotation() {
        return this.mAnnot;
    }

    public Term getSource() {
        return this.mProof;
    }

    public boolean isFromQuantTheory() {
        return this.mFromQuantTheory;
    }

    public String toString() {
        return this.mAnnot;
    }

    @Override
    public Term toTerm(Clause clause, ProofRules proofRules) {
        ProofLiteral[] proofLiteralArray = clause.toProofLiterals(proofRules);
        if (this.mProof == null) {
            Annotation[] annotationArray = new Annotation[]{new Annotation(":input", (Object)(this.mAnnot.isEmpty() ? null : this.mAnnot))};
            return proofRules.oracle(proofLiteralArray, annotationArray);
        }
        Annotation[] annotationArray = new Annotation[]{new Annotation(":proves", (Object)ProofRules.convertProofLiteralsToAnnotation(proofLiteralArray)), new Annotation(":input", (Object)(this.mAnnot.isEmpty() ? null : this.mAnnot))};
        return this.mProof.getTheory().annotatedTerm(annotationArray, this.mProof);
    }
}

