/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class CoveringIterator<L>
implements Iterator<Word<L>> {
    private final Word<L> mWord;
    private final IIndependenceRelation<?, L> mIndependence;
    private final Class<L> mClazz;
    private final ArrayDeque<Pair<int[], ImmutableList<L>>> mStack = new ArrayDeque();
    private Word<L> mNextWord;

    private CoveringIterator(Word<L> word, IIndependenceRelation<?, L> iIndependenceRelation, Class<L> clazz) {
        this.mWord = word;
        this.mIndependence = iIndependenceRelation;
        this.mClazz = clazz;
        this.mStack.push(new Pair((Object)IntStream.range(0, this.mWord.length()).toArray(), (Object)ImmutableList.empty()));
    }

    public static <L> Stream<Word<L>> enumerateCoveringWords(Word<L> word, IIndependenceRelation<?, L> iIndependenceRelation, Class<L> clazz) {
        assert (!iIndependenceRelation.isConditional()) : "conditional independence is not yet supported";
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new CoveringIterator<L>(word, iIndependenceRelation, clazz), 1040), false);
    }

    @Override
    public boolean hasNext() {
        if (this.mNextWord != null) {
            return true;
        }
        if (this.mStack.isEmpty()) {
            return false;
        }
        this.searchNextWord();
        return this.mNextWord != null;
    }

    @Override
    public Word<L> next() {
        if (this.mNextWord == null) {
            this.searchNextWord();
        }
        if (this.mNextWord == null) {
            throw new NoSuchElementException();
        }
        Word<L> word = this.mNextWord;
        this.mNextWord = null;
        return word;
    }

    private void searchNextWord() {
        while (!this.mStack.isEmpty()) {
            Pair<int[], ImmutableList<L>> pair = this.mStack.pop();
            ImmutableList immutableList = (ImmutableList)pair.getSecond();
            if (immutableList.size() == this.mWord.length()) {
                this.mNextWord = this.makeWord(immutableList);
                return;
            }
            int[] nArray = (int[])pair.getFirst();
            if (nArray.length < this.mWord.length() - immutableList.size()) continue;
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n3 = 0;
            while (n3 < n) {
                int n4 = nArray2[n3];
                L l = this.mWord.getSymbol(n4);
                int[] nArray3 = Arrays.stream(nArray).filter(n2 -> n2 != n4 && (n4 < n2 || this.mIndependence.isIndependent(null, this.mWord.getSymbol(n2), l) == IIndependenceRelation.Dependence.INDEPENDENT)).toArray();
                this.mStack.push(new Pair((Object)nArray3, (Object)new ImmutableList(l, immutableList)));
                ++n3;
            }
        }
    }

    private Word<L> makeWord(ImmutableList<L> immutableList) {
        Object[] objectArray = (Object[])Array.newInstance(this.mClazz, immutableList.size());
        int n = immutableList.size() - 1;
        for (Object e : immutableList) {
            objectArray[n] = e;
            --n;
        }
        return new Word<Object>(objectArray);
    }
}

