/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityLocUpdateInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.NoStoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Objects;

public class StoreInfo {
    private final EdgeInfo mEdgeInfo;
    private final Term mStoreTerm;
    private final ArrayGroup mArrayGroup;
    private final ArrayIndex mEnclosingIndices;
    private final Term mStoreIndex;
    private final int mId;
    private final IProgramConst mLocLit;
    private final SubtreePosition mSubtreePosition;
    private final ArrayEqualityLocUpdateInfo mEnclosingEquality;
    private final SubtreePosition mPositionOfStoredValueRelativeToEquality;

    public StoreInfo(int n, EdgeInfo edgeInfo, SubtreePosition subtreePosition, Term term, ArrayGroup arrayGroup, ArrayIndex arrayIndex, IProgramConst iProgramConst, ArrayEqualityLocUpdateInfo arrayEqualityLocUpdateInfo, SubtreePosition subtreePosition2) {
        assert (this instanceof NoStoreInfo || Objects.nonNull(edgeInfo) && Objects.nonNull(term) && Objects.nonNull(arrayGroup) && Objects.nonNull(iProgramConst) && n >= 0);
        this.mEdgeInfo = edgeInfo;
        this.mSubtreePosition = subtreePosition;
        this.mStoreTerm = term;
        this.mArrayGroup = arrayGroup;
        this.mEnclosingIndices = arrayIndex;
        this.mLocLit = iProgramConst;
        this.mEnclosingEquality = arrayEqualityLocUpdateInfo;
        if (this instanceof NoStoreInfo) {
            this.mPositionOfStoredValueRelativeToEquality = null;
            this.mStoreIndex = null;
        } else {
            Term term2;
            this.mPositionOfStoredValueRelativeToEquality = subtreePosition2.append(2);
            assert (this.mEnclosingEquality != null);
            assert (SmtUtils.isFunctionApplication((Term)term, (String)"store")) : "expecting store term";
            this.mEnclosingEquality.addEnclosedStoreInfo(this, subtreePosition2);
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            this.mStoreIndex = term2 = applicationTerm.getParameters()[1];
        }
        this.mId = n;
    }

    public EdgeInfo getEdgeInfo() {
        return this.mEdgeInfo;
    }

    public Term getStoreTerm() {
        return this.mStoreTerm;
    }

    public Term getStoreIndex() {
        return this.mStoreIndex;
    }

    public ArrayIndex getEnclosingIndices() {
        return this.mEnclosingIndices;
    }

    public ArrayGroup getArrayGroup() {
        return this.mArrayGroup;
    }

    public Integer getDimension() {
        return this.mEnclosingIndices.size() + 1;
    }

    public String toString() {
        return "(Store [" + this.mId + "] at" + String.valueOf(this.mEdgeInfo) + " with " + String.valueOf(this.mStoreTerm) + ")";
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StoreInfo storeInfo = (StoreInfo)object;
        return this.mId == storeInfo.mId;
    }

    public IProgramConst getLocLiteral() {
        return this.mLocLit;
    }

    public int getId() {
        return this.mId;
    }

    public boolean isOutermost() {
        return this.getDimension() == 1;
    }

    public SubtreePosition getPositionOfStoredValueRelativeToEquality() {
        return this.mPositionOfStoredValueRelativeToEquality;
    }

    public SubtreePosition getPosition() {
        return this.mSubtreePosition;
    }

    public static StoreInfo buildStoreInfo(int n, EdgeInfo edgeInfo, SubtreePosition subtreePosition, ApplicationTerm applicationTerm, ArrayGroup arrayGroup, ArrayIndex arrayIndex, IProgramConst iProgramConst, ArrayEqualityLocUpdateInfo arrayEqualityLocUpdateInfo, SubtreePosition subtreePosition2) {
        return new StoreInfo(n, edgeInfo, subtreePosition, (Term)applicationTerm, arrayGroup, arrayIndex, iProgramConst, arrayEqualityLocUpdateInfo, subtreePosition2);
    }
}

