/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermWrapper;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ArrayStore
implements ITermWrapper {
    private final Term mArray;
    private final Term mIndex;
    private final Term mValue;
    private final Term mTerm;

    public ArrayStore(Term term, Term term2, Term term3, Term term4) {
        this.mArray = term;
        this.mIndex = term2;
        this.mValue = term3;
        this.mTerm = term4;
    }

    public Term getArray() {
        return this.mArray;
    }

    public Term getIndex() {
        return this.mIndex;
    }

    public Term getValue() {
        return this.mValue;
    }

    @Override
    public Term getTerm() {
        return this.mTerm;
    }

    public String toString() {
        return String.valueOf(this.mTerm);
    }

    public ArrayStore applySubstitution(ManagedScript managedScript, Map<Term, Term> map) {
        Term term = Substitution.apply(managedScript, map, this.mArray);
        Term term2 = Substitution.apply(managedScript, map, this.mIndex);
        Term term3 = Substitution.apply(managedScript, map, this.mValue);
        if (term == this.mArray && term2 == this.mIndex && term3 == this.mValue) {
            return this;
        }
        Term term4 = SmtUtils.store(managedScript.getScript(), term, term2, term3);
        return new ArrayStore(term, term2, term3, term4);
    }

    public int hashCode() {
        return Objects.hash(this.mTerm);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ArrayStore arrayStore = (ArrayStore)object;
        return !(this.mTerm == null ? arrayStore.mTerm != null : !this.mTerm.equals(arrayStore.mTerm));
    }

    public static ArrayStore of(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            return null;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        if (!applicationTerm.getFunction().isIntern()) {
            return null;
        }
        if (!applicationTerm.getFunction().getName().equals("store")) {
            return null;
        }
        assert (applicationTerm.getParameters().length == 3);
        return new ArrayStore(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1], applicationTerm.getParameters()[2], (Term)applicationTerm);
    }

    public static Collection<ArrayStore> extractStores(Term term, boolean bl) {
        Set<ApplicationTerm> set = SmtUtils.extractApplicationTerms("store", term, bl);
        return set.stream().map(ArrayStore::of).collect(Collectors.toList());
    }
}

